/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.core.io;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;

public class IOResources {
    private static IWorkspace workspace = ResourcesPlugin.getWorkspace();

    private IOResources() {
    }

    public static void setWorkspace(IWorkspace workspace) {
        IOResources.workspace = workspace;
    }

    public static Optional<File> toFile(URI uri) {
        IResource file;
        if (workspace != null && (file = workspace.getRoot().findMember(uri.toPlatformString(true))) != null) {
            String path = file.getLocationURI().getRawPath();
            return Optional.of(new File(path));
        }
        return Optional.empty();
    }

    public static Optional<File> toFile(IFile ifile) {
        try {
            File file = new File(ifile.getLocationURI());
            return Optional.of(file);
        }
        catch (NullPointerException e) {
            return Optional.empty();
        }
    }

    public static Optional<IFile> toIFile(URI uri) {
        Path path = new Path(uri.toPlatformString(true));
        IFile ifile = workspace.getRoot().getFile((IPath)path);
        return Optional.ofNullable(ifile);
    }

    public static IFile toIFile(File file) {
        return FileBuffers.getWorkspaceFileAtLocation((IPath)Path.fromOSString((String)file.getPath()));
    }

    public static Set<IFile> toIFiles(File file) {
        java.net.URI location = file.toURI();
        IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(location);
        return new HashSet<IFile>(Arrays.asList(files));
    }

    public static Set<IFile> toIFiles(String uri) {
        try {
            URI behaviorURI = URI.createURI((String)uri);
            return IOResources.toFile(behaviorURI).map(IOResources::toIFiles).orElseGet(HashSet::new);
        }
        catch (NullPointerException e) {
            return new HashSet<IFile>();
        }
    }

    public static URI toPlatformResourceURI(IFile ifile) {
        String pathName = ifile.getFullPath().toPortableString();
        return URI.createPlatformResourceURI((String)pathName, (boolean)true);
    }
}

