/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.quickfix;

import org.eclipse.core.resources.IMarker;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactory;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactoryProvider;
import org.eclipse.sirius.diagram.ui.internal.quickfix.AbstractValidationFix;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.validation.ValidationFix;
import org.eclipse.sirius.viewpoint.description.validation.ViewValidationRule;
import org.eclipse.ui.IEditorPart;

public class ValidationFixResolution
extends AbstractValidationFix {
    private ValidationFix fix;

    public ValidationFixResolution(ValidationFix fix) {
        this.fix = fix;
    }

    public String getLabel() {
        return this.fix.getName();
    }

    @Override
    protected void doExecuteFix(IMarker marker, IEditorPart editor, View markedView, TransactionalEditingDomain transactionalEditingDomain) {
        EObject fixTarget = this.getFixTarget(markedView);
        if (fixTarget != null) {
            Diagram diagram = markedView.getDiagram();
            this.executeFix(editor, (DDiagram)diagram.getElement(), fixTarget, transactionalEditingDomain);
            this.revalidate(editor, (View)diagram);
        }
    }

    private EObject getFixTarget(View markedView) {
        EObject fixTarget = markedView.getElement();
        if (fixTarget instanceof DSemanticDecorator && !this.isViewValidationRule()) {
            fixTarget = ((DSemanticDecorator)fixTarget).getTarget();
        }
        return fixTarget;
    }

    private boolean isViewValidationRule() {
        return this.fix.eContainer() instanceof ViewValidationRule;
    }

    private void executeFix(IEditorPart editor, DDiagram diagram, EObject fixTarget, TransactionalEditingDomain domain) {
        IDiagramCommandFactory commandFactory = this.getDiagramCommandFactory(editor, domain);
        if (commandFactory != null && fixTarget != null) {
            Command fixCommand = commandFactory.buildQuickFixOperation(this.fix, fixTarget, diagram);
            EObject semanticTarget = this.getSemanticTarget(fixTarget);
            Session session = SessionManager.INSTANCE.getSession(semanticTarget);
            if (session != null) {
                session.getRefreshEditorsListener().setForceRefresh(true);
            }
            domain.getCommandStack().execute(fixCommand);
        }
    }

    private EObject getSemanticTarget(EObject fixTarget) {
        EObject semanticTarget = fixTarget;
        if (semanticTarget instanceof DSemanticDecorator) {
            semanticTarget = ((DSemanticDecorator)semanticTarget).getTarget();
        }
        return semanticTarget;
    }

    private IDiagramCommandFactory getDiagramCommandFactory(IEditorPart editor, TransactionalEditingDomain domain) {
        Object adapter = editor.getAdapter(IDiagramCommandFactoryProvider.class);
        IDiagramCommandFactoryProvider diagramCmdFactoryProvider = (IDiagramCommandFactoryProvider)adapter;
        return diagramCmdFactoryProvider.getCommandFactory(domain);
    }
}

