/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.nd.java;

import java.util.List;
import org.aspectj.org.eclipse.jdt.internal.core.nd.INdVisitor;
import org.aspectj.org.eclipse.jdt.internal.core.nd.Nd;
import org.aspectj.org.eclipse.jdt.internal.core.nd.db.IString;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.FieldByte;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.FieldLong;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.FieldManyToOne;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.FieldOneToMany;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.FieldString;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.StructDef;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.JavaNames;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdAnnotationInType;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdBinding;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdMethod;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdMethodId;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdResourceFile;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdTypeAnnotationInType;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdTypeId;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdTypeInterface;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdTypeParameter;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdTypeSignature;
import org.aspectj.org.eclipse.jdt.internal.core.nd.util.CharArrayUtils;
import org.eclipse.core.runtime.CoreException;

public class NdType
extends NdBinding {
    public static final FieldManyToOne<NdTypeId> TYPENAME;
    public static final FieldManyToOne<NdTypeSignature> SUPERCLASS;
    public static final FieldOneToMany<NdTypeInterface> INTERFACES;
    public static final FieldManyToOne<NdTypeId> DECLARING_TYPE;
    public static final FieldManyToOne<NdMethodId> DECLARING_METHOD;
    public static final FieldOneToMany<NdMethod> METHODS;
    public static final FieldOneToMany<NdTypeAnnotationInType> TYPE_ANNOTATIONS;
    public static final FieldOneToMany<NdAnnotationInType> ANNOTATIONS;
    public static final FieldString MISSING_TYPE_NAMES;
    public static final FieldString SOURCE_FILE_NAME;
    public static final FieldString INNER_CLASS_SOURCE_NAME;
    public static final FieldByte FLAGS;
    public static final FieldLong TAG_BITS;
    public static final FieldString FIELD_DESCRIPTOR_FROM_CLASS;
    public static final StructDef<NdType> type;
    public static final byte FLG_TYPE_ANONYMOUS = 1;
    public static final byte FLG_TYPE_LOCAL = 2;
    public static final byte FLG_TYPE_MEMBER = 4;
    public static final byte FLG_GENERIC_SIGNATURE_PRESENT = 8;

    static {
        type = StructDef.create(NdType.class, NdBinding.type);
        TYPENAME = FieldManyToOne.create(type, NdTypeId.TYPES);
        DECLARING_TYPE = FieldManyToOne.create(type, NdTypeId.DECLARED_TYPES);
        INTERFACES = FieldOneToMany.create(type, NdTypeInterface.APPLIES_TO);
        SUPERCLASS = FieldManyToOne.create(type, NdTypeSignature.SUBCLASSES);
        DECLARING_METHOD = FieldManyToOne.create(type, NdMethodId.DECLARED_TYPES);
        METHODS = FieldOneToMany.create(type, NdMethod.PARENT, 6);
        TYPE_ANNOTATIONS = FieldOneToMany.create(type, NdTypeAnnotationInType.OWNER);
        ANNOTATIONS = FieldOneToMany.create(type, NdAnnotationInType.OWNER);
        MISSING_TYPE_NAMES = type.addString();
        SOURCE_FILE_NAME = type.addString();
        INNER_CLASS_SOURCE_NAME = type.addString();
        FLAGS = type.addByte();
        TAG_BITS = type.addLong();
        FIELD_DESCRIPTOR_FROM_CLASS = type.addString();
        type.done();
    }

    public NdType(Nd nd, long address) {
        super(nd, address);
    }

    public NdType(Nd nd, NdResourceFile resource) {
        super(nd, resource);
    }

    public void acceptUncached(INdVisitor visitor) throws CoreException {
        super.accept(visitor);
    }

    public NdTypeId getTypeId() {
        return TYPENAME.get(this.getNd(), this.address);
    }

    public void setTypeId(NdTypeId typeId) {
        TYPENAME.put(this.getNd(), this.address, typeId);
    }

    public void setSourceNameOverride(char[] sourceName) {
        char[] oldSourceName = this.getSourceName();
        if (!CharArrayUtils.equals(oldSourceName, sourceName)) {
            INNER_CLASS_SOURCE_NAME.put(this.getNd(), this.address, sourceName);
        }
    }

    public IString getSourceNameOverride() {
        return INNER_CLASS_SOURCE_NAME.get(this.getNd(), this.address);
    }

    public long getResourceAddress() {
        return NdBinding.FILE.getAddress(this.getNd(), this.address);
    }

    public void setSuperclass(NdTypeSignature superclassTypeName) {
        SUPERCLASS.put(this.getNd(), this.address, superclassTypeName);
    }

    public NdTypeSignature getSuperclass() {
        return SUPERCLASS.get(this.getNd(), this.address);
    }

    public List<NdTypeInterface> getInterfaces() {
        return INTERFACES.asList(this.getNd(), this.address);
    }

    public NdResourceFile getResourceFile() {
        return NdBinding.FILE.get(this.getNd(), this.address);
    }

    public void setDeclaringMethod(NdMethodId createMethodId) {
        DECLARING_METHOD.put(this.getNd(), this.address, createMethodId);
    }

    public void setDeclaringType(NdTypeId createTypeIdFromBinaryName) {
        DECLARING_TYPE.put(this.getNd(), this.address, createTypeIdFromBinaryName);
    }

    public NdTypeId getDeclaringType() {
        return DECLARING_TYPE.get(this.getNd(), this.address);
    }

    public void setMissingTypeNames(char[] contents) {
        MISSING_TYPE_NAMES.put(this.getNd(), this.address, contents);
    }

    public IString getMissingTypeNames() {
        return MISSING_TYPE_NAMES.get(this.getNd(), this.address);
    }

    public void setSourceFileName(char[] sourceFileName) {
        SOURCE_FILE_NAME.put(this.getNd(), this.address, sourceFileName);
    }

    public IString getSourceFileName() {
        return SOURCE_FILE_NAME.get(this.getNd(), this.address);
    }

    public void setAnonymous(boolean anonymous) {
        this.setFlag((byte)1, anonymous);
    }

    public void setIsLocal(boolean local) {
        this.setFlag((byte)2, local);
    }

    public void setIsMember(boolean member) {
        this.setFlag((byte)4, member);
    }

    public boolean isAnonymous() {
        return this.getFlag((byte)1);
    }

    public boolean isLocal() {
        return this.getFlag((byte)2);
    }

    public boolean isMember() {
        return this.getFlag((byte)4);
    }

    public void setFlag(byte flagConstant, boolean value) {
        byte oldFlags = FLAGS.get(this.getNd(), this.address);
        int newFlags = oldFlags & ~flagConstant | (value ? flagConstant : (byte)0);
        FLAGS.put(this.getNd(), this.address, (byte)newFlags);
    }

    public boolean getFlag(byte flagConstant) {
        return (FLAGS.get(this.getNd(), this.address) & flagConstant) != 0;
    }

    public char[] getSourceName() {
        IString sourceName = this.getSourceNameOverride();
        if (sourceName.length() != 0) {
            return sourceName.getChars();
        }
        char[] simpleName = this.getTypeId().getSimpleNameCharArray();
        return JavaNames.simpleNameToSourceName(simpleName);
    }

    public NdMethodId getDeclaringMethod() {
        return DECLARING_METHOD.get(this.getNd(), this.address);
    }

    @Override
    public List<NdTypeParameter> getTypeParameters() {
        return NdBinding.TYPE_PARAMETERS.asList(this.getNd(), this.address);
    }

    public List<NdTypeAnnotationInType> getTypeAnnotations() {
        return TYPE_ANNOTATIONS.asList(this.getNd(), this.address);
    }

    public List<NdAnnotationInType> getAnnotations() {
        return ANNOTATIONS.asList(this.getNd(), this.address);
    }

    public List<NdMethod> getMethods() {
        return METHODS.asList(this.getNd(), this.address);
    }

    public String toString() {
        try {
            return "class " + new String(this.getSourceName());
        }
        catch (RuntimeException e) {
            return super.toString();
        }
    }

    public void setTagBits(long tagBits) {
        TAG_BITS.put(this.getNd(), this.address, tagBits);
    }

    public long getTagBits() {
        return TAG_BITS.get(this.getNd(), this.address);
    }

    public void setFieldDescriptorFromClass(char[] fieldDescriptorFromClass) {
        FIELD_DESCRIPTOR_FROM_CLASS.put(this.getNd(), this.address, fieldDescriptorFromClass);
    }

    public IString getFieldDescriptor() {
        IString descriptorFromClass = FIELD_DESCRIPTOR_FROM_CLASS.get(this.getNd(), this.address);
        if (descriptorFromClass.length() == 0) {
            return this.getTypeId().getFieldDescriptor();
        }
        return descriptorFromClass;
    }
}

