/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.ant.taskdefs.compilers;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.compilers.DefaultCompilerAdapter;
import org.apache.tools.ant.types.Commandline;
import org.aspectj.tools.ant.taskdefs.Ajc2;

public class Ajc
extends DefaultCompilerAdapter {
    public static final int AJC_COMPILER_SUCCESS = 0;
    private static final String MAIN_CLASS_NAME = "org.aspectj.tools.ajc.Main";
    static final List javacOnlyFlags = Ajc.finalList(new String[]{"-g:none", "-g:lines", "-g:vars", "-g:source", "-nowarn"});
    static final List javacOnlyArgs = Ajc.finalList(new String[]{"-sourcepath", "-encoding", "-target"});

    private static List finalList(String[] args) {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(Arrays.asList(args));
        return Collections.unmodifiableList(result);
    }

    public boolean execute() throws BuildException {
        this.attributes.log("Using AJC", 3);
        return this.compile(this.addAjcOptions(this.setupJavacCommand()));
    }

    private boolean compile(Commandline cline) throws BuildException {
        PrintStream err = System.err;
        PrintStream out = System.out;
        try {
            Class<?> main = Class.forName(MAIN_CLASS_NAME);
            if (main == null) {
                throw new ClassNotFoundException(MAIN_CLASS_NAME);
            }
            PrintStream logstr = new PrintStream((OutputStream)new LogOutputStream((Task)this.attributes, 1));
            System.setOut(logstr);
            System.setErr(logstr);
            boolean bl = (Integer)main.getMethod("compile", String[].class).invoke(main.newInstance(), new Object[]{this.removeUnsupported(cline, logstr)}) == 0;
            return bl;
        }
        catch (Exception e) {
            if (e instanceof BuildException) {
                throw (BuildException)e;
            }
            throw new BuildException("Error starting AJC compiler", (Throwable)e, this.location);
        }
        finally {
            System.setErr(err);
            System.setOut(out);
        }
    }

    private String[] removeUnsupported(Commandline cline, PrintStream log) {
        if (null == log) {
            log = System.err;
        }
        String[] args = cline.getCommandline();
        ArrayList<String> argsList = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (javacOnlyFlags.contains(arg)) {
                log.println("ignored by ajc " + arg);
                continue;
            }
            if (javacOnlyArgs.contains(arg)) {
                if (++i < args.length) {
                    arg = arg + " " + args[i];
                }
                log.println("ignored by ajc " + arg);
                continue;
            }
            argsList.add(args[i]);
        }
        return argsList.toArray(new String[argsList.size()]);
    }

    private Commandline addAjcOptions(Commandline cline) throws BuildException {
        Javac javac = this.getJavac();
        Ajc2 ajc = null;
        try {
            ajc = (Ajc2)javac;
        }
        catch (ClassCastException cce) {
            throw new BuildException(cce + "");
        }
        if (ajc.getThreads() != null) {
            cline.createArgument().setValue("-threads");
            cline.createArgument().setValue(ajc.getThreads() + "");
        }
        if (ajc.getNocomments()) {
            cline.createArgument().setValue("-nocomments");
        }
        if (ajc.getNosymbols()) {
            cline.createArgument().setValue("-nosymbols");
        }
        if (ajc.getPreprocess()) {
            cline.createArgument().setValue("-preprocess");
        }
        if (ajc.getWorkingdir() != null) {
            cline.createArgument().setValue("-workingdir");
            cline.createArgument().setFile(ajc.getWorkingdir());
        }
        return cline;
    }

    protected void logAndAddFilesToCompile(Commandline cmd) {
        this.attributes.log("Compilation args: " + cmd.toString(), 3);
        StringBuffer niceSourceList = new StringBuffer("File");
        if (this.compileList.length != 1) {
            niceSourceList.append("s");
        }
        niceSourceList.append(" to be compiled:");
        niceSourceList.append(lSep);
        for (int i = 0; i < this.compileList.length; ++i) {
            File file = this.compileList[i];
            if (file == null) continue;
            String arg = file.getAbsolutePath();
            String rest = "";
            String name = file.getName();
            if (name.endsWith(".java")) {
                cmd.createArgument().setValue(arg);
            }
            niceSourceList.append("   " + arg + rest + lSep);
        }
        this.attributes.log(niceSourceList.toString(), 3);
    }
}

