/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.memory;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRenderingType;
import org.eclipse.debug.ui.memory.IMemoryRenderingTypeDelegate;

class MemoryRenderingType
implements IMemoryRenderingType {
    private IConfigurationElement fConfigurationElement;
    private IMemoryRenderingTypeDelegate fDelegate;
    static final String ATTR_MEM_RENDERING_TYPE_NAME = "name";
    static final String ATTR_MEM_RENDERING_TYPE_ID = "id";
    static final String ATTR_MEM_RENDERING_TYPE_DELEGATE = "class";

    MemoryRenderingType(IConfigurationElement element) {
        this.fConfigurationElement = element;
    }

    @Override
    public String getLabel() {
        return this.fConfigurationElement.getAttribute(ATTR_MEM_RENDERING_TYPE_NAME);
    }

    @Override
    public String getId() {
        return this.fConfigurationElement.getAttribute(ATTR_MEM_RENDERING_TYPE_ID);
    }

    @Override
    public IMemoryRendering createRendering() throws CoreException {
        if (this.fDelegate == null) {
            this.fDelegate = (IMemoryRenderingTypeDelegate)this.fConfigurationElement.createExecutableExtension(ATTR_MEM_RENDERING_TYPE_DELEGATE);
        }
        return this.fDelegate.createRendering(this.getId());
    }

    void validate() throws CoreException {
        this.verifyPresent(ATTR_MEM_RENDERING_TYPE_ID);
        this.verifyPresent(ATTR_MEM_RENDERING_TYPE_NAME);
        this.verifyPresent(ATTR_MEM_RENDERING_TYPE_DELEGATE);
    }

    private void verifyPresent(String attrName) throws CoreException {
        if (this.fConfigurationElement.getAttribute(attrName) == null) {
            Status status = new Status(4, DebugUIPlugin.getUniqueIdentifier(), 120, "<memoryRenderingType> element missing required attribute: " + attrName, null);
            throw new CoreException((IStatus)status);
        }
    }
}

