/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p3order;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.properties.InternalProperties;
import org.eclipse.elk.alg.layered.properties.LayeredOptions;
import org.eclipse.elk.alg.layered.properties.PortType;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.options.PortSide;

public abstract class AbstractPortDistributor {
    private float[] portRanks;

    public AbstractPortDistributor(float[] portRanks) {
        this.portRanks = portRanks;
    }

    public float[] getPortRanks() {
        return this.portRanks;
    }

    protected abstract float calculatePortRanks(LNode var1, float var2, PortType var3);

    public final void calculatePortRanks(LNode[] layer, PortType portType) {
        float consumedRank = 0.0f;
        int nodeIx = 0;
        while (nodeIx < layer.length) {
            consumedRank += this.calculatePortRanks(layer[nodeIx], consumedRank, portType);
            ++nodeIx;
        }
    }

    public final void distributePorts(LNode[][] layeredGraph) {
        int l = 0;
        while (l < layeredGraph.length) {
            if (l + 1 < layeredGraph.length) {
                this.calculatePortRanks(layeredGraph[l + 1], PortType.INPUT);
            }
            LNode[] layer = layeredGraph[l];
            float consumedRank = 0.0f;
            int i = 0;
            while (i < layer.length) {
                this.distributePorts(layer[i]);
                consumedRank += this.calculatePortRanks(layer[i], consumedRank, PortType.OUTPUT);
                ++i;
            }
            ++l;
        }
    }

    private void distributePorts(LNode node) {
        block12: {
            block13: {
                if (((PortConstraints)node.getProperty(LayeredOptions.PORT_CONSTRAINTS)).isOrderFixed()) break block12;
                if (node.getPorts().size() <= 1) break block13;
                Float[] portBarycenter = new Float[this.portRanks.length];
                ArrayList inLayerPorts = Lists.newArrayListWithCapacity((int)this.portRanks.length);
                float minBarycenter = 0.0f;
                float maxBarycenter = 0.0f;
                float absurdlyLargeFloat = 2 * node.getLayer().getNodes().size() + 1;
                block0: for (LPort port : node.getPorts()) {
                    float sum;
                    boolean northSouthPort;
                    block16: {
                        block14: {
                            boolean output;
                            boolean input;
                            block17: {
                                LNode portDummy;
                                block15: {
                                    northSouthPort = port.getSide() == PortSide.NORTH || port.getSide() == PortSide.SOUTH;
                                    sum = 0.0f;
                                    if (!northSouthPort) break block14;
                                    portDummy = (LNode)((Object)port.getProperty(InternalProperties.PORT_DUMMY));
                                    if (portDummy == null) continue;
                                    input = false;
                                    output = false;
                                    for (LPort lPort : portDummy.getPorts()) {
                                        if (lPort.getProperty(InternalProperties.ORIGIN) != port) continue;
                                        if (!lPort.getOutgoingEdges().isEmpty()) {
                                            output = true;
                                            continue;
                                        }
                                        if (lPort.getIncomingEdges().isEmpty()) continue;
                                        input = true;
                                    }
                                    if (!input || !(input ^ output)) break block15;
                                    sum = port.getSide() == PortSide.NORTH ? (float)(-portDummy.getIndex()) : absurdlyLargeFloat - (float)portDummy.getIndex();
                                    break block16;
                                }
                                if (!output || !(input ^ output)) break block17;
                                sum = (float)portDummy.getIndex() + 1.0f;
                                break block16;
                            }
                            if (!input || !output) break block16;
                            sum = port.getSide() == PortSide.NORTH ? 0.0f : absurdlyLargeFloat / 2.0f;
                            break block16;
                        }
                        for (LEdge outgoingEdge : port.getOutgoingEdges()) {
                            LPort connectedPort = outgoingEdge.getTarget();
                            if (connectedPort.getNode().getLayer() == node.getLayer()) {
                                inLayerPorts.add(port);
                                continue block0;
                            }
                            sum += this.portRanks[connectedPort.id];
                        }
                        for (LEdge incomingEdge : port.getIncomingEdges()) {
                            LPort connectedPort = incomingEdge.getSource();
                            if (connectedPort.getNode().getLayer() == node.getLayer()) {
                                inLayerPorts.add(port);
                                continue block0;
                            }
                            sum -= this.portRanks[connectedPort.id];
                        }
                    }
                    if (port.getDegree() > 0) {
                        portBarycenter[port.id] = Float.valueOf(sum / (float)port.getDegree());
                        minBarycenter = Math.min(minBarycenter, portBarycenter[port.id].floatValue());
                        maxBarycenter = Math.max(maxBarycenter, portBarycenter[port.id].floatValue());
                        continue;
                    }
                    if (!northSouthPort) continue;
                    portBarycenter[port.id] = Float.valueOf(sum);
                }
                int nodeIndexInLayer = node.getIndex() + 1;
                int layerSize = node.getLayer().getNodes().size() + 1;
                for (LPort inLayerPort : inLayerPorts) {
                    int sum = 0;
                    int inLayerConnections = 0;
                    for (LPort connectedPort : inLayerPort.getConnectedPorts()) {
                        if (connectedPort.getNode().getLayer() != node.getLayer()) continue;
                        sum += connectedPort.getNode().getIndex() + 1;
                        ++inLayerConnections;
                    }
                    float barycenter = (float)sum / (float)inLayerConnections;
                    PortSide portSide = inLayerPort.getSide();
                    if (portSide == PortSide.EAST) {
                        if (barycenter < (float)nodeIndexInLayer) {
                            portBarycenter[inLayerPort.id] = Float.valueOf(minBarycenter - barycenter);
                            continue;
                        }
                        portBarycenter[inLayerPort.id] = Float.valueOf(maxBarycenter + ((float)layerSize - barycenter));
                        continue;
                    }
                    if (portSide != PortSide.WEST) continue;
                    portBarycenter[inLayerPort.id] = barycenter < (float)nodeIndexInLayer ? Float.valueOf(maxBarycenter + barycenter) : Float.valueOf(minBarycenter - ((float)layerSize - barycenter));
                }
                AbstractPortDistributor.sortPorts(node, portBarycenter);
            }
            node.setProperty(LayeredOptions.PORT_CONSTRAINTS, PortConstraints.FIXED_ORDER);
        }
    }

    private static void sortPorts(LNode node, final Float[] position) {
        Collections.sort(node.getPorts(), new Comparator<LPort>(){

            @Override
            public int compare(LPort port1, LPort port2) {
                PortSide side2;
                PortSide side1 = port1.getSide();
                if (side1 != (side2 = port2.getSide())) {
                    return side1.ordinal() - side2.ordinal();
                }
                Float pos1 = position[port1.id];
                Float pos2 = position[port2.id];
                if (pos1 == null && pos2 == null) {
                    return 0;
                }
                if (pos1 == null) {
                    return -1;
                }
                if (pos2 == null) {
                    return 1;
                }
                return Float.compare(pos1.floatValue(), pos2.floatValue());
            }
        });
    }
}

