/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.addon.stategraph.layout;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.elk.core.klayoutdata.KShapeLayout;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.service.IDiagramLayoutConnector;
import org.eclipse.elk.core.service.LayoutMapping;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.elk.graph.KEdge;
import org.eclipse.elk.graph.KGraphElement;
import org.eclipse.elk.graph.KNode;
import org.eclipse.elk.graph.properties.IPropertyHolder;
import org.eclipse.elk.graph.properties.Property;
import org.eclipse.gemoc.addon.stategraph.logic.DirectedGraph;
import org.eclipse.gemoc.addon.stategraph.logic.StateGraph;
import org.eclipse.gemoc.addon.stategraph.logic.StateVertex;
import org.eclipse.gemoc.addon.stategraph.views.StateGraphViewPart;
import org.eclipse.gemoc.addon.stategraph.views.VertexView;
import org.eclipse.ui.IWorkbenchPart;

public class StateGraphLayoutConnector
implements IDiagramLayoutConnector {
    private final Property<Map<StateVertex, VertexView>> VERTEX2SHAPE_MAP = new Property("vertex.to.shape.map", new HashMap());

    public LayoutMapping buildLayoutGraph(IWorkbenchPart workbenchPart, Object diagramPart) {
        StateGraphViewPart layoutRootPart = null;
        if (!(workbenchPart instanceof StateGraphViewPart)) {
            return null;
        }
        layoutRootPart = (StateGraphViewPart)workbenchPart;
        StateGraph stateGraph = layoutRootPart.getStateGraph();
        LayoutMapping mapping = new LayoutMapping(workbenchPart);
        mapping.setParentElement((Object)layoutRootPart);
        KNode topNode = ElkUtil.createInitializedNode();
        mapping.getGraphMap().put((Object)topNode, (Object)layoutRootPart);
        mapping.setLayoutGraph(topNode);
        Set<StateVertex> movedVertice = layoutRootPart.getMovedVertice();
        ArrayList vertice = new ArrayList(stateGraph.getVertice());
        vertice.removeAll(movedVertice);
        for (StateVertex vertex : vertice) {
            KNode node = this.createNode(mapping, vertex, topNode);
            mapping.getGraphMap().put((Object)node, (Object)vertex);
        }
        List edges = stateGraph.getEdges().stream().filter(e -> !movedVertice.contains(e.getSource()) && !movedVertice.contains(e.getTarget())).collect(Collectors.toList());
        for (DirectedGraph.Edge edge : edges) {
            KEdge kEdge = this.createEdge(mapping, edge);
            mapping.getGraphMap().put((Object)kEdge, (Object)edge);
        }
        return mapping;
    }

    private KNode createNode(LayoutMapping mapping, StateVertex nodeStateVertex, KNode rootNode) {
        KNode childLayoutNode = ElkUtil.createInitializedNode();
        rootNode.getChildren().add((Object)childLayoutNode);
        KShapeLayout nodeLayout = (KShapeLayout)childLayoutNode.getData(KShapeLayout.class);
        nodeLayout.setSize(24.0f, 24.0f);
        nodeLayout.resetModificationFlag();
        nodeLayout.setProperty(CoreOptions.NODE_SIZE_MINIMUM, (Object)new KVector(24.0, 24.0));
        mapping.getGraphMap().put((Object)childLayoutNode, (Object)nodeStateVertex);
        return childLayoutNode;
    }

    private KEdge createEdge(LayoutMapping mapping, DirectedGraph.Edge<StateVertex> edge) {
        KEdge layoutEdge = ElkUtil.createInitializedEdge();
        layoutEdge.setSource((KNode)mapping.getGraphMap().inverse().get((Object)edge.getSource()));
        layoutEdge.setTarget((KNode)mapping.getGraphMap().inverse().get((Object)edge.getTarget()));
        mapping.getGraphMap().put((Object)layoutEdge, edge);
        return layoutEdge;
    }

    public void applyLayout(LayoutMapping layoutMapping, IPropertyHolder propertyHolder) {
        for (Map.Entry entry : layoutMapping.getGraphMap().entrySet()) {
            KShapeLayout layout = (KShapeLayout)((KGraphElement)entry.getKey()).getData(KShapeLayout.class);
            if (layout == null) continue;
            double xPos = layout.getXpos();
            double yPos = layout.getYpos();
            Map map = (Map)layout.getProperty(this.VERTEX2SHAPE_MAP);
            Optional.ofNullable((VertexView)((Object)map.get(entry.getValue()))).ifPresent(v -> {
                v.setTranslateX(xPos);
                v.setTranslateY(yPos);
            });
        }
    }
}

