/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.commons.eclipse.messagingsystem.ui;

import java.io.PrintStream;
import org.eclipse.gemoc.commons.eclipse.messagingsystem.ui.helper.TeeOutputStream;
import org.eclipse.gemoc.commons.eclipse.messagingsystem.ui.internal.EclipseConsoleOutputStream;
import org.eclipse.gemoc.commons.eclipse.messagingsystem.ui.internal.console.ConsoleIO;
import org.eclipse.gemoc.commons.eclipse.messagingsystem.ui.internal.console.EclipseConsoleIO;
import org.eclipse.gemoc.commons.eclipse.messagingsystem.ui.internal.console.EclipseConsoleIOFactory;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.gemoc.commons.eclipse.messagingsystem.ui";
    private static Activator plugin;
    protected EclipseConsoleIO consoleIO = null;
    protected PrintStream originalSystemOut = null;
    protected PrintStream originalSystemErr = null;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Boolean mustCapture = Activator.this.getPreferenceStore().getBoolean("capture_system_err_out_Preference");
                if (mustCapture.booleanValue()) {
                    Activator.this.captureSystemOutAndErr();
                }
            }
        });
    }

    public void stop(BundleContext context) throws Exception {
        this.releaseSystemOutAndErr();
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public void clearConsole() {
        this.getConsoleIO().clear();
    }

    public ConsoleIO getConsoleIO() {
        if (this.consoleIO == null) {
            String bundleSymbolicName = ((String)this.getBundle().getHeaders().get("Bundle-SymbolicName")).toString();
            String consoleUId = String.valueOf(bundleSymbolicName) + ((Object)((Object)this)).hashCode();
            this.consoleIO = EclipseConsoleIOFactory.getInstance().getConsoleIO(consoleUId, "Default MessagingSystem console");
        }
        return this.consoleIO;
    }

    public void captureSystemOutAndErr() {
        TeeOutputStream teeOutputStream;
        Activator.getDefault().getConsoleIO().print("Redirecting System.out and System.err to this console.\n");
        if (this.originalSystemOut != System.out) {
            this.originalSystemOut = System.out;
            teeOutputStream = new TeeOutputStream(this.originalSystemOut, new EclipseConsoleOutputStream(Activator.getDefault().getConsoleIO(), false));
            System.setOut(new PrintStream(teeOutputStream));
        }
        if (this.originalSystemErr != System.err) {
            this.originalSystemErr = System.err;
            teeOutputStream = new TeeOutputStream(this.originalSystemErr, new EclipseConsoleOutputStream(Activator.getDefault().getConsoleIO(), true));
            System.setErr(new PrintStream(teeOutputStream));
        }
    }

    public void releaseSystemOutAndErr() {
        if (System.out != null) {
            System.out.flush();
        }
        if (System.err != null) {
            System.err.flush();
        }
        if (this.consoleIO != null) {
            this.consoleIO.print("Stopping redirection of System.out and System.err to this console.\n");
        }
        if (this.originalSystemOut != null) {
            System.setOut(this.originalSystemOut);
        }
        if (this.originalSystemErr != null) {
            System.setErr(this.originalSystemErr);
        }
        this.originalSystemOut = null;
        this.originalSystemErr = null;
    }
}

