/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.dsl.debug.ide.adapter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gemoc.dsl.debug.DebugTarget;
import org.eclipse.gemoc.dsl.debug.DebugTargetState;
import org.eclipse.gemoc.dsl.debug.DebugTargetUtils;
import org.eclipse.gemoc.dsl.debug.StackFrame;
import org.eclipse.gemoc.dsl.debug.Thread;
import org.eclipse.gemoc.dsl.debug.Variable;
import org.eclipse.gemoc.dsl.debug.ide.Activator;
import org.eclipse.gemoc.dsl.debug.ide.DSLBreakpoint;
import org.eclipse.gemoc.dsl.debug.ide.DSLEclipseDebugIntegration;
import org.eclipse.gemoc.dsl.debug.ide.adapter.AbstractDSLDebugElementAdapter;
import org.eclipse.gemoc.dsl.debug.ide.adapter.DSLThreadAdapter;
import org.eclipse.gemoc.dsl.debug.ide.adapter.IDSLCurrentInstructionListener;
import org.eclipse.gemoc.dsl.debug.ide.event.IDSLDebugEvent;
import org.eclipse.gemoc.dsl.debug.ide.event.IDSLDebugEventProcessor;
import org.eclipse.gemoc.dsl.debug.ide.event.debugger.BreakpointReply;
import org.eclipse.gemoc.dsl.debug.ide.event.debugger.DeleteVariableReply;
import org.eclipse.gemoc.dsl.debug.ide.event.debugger.PopStackFrameReply;
import org.eclipse.gemoc.dsl.debug.ide.event.debugger.PushStackFrameReply;
import org.eclipse.gemoc.dsl.debug.ide.event.debugger.ResumingReply;
import org.eclipse.gemoc.dsl.debug.ide.event.debugger.SetCurrentInstructionReply;
import org.eclipse.gemoc.dsl.debug.ide.event.debugger.SetVariableValueReply;
import org.eclipse.gemoc.dsl.debug.ide.event.debugger.SpawnRunningThreadReply;
import org.eclipse.gemoc.dsl.debug.ide.event.debugger.StepIntoResumingReply;
import org.eclipse.gemoc.dsl.debug.ide.event.debugger.StepOverResumingReply;
import org.eclipse.gemoc.dsl.debug.ide.event.debugger.StepReturnResumingReply;
import org.eclipse.gemoc.dsl.debug.ide.event.debugger.SteppedReply;
import org.eclipse.gemoc.dsl.debug.ide.event.debugger.SuspendedReply;
import org.eclipse.gemoc.dsl.debug.ide.event.debugger.TerminatedReply;
import org.eclipse.gemoc.dsl.debug.ide.event.debugger.VariableReply;
import org.eclipse.gemoc.dsl.debug.ide.event.model.AddBreakpointRequest;
import org.eclipse.gemoc.dsl.debug.ide.event.model.ChangeBreakPointRequest;
import org.eclipse.gemoc.dsl.debug.ide.event.model.DisconnectRequest;
import org.eclipse.gemoc.dsl.debug.ide.event.model.RemoveBreakpointRequest;
import org.eclipse.gemoc.dsl.debug.ide.event.model.ResumeRequest;
import org.eclipse.gemoc.dsl.debug.ide.event.model.StartRequest;
import org.eclipse.gemoc.dsl.debug.ide.event.model.SuspendRequest;
import org.eclipse.gemoc.dsl.debug.ide.event.model.TerminateRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DSLDebugTargetAdapter
extends AbstractDSLDebugElementAdapter
implements IDebugTarget,
IDSLDebugEventProcessor {
    protected final List<IDSLCurrentInstructionListener> currentInstructionListeners = new ArrayList<IDSLCurrentInstructionListener>();

    public DSLDebugTargetAdapter(DSLEclipseDebugIntegration factory) {
        super(factory);
    }

    public void start() {
        IBreakpoint[] breakpoints;
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointListener)this);
        IBreakpoint[] iBreakpointArray = breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(this.getModelIdentifier());
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint breakpoint = iBreakpointArray[n2];
            this.breakpointAdded(breakpoint);
            ++n2;
        }
        this.factory.getDebugger().handleEvent(new StartRequest());
    }

    @Override
    public boolean isAdapterForType(Object type) {
        return type == IDebugTarget.class || super.isAdapterForType(type);
    }

    protected DebugTarget getHost() {
        assert (this.target instanceof DebugTarget);
        return (DebugTarget)this.target;
    }

    public boolean canTerminate() {
        return DebugTargetUtils.canTerminate((DebugTarget)this.getHost());
    }

    public boolean isTerminated() {
        return DebugTargetUtils.isTerminated((DebugTarget)this.getHost());
    }

    public void terminate() throws DebugException {
        this.factory.getModelUpdater().terminateRequest(this.getHost());
        this.factory.getDebugger().handleEvent(new TerminateRequest());
    }

    public boolean canResume() {
        return DebugTargetUtils.canResume((DebugTarget)this.getHost());
    }

    public boolean canSuspend() {
        return DebugTargetUtils.canSuspend((DebugTarget)this.getHost());
    }

    public boolean isSuspended() {
        return DebugTargetUtils.isSuspended((DebugTarget)this.getHost());
    }

    public void resume() throws DebugException {
        this.factory.getDebugger().handleEvent(new ResumeRequest());
    }

    public void suspend() throws DebugException {
        this.factory.getDebugger().handleEvent(new SuspendRequest());
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        block6: {
            if (this.supportsBreakpoint(breakpoint)) {
                try {
                    if (!breakpoint.isEnabled()) break block6;
                    URI uri = ((DSLBreakpoint)breakpoint).getURI();
                    this.factory.getDebugger().handleEvent(new AddBreakpointRequest(uri));
                    try {
                        for (Map.Entry entry : breakpoint.getMarker().getAttributes().entrySet()) {
                            this.factory.getDebugger().handleEvent(new ChangeBreakPointRequest(((DSLBreakpoint)breakpoint).getURI(), (String)entry.getKey(), (Serializable)entry.getValue()));
                        }
                    }
                    catch (CoreException e) {
                        Activator.getDefault().error(e);
                    }
                }
                catch (CoreException e) {
                    Activator.getDefault().error(e);
                }
            }
        }
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (this.supportsBreakpoint(breakpoint)) {
            try {
                if (breakpoint.isEnabled()) {
                    URI uri = ((DSLBreakpoint)breakpoint).getURI();
                    this.factory.getDebugger().handleEvent(new RemoveBreakpointRequest(uri));
                }
            }
            catch (CoreException e) {
                Activator.getDefault().error(e);
            }
        }
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (this.supportsBreakpoint(breakpoint)) {
            try {
                URI uri = ((DSLBreakpoint)breakpoint).getURI();
                IMarker marker = breakpoint.getMarker();
                for (Map.Entry entry : delta.getAttributes().entrySet()) {
                    Object markerValue = marker.getAttribute((String)entry.getKey());
                    Object deltaValue = entry.getValue();
                    if ((markerValue == null || markerValue.equals(deltaValue)) && (deltaValue == null || deltaValue.equals(markerValue))) continue;
                    if (delta.getKind() == 1) {
                        this.factory.getDebugger().handleEvent(new ChangeBreakPointRequest(uri, (String)entry.getKey(), (Serializable)deltaValue));
                        continue;
                    }
                    this.factory.getDebugger().handleEvent(new ChangeBreakPointRequest(uri, (String)entry.getKey(), (Serializable)markerValue));
                }
            }
            catch (CoreException e) {
                Activator.getDefault().error(e);
            }
        }
    }

    public boolean canDisconnect() {
        return DebugTargetUtils.canDisconnect((DebugTarget)this.getHost());
    }

    public void disconnect() throws DebugException {
        this.factory.getDebugger().handleEvent(new DisconnectRequest());
        this.factory.getModelUpdater().disconnectRequest(this.getHost());
    }

    public boolean isDisconnected() {
        return this.getHost().getState() == DebugTargetState.DISCONNECTED;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return null;
    }

    public IProcess getProcess() {
        return null;
    }

    public IThread[] getThreads() throws DebugException {
        ArrayList<DSLThreadAdapter> res = new ArrayList<DSLThreadAdapter>();
        for (Thread thread : this.getHost().getThreads()) {
            res.add(this.factory.getThread(thread));
        }
        return res.toArray(new IThread[res.size()]);
    }

    public boolean hasThreads() throws DebugException {
        return this.getHost().getThreads().size() > 0;
    }

    public String getName() throws DebugException {
        return this.getHost().getName();
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return breakpoint instanceof DSLBreakpoint && breakpoint.getModelIdentifier().equals(this.getModelIdentifier()) && ((DSLBreakpoint)breakpoint).getURI() != null;
    }

    @Override
    public Object handleEvent(IDSLDebugEvent event) {
        Object res = null;
        if (event instanceof SuspendedReply) {
            this.handleSuspendReply((SuspendedReply)event);
        } else if (event instanceof TerminatedReply) {
            this.handleTerminatedReply((TerminatedReply)event);
        } else if (event instanceof SpawnRunningThreadReply) {
            this.handleSpawnRunningThreadReply((SpawnRunningThreadReply)event);
        } else if (event instanceof ResumingReply) {
            this.handleResumingReply((ResumingReply)event);
        } else if (event instanceof VariableReply) {
            this.handleVariableReply((VariableReply)event);
        } else if (event instanceof DeleteVariableReply) {
            this.handleDeleteVariableReply((DeleteVariableReply)event);
        } else if (event instanceof PushStackFrameReply) {
            this.handlePushStackFrameReply((PushStackFrameReply)event);
        } else if (event instanceof PopStackFrameReply) {
            this.handlePopStackFrameReply((PopStackFrameReply)event);
        } else if (event instanceof SetCurrentInstructionReply) {
            this.handleSetCurrentInstructionReply((SetCurrentInstructionReply)event);
        } else if (event instanceof SetVariableValueReply) {
            this.handleSetVariableValueReply((SetVariableValueReply)event);
        }
        return res;
    }

    private void handleSetVariableValueReply(SetVariableValueReply variableValueReply) {
        Thread eThread = DebugTargetUtils.getThread((DebugTarget)this.getHost(), (String)variableValueReply.getThreadName());
        StackFrame eFrame = DebugTargetUtils.getStackFrame((Thread)eThread, (String)variableValueReply.getStackName());
        Variable eVariable = DebugTargetUtils.getVariable((StackFrame)eFrame, (String)variableValueReply.getVariableName());
        this.factory.getModelUpdater().setVariableValueReply(eVariable, variableValueReply.getValue());
        this.factory.getThread(eThread).fireChangeEvent(512);
    }

    private void handleSetCurrentInstructionReply(SetCurrentInstructionReply setCurrentInstructionReply) {
        Thread eThread = DebugTargetUtils.getThread((DebugTarget)this.getHost(), (String)setCurrentInstructionReply.getThreadName());
        this.factory.getModelUpdater().setCurrentInstructionReply(eThread, setCurrentInstructionReply.getInstruction(), setCurrentInstructionReply.isCanStepInto());
        this.factory.getThread(eThread).fireChangeEvent(512);
        this.fireCurrentInstructionChangedEvent(eThread.getTopStackFrame());
    }

    private void handlePopStackFrameReply(PopStackFrameReply popStackFrameReply) {
        Thread eThread = DebugTargetUtils.getThread((DebugTarget)this.getHost(), (String)popStackFrameReply.getThreadName());
        StackFrame eFrame = this.factory.getModelUpdater().popStackFrameReply(eThread);
        this.factory.getThread(eThread).fireChangeEvent(512);
        this.fireCurrentInstructionTerminatedEvent(eFrame);
    }

    private void handlePushStackFrameReply(PushStackFrameReply pushStackFrameReply) {
        Thread eThread = DebugTargetUtils.getThread((DebugTarget)this.getHost(), (String)pushStackFrameReply.getThreadName());
        StackFrame eFrame = this.factory.getModelUpdater().pushStackFrameReply(eThread, pushStackFrameReply.getName(), pushStackFrameReply.getContext(), pushStackFrameReply.getCurrentInstruction(), pushStackFrameReply.isCanStepInto());
        this.factory.getThread(eThread).fireChangeEvent(512);
        this.fireCurrentInstructionChangedEvent(eFrame);
    }

    private void handleDeleteVariableReply(DeleteVariableReply deleteVariableReply) {
        Thread eThread = DebugTargetUtils.getThread((DebugTarget)this.getHost(), (String)deleteVariableReply.getThreadName());
        this.factory.getModelUpdater().deleteVariableReply(eThread, deleteVariableReply.getName());
        this.factory.getThread(eThread).fireChangeEvent(512);
    }

    private void handleVariableReply(VariableReply variableReply) {
        Thread eThread = DebugTargetUtils.getThread((DebugTarget)this.getHost(), (String)variableReply.getThreadName());
        StackFrame eStackFrame = DebugTargetUtils.getStackFrame((Thread)eThread, (String)variableReply.getStackName());
        this.factory.getModelUpdater().setVariableReply(eStackFrame, variableReply.getDeclarationTypeName(), variableReply.getVariableName(), variableReply.getValue(), variableReply.supportModifications());
        this.factory.getThread(eThread).fireChangeEvent(512);
    }

    private void handleResumingReply(ResumingReply resumingReply) {
        Thread eThread = DebugTargetUtils.getThread((DebugTarget)this.getHost(), (String)resumingReply.getThreadName());
        if (resumingReply instanceof StepIntoResumingReply) {
            this.factory.getModelUpdater().stepIntoReply(eThread);
            this.factory.getThread(eThread).fireResumeEvent(1);
        } else if (resumingReply instanceof StepOverResumingReply) {
            this.factory.getModelUpdater().stepOverReply(eThread);
            this.factory.getThread(eThread).fireResumeEvent(2);
        } else if (resumingReply instanceof StepReturnResumingReply) {
            this.factory.getModelUpdater().stepReturnReply(eThread);
            this.factory.getThread(eThread).fireResumeEvent(4);
        } else {
            this.factory.getModelUpdater().resumedReply(eThread);
            this.factory.getThread(eThread).fireResumeEvent(32);
        }
        this.fireChangeEvent(256);
    }

    private void handleSpawnRunningThreadReply(SpawnRunningThreadReply spawnThreadReply) {
        this.factory.getModelUpdater().spawnRunningThreadReply(this.getHost(), spawnThreadReply.getThreadName(), spawnThreadReply.getContext());
        this.fireChangeEvent(512);
    }

    private void handleTerminatedReply(TerminatedReply terminatedReply) {
        String threadName = terminatedReply.getThreadName();
        if (threadName == null) {
            this.factory.getModelUpdater().terminatedReply(this.getHost());
            DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointListener)this);
            this.fireTerminateEvent();
        } else {
            Thread eThread = DebugTargetUtils.getThread((DebugTarget)this.getHost(), (String)threadName);
            this.factory.getModelUpdater().terminatedReply(eThread);
            DSLThreadAdapter thread = this.factory.getThread(eThread);
            thread.fireTerminateEvent();
            StackFrame eFrame = eThread.getTopStackFrame();
            while (eFrame != null) {
                this.fireCurrentInstructionTerminatedEvent(eFrame);
                eFrame = eFrame.getParentFrame();
            }
        }
    }

    private void handleSuspendReply(SuspendedReply suspendReply) {
        Thread eThread = DebugTargetUtils.getThread((DebugTarget)this.getHost(), (String)suspendReply.getThreadName());
        DSLThreadAdapter thread = this.factory.getThread(eThread);
        this.factory.getModelUpdater().suspendedReply(eThread);
        if (suspendReply instanceof SteppedReply) {
            thread.fireSuspendEvent(8);
        } else if (suspendReply instanceof BreakpointReply) {
            thread.fireSuspendEvent(16);
        } else {
            thread.fireSuspendEvent(32);
        }
        this.fireChangeEvent(256);
    }

    public void addCurrentInstructionListener(IDSLCurrentInstructionListener listener) {
        this.currentInstructionListeners.add(listener);
    }

    public void removeCurrentInstructionListener(IDSLCurrentInstructionListener listener) {
        this.currentInstructionListeners.remove(listener);
    }

    protected void fireCurrentInstructionChangedEvent(StackFrame frame) {
        for (IDSLCurrentInstructionListener listener : this.currentInstructionListeners) {
            listener.currentInstructionChanged(this.getModelIdentifier(), frame);
        }
    }

    protected void fireCurrentInstructionTerminatedEvent(StackFrame frame) {
        for (IDSLCurrentInstructionListener listener : this.currentInstructionListeners) {
            listener.terminated(this.getModelIdentifier(), frame);
        }
    }

    public List<IDSLCurrentInstructionListener> getCurrentInstructionListeners() {
        return this.currentInstructionListeners;
    }
}

