/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.sequential.javaengine.ui.launcher;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gemoc.dsl.debug.ide.adapter.DSLStackFrameAdapter;
import org.eclipse.gemoc.dsl.debug.ide.sirius.ui.DSLDebugModelPresentation;
import org.eclipse.gemoc.dsl.debug.ide.sirius.ui.SiriusEditorUtils;
import org.eclipse.gemoc.executionframework.ui.Activator;
import org.eclipse.gemoc.executionframework.ui.IMSEPresenter;
import org.eclipse.gemoc.trace.commons.model.trace.MSE;
import org.eclipse.gemoc.trace.commons.model.trace.Step;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

public class GemocDebugModelPresentation
extends DSLDebugModelPresentation {
    public IEditorInput getEditorInput(Object element) {
        IEditorInput res = element instanceof MSE && ((MSE)element).getCaller() != null ? super.getEditorInput((Object)((MSE)element).getCaller()) : super.getEditorInput(element);
        return res;
    }

    public String getEditorId(IEditorInput input, Object element) {
        String res = element instanceof MSE && ((MSE)element).getCaller() != null ? super.getEditorId(input, (Object)((MSE)element).getCaller()) : super.getEditorId(input, element);
        return res;
    }

    public boolean addAnnotations(IEditorPart editorPart, IStackFrame frame) {
        if (frame instanceof DSLStackFrameAdapter) {
            this.changeCurrentStackFrame(frame);
            if (editorPart instanceof DialectEditor) {
                EObject instruction = ((DSLStackFrameAdapter)frame).getCurrentInstruction();
                if (instruction instanceof Step) {
                    ArrayList<MSE> tickedEvents = new ArrayList<MSE>();
                    tickedEvents.add(((Step)instruction).getMseoccurrence().getMse());
                    this.showEvents(tickedEvents);
                    LinkedHashSet<EObject> callers = new LinkedHashSet<EObject>();
                    for (MSE event : tickedEvents) {
                        if (event.getCaller() == null) continue;
                        callers.add(event.getCaller());
                    }
                    try {
                        SiriusEditorUtils.showInstructions((DialectEditor)((DialectEditor)editorPart), new ArrayList(callers));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    try {
                        SiriusEditorUtils.showInstruction((DialectEditor)((DialectEditor)editorPart), (EObject)instruction);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                super.addAnnotations(editorPart, frame);
            }
        }
        return false;
    }

    private void showEvents(List<MSE> events) {
        ArrayList<URI> uris = new ArrayList<URI>();
        for (MSE event : events) {
            uris.add(EcoreUtil.getURI((EObject)event));
        }
        for (IMSEPresenter presenter : Activator.getDefault().getEventPresenters()) {
            presenter.present(uris);
        }
    }
}

