/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.trace.gemoc.ui.commands;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.gemoc.trace.gemoc.generator.TraceAddonGeneratorIntegration;
import org.eclipse.gemoc.xdsmlframework.ide.ui.commands.AbstractDslSelectHandler;
import org.eclipse.gemoc.xdsmlframework.ide.ui.xdsml.wizards.MelangeXDSMLProjectHelper;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class XDSMLProject2TraceAddonHandler
extends AbstractDslSelectHandler
implements IHandler {
    private static final String pluginId = "org.eclipse.gemoc.trace.gemoc.ui";

    public Object executeForSelectedLanguage(ExecutionEvent event, IProject updatedGemocLanguageProject, final String language) throws ExecutionException {
        boolean _equals;
        final IFile dslFile = this.getDslFileFromSelection(event);
        IProject _project = dslFile.getProject();
        String baseProjectName = MelangeXDSMLProjectHelper.baseProjectName((IProject)_project);
        String _xifexpression = null;
        String _lowerCase = language.toLowerCase();
        boolean _endsWith = baseProjectName.endsWith(_lowerCase);
        if (_endsWith) {
            _xifexpression = baseProjectName;
        } else {
            String _lowerCase_1 = language.toLowerCase();
            _xifexpression = String.valueOf(baseProjectName) + "." + _lowerCase_1;
        }
        String suggestedBasePluginName = _xifexpression;
        String suggestedPluginName = String.valueOf(suggestedBasePluginName) + ".trace";
        InputDialog inputDialog = new InputDialog(null, "Create MultiDimensional Trace addon for language " + language, "Enter project name ", suggestedPluginName, null);
        inputDialog.open();
        int _returnCode = inputDialog.getReturnCode();
        boolean bl = _equals = _returnCode == 0;
        if (_equals) {
            final String projectName = inputDialog.getValue();
            String _string = dslFile.toString();
            String _plus = "Generating trace addon plugin for " + _string;
            Job j = new Job(_plus){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        TraceAddonGeneratorIntegration.generateAddon((IFile)dslFile, (String)language, (String)projectName, (boolean)true, (IProgressMonitor)monitor);
                    }
                    catch (Throwable _t) {
                        if (_t instanceof Exception) {
                            Exception e = (Exception)_t;
                            return new Status(4, XDSMLProject2TraceAddonHandler.pluginId, "An error occured while generating the trace addon. Please expand below for the complete error stack trace.", (Throwable)e);
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                    return new Status(0, XDSMLProject2TraceAddonHandler.pluginId, "Multidimensional Trace addon plugin generated.");
                }
            };
            j.schedule();
        }
        return null;
    }

    public String getSelectionMessage() {
        return "Select Language that is used to initialize the Multidimensional Trace addon creation wizard";
    }
}

