/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.trace.metamodel.generator;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import opsemanticsview.OperationalSemanticsView;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.gemoc.trace.commons.EMFUtil;
import org.eclipse.gemoc.trace.metamodel.generator.TraceMMExplorer;
import org.eclipse.gemoc.trace.metamodel.generator.TraceMMGenerationTraceability;
import org.eclipse.gemoc.trace.metamodel.generator.TraceMMGeneratorStates;
import org.eclipse.gemoc.trace.metamodel.generator.TraceMMGeneratorSteps;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

public class TraceMMGenerator {
    private final OperationalSemanticsView mmext;
    private final ResourceSet rs;
    private final String languageName;
    private final boolean gemoc;
    @Accessors(value={AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER})
    private final EPackage tracemmresult;
    @Accessors(value={AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER})
    private final TraceMMGenerationTraceability traceability;
    private final TraceMMExplorer traceMMExplorer;
    private boolean done = false;
    private TraceMMGeneratorSteps stepsGen;

    public TraceMMGenerator(OperationalSemanticsView mmext, boolean gemoc) {
        try {
            TraceMMGenerationTraceability _traceMMGenerationTraceability;
            TraceMMExplorer _traceMMExplorer;
            String _plus;
            this.mmext = mmext;
            this.gemoc = gemoc;
            EPackage _executionMetamodel = mmext.getExecutionMetamodel();
            String _name = _executionMetamodel.getName();
            String _replaceAll = _name.replaceAll(" ", "");
            this.languageName = _plus = String.valueOf(_replaceAll) + "Trace";
            ResourceSetImpl _resourceSetImpl = new ResourceSetImpl();
            this.rs = _resourceSetImpl;
            Resource.Factory.Registry _resourceFactoryRegistry = this.rs.getResourceFactoryRegistry();
            Map _extensionToFactoryMap = _resourceFactoryRegistry.getExtensionToFactoryMap();
            EcoreResourceFactoryImpl _ecoreResourceFactoryImpl = new EcoreResourceFactoryImpl();
            _extensionToFactoryMap.put("ecore", _ecoreResourceFactoryImpl);
            URI _createPlatformPluginURI = URI.createPlatformPluginURI((String)"org.eclipse.gemoc.trace.metamodel.generator/model/base.ecore", (boolean)true);
            Resource base = EMFUtil.loadModelURI((URI)_createPlatformPluginURI, (ResourceSet)this.rs);
            EList _contents = base.getContents();
            EObject _get = (EObject)_contents.get(0);
            this.tracemmresult = (EPackage)_get;
            EList _contents_1 = base.getContents();
            _contents_1.remove((Object)this.tracemmresult);
            this.tracemmresult.setName(this.languageName);
            this.tracemmresult.setNsURI(this.languageName);
            this.tracemmresult.setNsPrefix(this.languageName);
            this.traceMMExplorer = _traceMMExplorer = new TraceMMExplorer(this.tracemmresult);
            this.traceMMExplorer.stepsPackage.setNsURI(String.valueOf(this.languageName) + "_Steps");
            this.traceMMExplorer.statesPackage.setNsURI(String.valueOf(this.languageName) + "_States");
            this.traceability = _traceMMGenerationTraceability = new TraceMMGenerationTraceability(this.traceMMExplorer, mmext);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void computeAllMaterial() throws IOException {
        if (!this.done) {
            boolean _notEquals;
            TraceMMGeneratorSteps _traceMMGeneratorSteps;
            TraceMMGeneratorStates statesGen = new TraceMMGeneratorStates(this.mmext, this.traceability, this.traceMMExplorer, this.languageName, this.tracemmresult, this.gemoc);
            statesGen.process();
            this.stepsGen = _traceMMGeneratorSteps = new TraceMMGeneratorSteps(this.mmext, this.tracemmresult, this.traceability, this.traceMMExplorer, this.gemoc);
            this.stepsGen.process();
            Diagnostic results = Diagnostician.INSTANCE.validate((EObject)this.mmext);
            List _children = results.getChildren();
            Functions.Function1<Diagnostic, Boolean> _function = new Functions.Function1<Diagnostic, Boolean>(){

                public Boolean apply(Diagnostic r) {
                    int _severity = r.getSeverity();
                    return _severity == 4;
                }
            };
            Diagnostic error = (Diagnostic)IterableExtensions.findFirst((Iterable)_children, (Functions.Function1)_function);
            boolean bl = _notEquals = !Objects.equal((Object)error, null);
            if (_notEquals) {
                throw new IllegalStateException("The generated trace metamodel is invalid for at least one reason: " + error);
            }
            this.done = true;
        } else {
            InputOutput.println((Object)"ERROR: already computed.");
        }
    }

    public void sortResult() {
        this.sortEPackage(this.tracemmresult);
    }

    private void sortEPackage(EPackage ePack) {
        EList _eSubpackages = ePack.getESubpackages();
        for (EPackage subPackage : _eSubpackages) {
            this.sortEPackage(subPackage);
        }
        EList _eClassifiers = ePack.getEClassifiers();
        Functions.Function1<EClassifier, String> _function = new Functions.Function1<EClassifier, String>(){

            public String apply(EClassifier it) {
                return it.getName();
            }
        };
        List sortedSteps = IterableExtensions.sortBy((Iterable)_eClassifiers, (Functions.Function1)_function);
        EList _eClassifiers_1 = ePack.getEClassifiers();
        _eClassifiers_1.clear();
        EList _eClassifiers_2 = ePack.getEClassifiers();
        _eClassifiers_2.addAll((Collection)sortedSteps);
        EList _eClassifiers_3 = ePack.getEClassifiers();
        Iterable _filter = Iterables.filter((Iterable)_eClassifiers_3, EClass.class);
        for (EClass eClass : _filter) {
            this.sortEClassFeatures(eClass);
            this.sortEClassInheritance(eClass);
        }
    }

    private void sortEClassFeatures(EClass eClass) {
        EList _eStructuralFeatures = eClass.getEStructuralFeatures();
        Functions.Function1<EStructuralFeature, String> _function = new Functions.Function1<EStructuralFeature, String>(){

            public String apply(EStructuralFeature it) {
                return it.getName();
            }
        };
        List sortedClassFeatures = IterableExtensions.sortBy((Iterable)_eStructuralFeatures, (Functions.Function1)_function);
        EList _eStructuralFeatures_1 = eClass.getEStructuralFeatures();
        _eStructuralFeatures_1.clear();
        EList _eStructuralFeatures_2 = eClass.getEStructuralFeatures();
        _eStructuralFeatures_2.addAll((Collection)sortedClassFeatures);
    }

    private void sortEClassInheritance(EClass eClass) {
        EList _eGenericSuperTypes = eClass.getEGenericSuperTypes();
        boolean _isEmpty = _eGenericSuperTypes.isEmpty();
        if (_isEmpty) {
            EList _eSuperTypes = eClass.getESuperTypes();
            Functions.Function1<EClass, String> _function = new Functions.Function1<EClass, String>(){

                public String apply(EClass it) {
                    return it.getName();
                }
            };
            List sortedClassInheritance = IterableExtensions.sortBy((Iterable)_eSuperTypes, (Functions.Function1)_function);
            EList _eSuperTypes_1 = eClass.getESuperTypes();
            _eSuperTypes_1.clear();
            EList _eSuperTypes_2 = eClass.getESuperTypes();
            _eSuperTypes_2.addAll((Collection)sortedClassInheritance);
        }
    }

    public void addGetCallerEOperations(Set<EPackage> traceMetamodel, Set<GenPackage> packages) {
        this.stepsGen.addGetCallerEOperations(traceMetamodel, packages);
    }

    @Pure
    public EPackage getTracemmresult() {
        return this.tracemmresult;
    }

    @Pure
    public TraceMMGenerationTraceability getTraceability() {
        return this.traceability;
    }
}

