/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.trace.metamodel.generator;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import opsemanticsview.OperationalSemanticsView;
import opsemanticsview.Rule;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gemoc.trace.commons.EcoreCraftingUtil;
import org.eclipse.gemoc.trace.commons.tracemetamodel.StepStrings;
import org.eclipse.gemoc.trace.metamodel.generator.TraceMMExplorer;
import org.eclipse.gemoc.trace.metamodel.generator.TraceMMGenerationTraceability;
import org.eclipse.gemoc.trace.metamodel.generator.TraceMMStrings;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionExtensions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public class TraceMMGeneratorSteps {
    private final OperationalSemanticsView mmext;
    private final TraceMMExplorer traceMMExplorer;
    private final boolean gemoc;
    private final EPackage tracemmresult;
    private final TraceMMGenerationTraceability traceability;
    private final Map<Rule, EClass> stepRuleToClass = new HashMap<Rule, EClass>();
    private final String randomStringToFindGetCallerAnnotations = Integer.valueOf(new Random(10000L).nextInt()).toString();
    private static final String GET_CALLER_OPERATION_NAME = "getCaller";

    public TraceMMGeneratorSteps(OperationalSemanticsView mmext, EPackage tracemmresult, TraceMMGenerationTraceability traceability, TraceMMExplorer traceMMExplorer, boolean gemoc) {
        this.traceability = traceability;
        this.tracemmresult = tracemmresult;
        this.traceMMExplorer = traceMMExplorer;
        this.mmext = mmext;
        this.gemoc = gemoc;
    }

    private void debug(Object stuff) {
    }

    private Set<Rule> gatherRulesThatOverride(Rule rule) {
        HashSet<Rule> result = new HashSet<Rule>();
        result.add(rule);
        EList _overridenBy = rule.getOverridenBy();
        result.addAll((Collection<Rule>)_overridenBy);
        EList _overridenBy_1 = rule.getOverridenBy();
        for (Rule ov : _overridenBy_1) {
            Set<Rule> _gatherRulesThatOverride = this.gatherRulesThatOverride(ov);
            result.addAll(_gatherRulesThatOverride);
        }
        return result;
    }

    private Set<Rule> gatherStepCalls(Rule rule, Set<Rule> inProgress) {
        boolean _not;
        HashSet<Rule> result = new HashSet<Rule>();
        boolean _contains = inProgress.contains(rule);
        boolean bl = _not = !_contains;
        if (_not) {
            inProgress.add(rule);
            boolean _isStepRule = rule.isStepRule();
            if (_isStepRule) {
                result.add(rule);
            } else {
                EList _calledRules = rule.getCalledRules();
                for (Rule called : _calledRules) {
                    Set<Rule> gathered = this.gatherStepCalls(called, inProgress);
                    result.addAll(gathered);
                }
            }
        }
        return result;
    }

    private EClass getStepClass(Rule stepRule) {
        boolean _containsKey = this.stepRuleToClass.containsKey(stepRule);
        if (_containsKey) {
            return this.stepRuleToClass.get(stepRule);
        }
        EClass stepClass = EcoreFactory.eINSTANCE.createEClass();
        EList _eClassifiers = this.traceMMExplorer.stepsPackage.getEClassifiers();
        _eClassifiers.add((Object)stepClass);
        this.stepRuleToClass.put(stepRule, stepClass);
        this.traceability.addStepRuleToStepClass(stepRule, stepClass);
        return stepClass;
    }

    private void setClassNameWithoutConflict(EClass clazz, final String name) {
        Functions.Function1<EClass, Boolean> _function;
        TreeIterator _eAllContents = this.tracemmresult.eAllContents();
        Set _set = IteratorExtensions.toSet((Iterator)_eAllContents);
        Iterable _filter = Iterables.filter((Iterable)_set, EClass.class);
        Iterable _filter_1 = IterableExtensions.filter((Iterable)_filter, (Functions.Function1)(_function = new Functions.Function1<EClass, Boolean>(){

            public Boolean apply(EClass c) {
                return !Objects.equal((Object)c.getName(), null) && c.getName().startsWith(name);
            }
        }));
        int nbExistingClassesWithName = IterableExtensions.size((Iterable)_filter_1);
        if (nbExistingClassesWithName > 0) {
            clazz.setName(String.valueOf(name) + "_" + Integer.valueOf(nbExistingClassesWithName));
        } else {
            clazz.setName(name);
        }
    }

    public void process() {
        EList _rules = this.mmext.getRules();
        for (Rule rule : _rules) {
            EList _calledRules = rule.getCalledRules();
            ImmutableList _immutableCopy = ImmutableList.copyOf((Collection)_calledRules);
            for (Iterator calledRule : _immutableCopy) {
                Set<Rule> overrides = this.gatherRulesThatOverride((Rule)calledRule);
                EList _calledRules_1 = rule.getCalledRules();
                _calledRules_1.addAll(overrides);
            }
        }
        EList _rules_1 = this.mmext.getRules();
        Predicate<Rule> _function = new Predicate<Rule>(){

            @Override
            public boolean test(Rule it) {
                return it.isAbstract();
            }
        };
        _rules_1.removeIf((Predicate)_function);
        EList _rules_2 = this.mmext.getRules();
        for (Rule rule_1 : _rules_2) {
            EList _calledRules_1 = rule_1.getCalledRules();
            Predicate<Rule> _function_1 = new Predicate<Rule>(){

                @Override
                public boolean test(Rule it) {
                    return it.isAbstract();
                }
            };
            _calledRules_1.removeIf((Predicate)_function_1);
        }
        EList _rules_3 = this.mmext.getRules();
        Functions.Function1<Rule, Boolean> _function_2 = new Functions.Function1<Rule, Boolean>(){

            public Boolean apply(Rule r) {
                return r.isStepRule();
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_rules_3, (Functions.Function1)_function_2);
        Set stepRules = IterableExtensions.toSet((Iterable)_filter);
        ImmutableSet _immutableCopy_1 = ImmutableSet.copyOf((Collection)stepRules);
        for (Rule rule_2 : _immutableCopy_1) {
            Set<Rule> overrides = this.gatherRulesThatOverride(rule_2);
            for (Rule o : overrides) {
                o.setStepRule(true);
                stepRules.add(o);
            }
        }
        for (Rule rule_3 : stepRules) {
            EList _calledRules_2 = rule_3.getCalledRules();
            Functions.Function1<Rule, Boolean> _function_3 = new Functions.Function1<Rule, Boolean>(){

                public Boolean apply(Rule r) {
                    boolean _isStepRule = r.isStepRule();
                    return !_isStepRule;
                }
            };
            Iterable _filter_1 = IterableExtensions.filter((Iterable)_calledRules_2, (Functions.Function1)_function_3);
            Set calledNonStepRules = IterableExtensions.toSet((Iterable)_filter_1);
            for (Rule called : calledNonStepRules) {
                HashSet<Rule> inProgress = new HashSet<Rule>();
                Set<Rule> gathered = this.gatherStepCalls(called, inProgress);
                EList _calledRules_3 = rule_3.getCalledRules();
                _calledRules_3.addAll(gathered);
            }
            EList _calledRules_3 = rule_3.getCalledRules();
            _calledRules_3.removeAll((Collection)calledNonStepRules);
        }
        EList _rules_4 = this.mmext.getRules();
        _rules_4.clear();
        EList _rules_5 = this.mmext.getRules();
        _rules_5.addAll((Collection)stepRules);
        Functions.Function1<Rule, String> _function_3 = new Functions.Function1<Rule, String>(){

            public String apply(Rule r) {
                EClass _containingClass = r.getContainingClass();
                String _name = _containingClass.getName();
                String _plus = String.valueOf(_name) + ".";
                EOperation _operation = r.getOperation();
                String _name_1 = _operation.getName();
                String _plus_1 = String.valueOf(_plus) + _name_1;
                String _plus_2 = String.valueOf(_plus_1) + ": ";
                EList _calledRules = r.getCalledRules();
                boolean _isEmpty = _calledRules.isEmpty();
                boolean _not = !_isEmpty;
                return String.valueOf(_plus_2) + Boolean.valueOf(_not);
            }
        };
        Iterable prettyStepRules = IterableExtensions.map((Iterable)stepRules, (Functions.Function1)_function_3);
        this.debug(prettyStepRules);
        EClass _specificTraceClass = this.traceMMExplorer.getSpecificTraceClass();
        EList _eGenericSuperTypes = _specificTraceClass.getEGenericSuperTypes();
        EGenericType _head = (EGenericType)IterableExtensions.head((Iterable)_eGenericSuperTypes);
        EClassifier _eClassifier = _head.getEClassifier();
        Resource mseMetamodelResource = _eClassifier.eResource();
        TreeIterator _allContents = mseMetamodelResource.getAllContents();
        Set _set = IteratorExtensions.toSet((Iterator)_allContents);
        Iterable _filter_1 = Iterables.filter((Iterable)_set, EClass.class);
        Functions.Function1<EClass, Boolean> _function_4 = new Functions.Function1<EClass, Boolean>(){

            public Boolean apply(EClass it) {
                String _name = it.getName();
                return _name.equals("SequentialStep");
            }
        };
        EClass mseSequentialStepClass = (EClass)IterableExtensions.findFirst((Iterable)_filter_1, (Functions.Function1)_function_4);
        TreeIterator _allContents_1 = mseMetamodelResource.getAllContents();
        Set _set_1 = IteratorExtensions.toSet((Iterator)_allContents_1);
        Iterable _filter_2 = Iterables.filter((Iterable)_set_1, EClass.class);
        Functions.Function1<EClass, Boolean> _function_5 = new Functions.Function1<EClass, Boolean>(){

            public Boolean apply(EClass it) {
                String _name = it.getName();
                return _name.equals("SmallStep");
            }
        };
        EClass mseSmallStepClass = (EClass)IterableExtensions.findFirst((Iterable)_filter_2, (Functions.Function1)_function_5);
        for (Rule stepRule : stepRules) {
            EClass stepClass = this.getStepClass(stepRule);
            EOperation _operation = stepRule.getOperation();
            String _name = _operation.getName();
            stepClass.setName(_name);
            if (this.gemoc && !Objects.equal((Object)stepRule.getContainingClass(), null)) {
                EOperation getCallerEOperation = EcoreFactory.eINSTANCE.createEOperation();
                EClass _containingClass = stepRule.getContainingClass();
                EClass tracedClass = this.traceability.getTracedClass(_containingClass);
                EClass _xifexpression = null;
                boolean _equals = Objects.equal((Object)tracedClass, null);
                _xifexpression = _equals ? stepRule.getContainingClass() : tracedClass;
                getCallerEOperation.setEType((EClassifier)_xifexpression);
                getCallerEOperation.setLowerBound(1);
                getCallerEOperation.setUpperBound(1);
                getCallerEOperation.setName(GET_CALLER_OPERATION_NAME);
                EAnnotation bodyAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
                EList _eAnnotations = getCallerEOperation.getEAnnotations();
                _eAnnotations.add((Object)bodyAnnotation);
                bodyAnnotation.setSource("http://www.eclipse.org/emf/2002/GenModel");
                EMap _details = bodyAnnotation.getDetails();
                _details.put((Object)"body", (Object)this.randomStringToFindGetCallerAnnotations);
                EList _eOperations = stepClass.getEOperations();
                _eOperations.add((Object)getCallerEOperation);
            } else {
                EClass _containingClass_1 = stepRule.getContainingClass();
                EcoreCraftingUtil.addReferenceToClass((EClass)stepClass, (String)"this", (EClass)_containingClass_1);
            }
            EClass _containingClass_2 = stepRule.getContainingClass();
            EOperation _operation_1 = stepRule.getOperation();
            String _stepClassName = StepStrings.stepClassName((EClass)_containingClass_2, (EOperation)_operation_1);
            this.setClassNameWithoutConflict(stepClass, _stepClassName);
            String _ref_createTraceClassToStepClass = TraceMMStrings.ref_createTraceClassToStepClass(stepClass);
            EReference ref = EcoreCraftingUtil.addReferenceToClass((EClass)this.traceMMExplorer.specificTraceClass, (String)_ref_createTraceClassToStepClass, (EClass)stepClass);
            ref.setLowerBound(0);
            ref.setUpperBound(-1);
            ref.setContainment(false);
            this.traceability.addStepSequence(stepClass, ref);
            this.traceability.addStepClass(stepClass);
            EList _eSuperTypes = stepClass.getESuperTypes();
            EClass _specificStepClass = this.traceMMExplorer.getSpecificStepClass();
            _eSuperTypes.add((Object)_specificStepClass);
            EList _calledRules_2 = stepRule.getCalledRules();
            boolean _isEmpty = _calledRules_2.isEmpty();
            if (_isEmpty) {
                EGenericType smallStepGenericSuperType = EcoreFactory.eINSTANCE.createEGenericType();
                smallStepGenericSuperType.setEClassifier((EClassifier)mseSmallStepClass);
                EGenericType smallStepTypeBinding = EcoreFactory.eINSTANCE.createEGenericType();
                EList _eTypeArguments = smallStepGenericSuperType.getETypeArguments();
                _eTypeArguments.add((Object)smallStepTypeBinding);
                smallStepTypeBinding.setEClassifier((EClassifier)this.traceMMExplorer.specificStateClass);
                EList _eGenericSuperTypes_1 = stepClass.getEGenericSuperTypes();
                _eGenericSuperTypes_1.add((Object)smallStepGenericSuperType);
                continue;
            }
            this.traceability.addBigStepClass(stepClass);
            EGenericType genericSuperType = EcoreFactory.eINSTANCE.createEGenericType();
            genericSuperType.setEClassifier((EClassifier)mseSequentialStepClass);
            EGenericType stepTypeBinding = EcoreFactory.eINSTANCE.createEGenericType();
            EGenericType stateTypeBinding = EcoreFactory.eINSTANCE.createEGenericType();
            EList _eTypeArguments_1 = genericSuperType.getETypeArguments();
            CollectionExtensions.addAll((Collection)_eTypeArguments_1, (Object[])new EGenericType[]{stepTypeBinding, stateTypeBinding});
            EList _eGenericSuperTypes_2 = stepClass.getEGenericSuperTypes();
            _eGenericSuperTypes_2.add((Object)genericSuperType);
            EClass subStepSuperClass = EcoreFactory.eINSTANCE.createEClass();
            EList _eClassifiers = this.traceMMExplorer.stepsPackage.getEClassifiers();
            _eClassifiers.add((Object)subStepSuperClass);
            EClass _containingClass_3 = stepRule.getContainingClass();
            EOperation _operation_2 = stepRule.getOperation();
            String _abstractSubStepClassName = StepStrings.abstractSubStepClassName((EClass)_containingClass_3, (EOperation)_operation_2);
            this.setClassNameWithoutConflict(subStepSuperClass, _abstractSubStepClassName);
            subStepSuperClass.setAbstract(true);
            subStepSuperClass.setInterface(true);
            EList _eSuperTypes_1 = subStepSuperClass.getESuperTypes();
            _eSuperTypes_1.add((Object)this.traceMMExplorer.specificStepClass);
            stepTypeBinding.setEClassifier((EClassifier)subStepSuperClass);
            stateTypeBinding.setEClassifier((EClassifier)this.traceMMExplorer.specificStateClass);
            EClass implicitStepClass = EcoreFactory.eINSTANCE.createEClass();
            EList _eClassifiers_1 = this.traceMMExplorer.stepsPackage.getEClassifiers();
            _eClassifiers_1.add((Object)implicitStepClass);
            EClass _containingClass_4 = stepRule.getContainingClass();
            EOperation _operation_3 = stepRule.getOperation();
            String _implicitStepClassName = StepStrings.implicitStepClassName((EClass)_containingClass_4, (EOperation)_operation_3);
            this.setClassNameWithoutConflict(implicitStepClass, _implicitStepClassName);
            EList _eSuperTypes_2 = implicitStepClass.getESuperTypes();
            _eSuperTypes_2.add((Object)subStepSuperClass);
            EGenericType smallStepGenericSuperType_1 = EcoreFactory.eINSTANCE.createEGenericType();
            smallStepGenericSuperType_1.setEClassifier((EClassifier)mseSmallStepClass);
            EGenericType smallStepTypeBinding_1 = EcoreFactory.eINSTANCE.createEGenericType();
            EList _eTypeArguments_2 = smallStepGenericSuperType_1.getETypeArguments();
            _eTypeArguments_2.add((Object)smallStepTypeBinding_1);
            smallStepTypeBinding_1.setEClassifier((EClassifier)this.traceMMExplorer.specificStateClass);
            EList _eGenericSuperTypes_3 = implicitStepClass.getEGenericSuperTypes();
            _eGenericSuperTypes_3.add((Object)smallStepGenericSuperType_1);
            EClass _containingClass_5 = stepRule.getContainingClass();
            this.traceability.putImplicitStepClass(implicitStepClass, _containingClass_5);
            EList _calledRules_3 = stepRule.getCalledRules();
            for (Rule calledStepRule : _calledRules_3) {
                EClass subStepClass = this.getStepClass(calledStepRule);
                EList _eSuperTypes_3 = subStepClass.getESuperTypes();
                _eSuperTypes_3.add((Object)subStepSuperClass);
            }
        }
    }

    public void addGetCallerEOperations(Set<EPackage> traceMetamodel, Set<GenPackage> packages) {
        for (EPackage p : traceMetamodel) {
            TreeIterator _eAllContents = p.eAllContents();
            UnmodifiableIterator _filter = Iterators.filter((Iterator)_eAllContents, EOperation.class);
            Set _set = IteratorExtensions.toSet((Iterator)_filter);
            for (EOperation operation : _set) {
                boolean _notEquals;
                Functions.Function1<EAnnotation, Boolean> _function_1;
                Functions.Function1<EAnnotation, Boolean> _function;
                EList _eAnnotations = operation.getEAnnotations();
                Iterable annotationsWithBody = IterableExtensions.filter((Iterable)_eAnnotations, (Functions.Function1)(_function = new Functions.Function1<EAnnotation, Boolean>(){

                    public Boolean apply(EAnnotation a) {
                        EMap _details = a.getDetails();
                        return _details.containsKey((Object)"body");
                    }
                }));
                EAnnotation annotationWithUniqueString = (EAnnotation)IterableExtensions.findFirst((Iterable)annotationsWithBody, (Functions.Function1)(_function_1 = new Functions.Function1<EAnnotation, Boolean>(){

                    public Boolean apply(EAnnotation a) {
                        EMap _details = a.getDetails();
                        String _get = (String)_details.get((Object)"body");
                        return _get.equals(TraceMMGeneratorSteps.this.randomStringToFindGetCallerAnnotations);
                    }
                }));
                boolean bl = _notEquals = !Objects.equal((Object)annotationWithUniqueString, null);
                if (!_notEquals) continue;
                EMap _details = annotationWithUniqueString.getDetails();
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("return (");
                EClassifier _eType = operation.getEType();
                String _javaFQN = EcoreCraftingUtil.getJavaFQN((EClassifier)_eType, packages);
                _builder.append(_javaFQN, "");
                _builder.append(") this.getMseoccurrence().getMse().getCaller();");
                _details.put((Object)"body", (Object)_builder.toString());
            }
        }
    }
}

