/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.reorg;

import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ICreateTargetQuery;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgDestinationValidator;
import org.eclipse.jdt.internal.corext.refactoring.reorg.JavaMoveProcessor;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgDestinationFactory;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.refactoring.QualifiedNameComponent;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgMessages;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgUserInputPage;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ReorgMoveWizard
extends RefactoringWizard {
    private static final String UPDATE_QUALIFIED_NAMES = "moveWizard.updateQualifiedNames";
    private final JavaMoveProcessor fMoveProcessor;

    public ReorgMoveWizard(JavaMoveProcessor moveProcessor, Refactoring ref) {
        super(ref, 4);
        this.fMoveProcessor = moveProcessor;
        if (ReorgMoveWizard.isTextualMove(this.fMoveProcessor)) {
            this.setDefaultPageTitle(ReorgMessages.ReorgMoveWizard_textual_move);
        } else {
            this.setDefaultPageTitle(ReorgMessages.ReorgMoveWizard_3);
        }
    }

    private static boolean isTextualMove(JavaMoveProcessor moveProcessor) {
        return moveProcessor.isTextualMove();
    }

    protected void addUserInputPages() {
        this.addPage((IWizardPage)new MoveInputPage(this.fMoveProcessor));
    }

    private static class MoveInputPage
    extends ReorgUserInputPage {
        private static final String PAGE_NAME = "MoveInputPage";
        private static final long LABEL_FLAGS = JavaElementLabels.ALL_DEFAULT | 0x40L | 2L | 0x8000L;
        private Button fReferenceCheckbox;
        private Button fQualifiedNameCheckbox;
        private QualifiedNameComponent fQualifiedNameComponent;
        private ICreateTargetQuery fCreateTargetQuery;
        private Object fDestination;
        private final JavaMoveProcessor fMoveProcessor;

        public MoveInputPage(JavaMoveProcessor moveProcessor) {
            super(PAGE_NAME);
            this.fMoveProcessor = moveProcessor;
        }

        private JavaMoveProcessor getJavaMoveProcessor() {
            return this.fMoveProcessor;
        }

        @Override
        protected Object getInitiallySelectedElement() {
            return this.getJavaMoveProcessor().getCommonParentForInputElements();
        }

        @Override
        protected IJavaElement[] getJavaElements() {
            return this.getJavaMoveProcessor().getJavaElements();
        }

        @Override
        protected IResource[] getResources() {
            return this.getJavaMoveProcessor().getResources();
        }

        @Override
        protected IReorgDestinationValidator getDestinationValidator() {
            return this.getJavaMoveProcessor();
        }

        protected boolean performFinish() {
            return super.performFinish() || this.getJavaMoveProcessor().wasCanceled();
        }

        @Override
        protected RefactoringStatus verifyDestination(Object selected) throws JavaModelException {
            JavaMoveProcessor processor = this.getJavaMoveProcessor();
            RefactoringStatus refactoringStatus = processor.setDestination(ReorgDestinationFactory.createDestination(selected));
            this.updateUIStatus();
            this.fDestination = selected;
            return refactoringStatus;
        }

        private void updateUIStatus() {
            this.getRefactoringWizard().setForcePreviewReview(false);
            JavaMoveProcessor processor = this.getJavaMoveProcessor();
            if (this.fReferenceCheckbox != null) {
                processor.setUpdateReferences(this.fReferenceCheckbox.getSelection());
            }
            if (this.fQualifiedNameCheckbox != null) {
                boolean enabled = processor.canEnableQualifiedNameUpdating();
                this.fQualifiedNameCheckbox.setEnabled(enabled);
                if (enabled) {
                    this.fQualifiedNameComponent.setEnabled(processor.getUpdateQualifiedNames());
                    if (processor.getUpdateQualifiedNames()) {
                        this.getRefactoringWizard().setForcePreviewReview(true);
                    }
                } else {
                    this.fQualifiedNameComponent.setEnabled(false);
                }
                processor.setUpdateQualifiedNames(this.fQualifiedNameCheckbox.getEnabled() && this.fQualifiedNameCheckbox.getSelection());
            }
        }

        private void addUpdateReferenceComponent(Composite result) {
            final JavaMoveProcessor processor = this.getJavaMoveProcessor();
            if (!processor.canUpdateJavaReferences()) {
                return;
            }
            int resources = this.getResources().length;
            int javaElements = this.getJavaElements().length;
            String text = resources == 0 && javaElements == 1 ? Messages.format(ReorgMessages.JdtMoveAction_update_references_singular, JavaElementLabels.getElementLabel(this.getJavaElements()[0], LABEL_FLAGS)) : (resources == 1 && javaElements == 0 ? Messages.format(ReorgMessages.JdtMoveAction_update_references_singular, BasicElementLabels.getResourceName((IResource)this.getResources()[0])) : Messages.format(ReorgMessages.JdtMoveAction_update_references_plural, String.valueOf(resources + javaElements)));
            this.fReferenceCheckbox = new Button(result, 32);
            this.fReferenceCheckbox.setText(text);
            this.fReferenceCheckbox.setSelection(processor.getUpdateReferences());
            this.fReferenceCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    processor.setUpdateReferences(((Button)e.widget).getSelection());
                    this.updateUIStatus();
                }
            });
        }

        private void addUpdateQualifiedNameComponent(Composite parent, int marginWidth) {
            final JavaMoveProcessor processor = this.getJavaMoveProcessor();
            if (!processor.canEnableQualifiedNameUpdating() || !processor.canUpdateQualifiedNames()) {
                return;
            }
            this.fQualifiedNameCheckbox = new Button(parent, 32);
            int indent = marginWidth + this.fQualifiedNameCheckbox.computeSize((int)-1, (int)-1).x;
            this.fQualifiedNameCheckbox.setText(RefactoringMessages.RenameInputWizardPage_update_qualified_names);
            this.fQualifiedNameCheckbox.setLayoutData((Object)new GridData(768));
            this.fQualifiedNameCheckbox.setSelection(processor.getUpdateQualifiedNames());
            this.fQualifiedNameComponent = new QualifiedNameComponent(parent, 0, processor, this.getRefactoringSettings());
            this.fQualifiedNameComponent.setLayoutData(new GridData(768));
            GridData gd = (GridData)this.fQualifiedNameComponent.getLayoutData();
            gd.horizontalAlignment = 4;
            gd.horizontalIndent = indent;
            this.updateQualifiedNameUpdating(processor, processor.getUpdateQualifiedNames());
            this.fQualifiedNameCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean enabled = ((Button)e.widget).getSelection();
                    this.updateQualifiedNameUpdating(processor, enabled);
                }
            });
            this.fQualifiedNameCheckbox.setSelection(this.getRefactoringSettings().getBoolean(ReorgMoveWizard.UPDATE_QUALIFIED_NAMES));
            this.updateQualifiedNameUpdating(processor, this.fQualifiedNameCheckbox.getSelection());
        }

        private void updateQualifiedNameUpdating(JavaMoveProcessor processor, boolean enabled) {
            this.fQualifiedNameComponent.setEnabled(enabled);
            processor.setUpdateQualifiedNames(enabled);
            this.updateUIStatus();
        }

        @Override
        public void createControl(Composite parent) {
            Composite result;
            boolean showDestinationTree;
            boolean bl = showDestinationTree = !this.getJavaMoveProcessor().hasDestinationSet();
            if (showDestinationTree) {
                this.fCreateTargetQuery = this.getJavaMoveProcessor().getCreateTargetQuery();
                super.createControl(parent);
                this.getTreeViewer().getTree().setFocus();
                result = (Composite)super.getControl();
            } else {
                this.initializeDialogUnits((Control)parent);
                result = new Composite(parent, 0);
                this.setControl((Control)result);
                result.setLayout((Layout)new GridLayout());
                Dialog.applyDialogFont((Control)result);
            }
            this.addUpdateReferenceComponent(result);
            this.addUpdateQualifiedNameComponent(result, ((GridLayout)result.getLayout()).marginWidth);
            this.setControl((Control)result);
            Dialog.applyDialogFont((Control)result);
        }

        @Override
        protected Control addLabel(Composite parent) {
            if (this.fCreateTargetQuery != null) {
                Composite firstLine = new Composite(parent, 0);
                GridLayout layout = new GridLayout(2, false);
                layout.marginWidth = 0;
                layout.marginHeight = 0;
                firstLine.setLayout((Layout)layout);
                firstLine.setLayoutData((Object)new GridData(768));
                Control label = super.addLabel(firstLine);
                label.addTraverseListener(new TraverseListener(){

                    public void keyTraversed(TraverseEvent e) {
                        if (e.detail == 128 && e.doit) {
                            e.detail = 0;
                            this.getTreeViewer().getTree().setFocus();
                        }
                    }
                });
                Button newButton = new Button(firstLine, 8);
                newButton.setText(this.fCreateTargetQuery.getNewButtonLabel());
                GridData gd = new GridData(642);
                gd.widthHint = SWTUtil.getButtonWidthHint(newButton);
                newButton.setLayoutData((Object)gd);
                newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        this.doNewButtonPressed();
                    }
                });
                return firstLine;
            }
            return super.addLabel(parent);
        }

        private void doNewButtonPressed() {
            Object newElement = this.fCreateTargetQuery.getCreatedTarget(this.fDestination);
            if (newElement != null) {
                TreeViewer viewer = this.getTreeViewer();
                ITreeContentProvider contentProvider = (ITreeContentProvider)viewer.getContentProvider();
                viewer.refresh(contentProvider.getParent(newElement));
                viewer.setSelection((ISelection)new StructuredSelection(newElement), true);
                viewer.getTree().setFocus();
            }
        }

        public void dispose() {
            super.dispose();
            IDialogSettings settings = this.getRefactoringSettings();
            if (settings == null) {
                return;
            }
            if (this.fQualifiedNameCheckbox != null) {
                settings.put(ReorgMoveWizard.UPDATE_QUALIFIED_NAMES, this.fQualifiedNameCheckbox.getSelection());
            }
            if (this.fQualifiedNameComponent != null) {
                this.fQualifiedNameComponent.savePatterns(settings);
            }
        }
    }
}

