/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.backend.manager.datastructure.clock;

import fr.inria.aoste.trace.EventOccurrence;

public class ClockActivationState {
    public static final int stateNumber = State.values().length;
    public static final String[] _stateList = State.string();
    private boolean[] _state = null;
    boolean skipfire = false;
    boolean skipenable = false;
    boolean skipdead = false;

    public boolean getState(State t) {
        if (this._state == null || t == null || this._state.length < t.i) {
            return false;
        }
        return this._state[t.i];
    }

    public void setState(State t, boolean b) {
        if (this._state == null || t == null || this._state.length < t.i) {
            return;
        }
        this._state[t.i] = b;
        this.check();
    }

    public ClockActivationState() {
        this(null);
    }

    public ClockActivationState(boolean[] state) {
        if (state == null) {
            this._state = new boolean[stateNumber];
        } else if (this.isValidClockState(state)) {
            this._state = state;
        } else if (state.length == 7) {
            this._state = new boolean[8];
            int i = 0;
            while (i < 7) {
                this._state[i] = state[i];
                ++i;
            }
            this._state[7] = true;
        }
        this.check();
    }

    public void check() {
        this.skipfire = false;
        this.skipenable = false;
        this.skipdead = false;
        if (!this._state[0] && !this._state[1]) {
            this.skipfire = true;
        }
        if (!(this._state[2] || this._state[3] || this._state[4] || this._state[5])) {
            this.skipenable = true;
        }
        if (!this._state[6] && !this._state[7]) {
            this.skipdead = true;
        }
    }

    public boolean[] getState() {
        return (boolean[])this._state.clone();
    }

    public boolean isValidClockState(boolean[] state) {
        if (state == null) {
            return false;
        }
        return state.length == stateNumber;
    }

    public String getDescription() {
        try {
            StringBuilder tmp = new StringBuilder("");
            StateGroup[] stateGroupArray = StateGroup.values();
            int n = stateGroupArray.length;
            int n2 = 0;
            while (n2 < n) {
                State s;
                StateGroup sg = stateGroupArray[n2];
                boolean b = false;
                State[] stateArray = State.state(sg);
                int n3 = stateArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    s = stateArray[n4];
                    if (this._state[s.i]) {
                        b = true;
                        break;
                    }
                    ++n4;
                }
                if (b) {
                    if (tmp.length() != 0) {
                        tmp.append(",");
                    }
                    tmp.append("{");
                    b = false;
                    stateArray = State.state(sg);
                    n3 = stateArray.length;
                    n4 = 0;
                    while (n4 < n3) {
                        s = stateArray[n4];
                        if (this._state[s.i]) {
                            if (b) {
                                tmp.append("|");
                            }
                            b = true;
                            tmp.append(s.name);
                        }
                        ++n4;
                    }
                    tmp.append("}");
                } else {
                    tmp.append("(" + sg.name() + ":free )");
                }
                ++n2;
            }
            return tmp.toString();
        }
        catch (Throwable throwable) {
            return "...";
        }
    }

    public int hashCode() {
        int n = 0;
        int k = 1;
        int i = 0;
        while (i < this._state.length) {
            if (this._state[i]) {
                n += k;
            }
            if ((k *= 2) <= 0) {
                k = 1;
            }
            ++i;
        }
        return n;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ClockActivationState) {
            ClockActivationState cs = (ClockActivationState)o;
            if (cs.getState() == null) {
                return this._state == null;
            }
            if (this._state == null) {
                return false;
            }
            if (cs.getState().length == this._state.length) {
                int i = 0;
                while (i < this._state.length) {
                    if (cs.getState()[i] != this._state[i]) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        return false;
    }

    public boolean stateActivationOK(EventOccurrence clockState) {
        if (clockState == null) {
            return false;
        }
        boolean result = true;
        boolean[] tmp = this._state;
        if (!this.skipfire) {
            if (clockState.getFState() != null) {
                switch (clockState.getFState()) {
                    case TICK: {
                        result &= tmp[0];
                        break;
                    }
                    case NO_TICK: {
                        result &= tmp[1];
                        break;
                    }
                }
            } else {
                result = false;
            }
        }
        if (!this.skipenable) {
            if (clockState.getEState() != null) {
                switch (clockState.getEState()) {
                    case TICK: {
                        result &= tmp[2];
                        break;
                    }
                    case NO_TICK: {
                        result &= tmp[3];
                        break;
                    }
                    case FREE: {
                        result &= tmp[4];
                        break;
                    }
                    case INDETERMINED: {
                        result &= tmp[5];
                    }
                }
            } else {
                result &= tmp[2] && tmp[3] && tmp[4] && tmp[5];
            }
        }
        if (!this.skipdead) {
            result = clockState.isIsClockDead() ? (result &= tmp[6]) : (result &= tmp[7]);
        }
        return result;
    }

    public static enum State {
        ticks("tick", 0, StateGroup.fire),
        doesntTick("doesntTick", 1, StateGroup.fire),
        mustTick("mustTick", 2, StateGroup.enable),
        cannotTick("cannotTick", 3, StateGroup.enable),
        isFree("isFree", 4, StateGroup.enable),
        isUndetermined("isUndetermined", 5, StateGroup.enable),
        isDead("isDead", 6, StateGroup.dead),
        notIsDead("not IsDead", 7, StateGroup.dead);

        public final int i;
        public final String name;
        public final StateGroup group;

        private State(String name, int i, StateGroup group) {
            this.i = i;
            this.name = name;
            this.group = group;
        }

        public static final String[] string() {
            int n = State.values().length;
            String[] tb = new String[n];
            int i = 0;
            while (i < n) {
                tb[i] = State.values()[i].getName();
                ++i;
            }
            return tb;
        }

        public int getIndice() {
            return this.i;
        }

        public String getName() {
            return this.name;
        }

        public StateGroup getGroup() {
            return this.group;
        }

        public static final State[] state(StateGroup g) {
            int n = State.values().length;
            int k = 0;
            int i = 0;
            while (i < n) {
                if (State.values()[i].group == g) {
                    ++k;
                }
                ++i;
            }
            State[] tb = new State[k];
            k = 0;
            int i2 = 0;
            while (i2 < n) {
                if (State.values()[i2].group == g) {
                    tb[k++] = State.values()[i2];
                }
                ++i2;
            }
            return tb;
        }
    }

    public static enum StateGroup {
        fire,
        enable,
        dead;

    }
}

