/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javabdd;

import fr.inria.aoste.timesquare.buddywrapper.Activator;
import fr.inria.aoste.timesquare.buddywrapper.LogicalOperator;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import java.util.StringTokenizer;
import java.util.stream.IntStream;

public class BuDDyFactory {
    protected int fdvarnum;
    protected int firstbddvar;
    private static BuDDyFactory INSTANCE;
    protected StringTokenizer tokenizer;
    public static LogicalOperator and;
    public static LogicalOperator xor;
    public static LogicalOperator or;
    public static LogicalOperator nand;
    public static LogicalOperator nor;
    public static LogicalOperator imp;
    public static LogicalOperator biimp;
    public static LogicalOperator diff;
    public static LogicalOperator less;
    public static LogicalOperator invimp;

    static {
        if (!Activator.loadNativeLibrary("buddy")) {
            if (Activator.arch.equalsIgnoreCase("x86_64")) {
                Activator.loadLibrary("buddy64");
            } else {
                Activator.loadLibrary("buddy");
            }
        }
        BuDDyFactory.registerNatives();
        and = new LogicalOperator(0, "and");
        xor = new LogicalOperator(1, "xor");
        or = new LogicalOperator(2, "or");
        nand = new LogicalOperator(3, "nand");
        nor = new LogicalOperator(4, "nor");
        imp = new LogicalOperator(5, "imp");
        biimp = new LogicalOperator(6, "biimp");
        diff = new LogicalOperator(7, "diff");
        less = new LogicalOperator(8, "less");
        invimp = new LogicalOperator(9, "invimp");
    }

    private static synchronized native void registerNatives();

    public static synchronized BuDDyFactory init(int nodenum, int cachesize) {
        if (INSTANCE != null) {
            throw new InternalError("Error: BuDDyFactory already initialized.");
        }
        INSTANCE = new BuDDyFactory();
        BuDDyFactory.initialize0(nodenum, cachesize);
        return INSTANCE;
    }

    private static synchronized native void initialize0(int var0, int var1);

    private static BuDDyBDD makeBDD(int id) {
        BuDDyBDD b = new BuDDyBDD(id);
        return b;
    }

    public BuDDyBDD zero() {
        return BuDDyFactory.makeBDD(0);
    }

    public BuDDyBDD one() {
        return BuDDyFactory.makeBDD(1);
    }

    private static int[] toBuDDyArray(Collection<BuDDyBDD> c) {
        int[] a = new int[c.size()];
        int k = 0;
        for (BuDDyBDD b : c) {
            a[k] = b._id;
        }
        return a;
    }

    public boolean isInitialized() {
        return BuDDyFactory.isInitialized0();
    }

    private static synchronized native boolean isInitialized0();

    public void done() {
        System.gc();
        System.runFinalization();
        INSTANCE = null;
        BuDDyFactory.done0();
    }

    private static synchronized native void done0();

    public void reset() {
        System.gc();
        System.runFinalization();
        try {
            int nodes = 100000;
            int cache = 100000;
            try {
                nodes = this.getNodeTableSize();
                cache = this.getCacheSize();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.fdvarnum = 0;
            this.firstbddvar = 0;
            this.done();
            BuDDyFactory.init(nodes, cache);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setError(int code) {
        BuDDyFactory.setError0(code);
    }

    private static synchronized native void setError0(int var0);

    public void clearError() {
        BuDDyFactory.clearError0();
    }

    private static synchronized native void clearError0();

    public int setMaxNodeNum(int size) {
        return BuDDyFactory.setMaxNodeNum0(size);
    }

    private static synchronized native int setMaxNodeNum0(int var0);

    public double setMinFreeNodes(double x) {
        return (double)BuDDyFactory.setMinFreeNodes0((int)(x * 100.0)) / 100.0;
    }

    private static synchronized native int setMinFreeNodes0(int var0);

    public int setMaxIncrease(int x) {
        return BuDDyFactory.setMaxIncrease0(x);
    }

    private static synchronized native int setMaxIncrease0(int var0);

    public double setIncreaseFactor(double x) {
        return BuDDyFactory.setIncreaseFactor0(x);
    }

    private static synchronized native double setIncreaseFactor0(double var0);

    public double setCacheRatio(double x) {
        return (double)BuDDyFactory.setCacheRatio0((int)(x * 100.0)) / 100.0;
    }

    private static synchronized native int setCacheRatio0(int var0);

    public int setNodeTableSize(int x) {
        return BuDDyFactory.setNodeTableSize0(x);
    }

    private static synchronized native int setNodeTableSize0(int var0);

    public int setCacheSize(int x) {
        return BuDDyFactory.setCacheSize0(x);
    }

    private static synchronized native int setCacheSize0(int var0);

    public int varNum() {
        return BuDDyFactory.varNum0();
    }

    private static synchronized native int varNum0();

    public int setVarNum(int num) {
        return BuDDyFactory.setVarNum0(num);
    }

    private static synchronized native int setVarNum0(int var0);

    public int duplicateVar(int var) {
        return BuDDyFactory.duplicateVar0(var);
    }

    private static synchronized native int duplicateVar0(int var0);

    public int extVarNum(int num) {
        return BuDDyFactory.extVarNum0(num);
    }

    private static synchronized native int extVarNum0(int var0);

    public BuDDyBDD ithVar(int var) {
        int id = BuDDyFactory.ithVar0(var);
        return BuDDyFactory.makeBDD(id);
    }

    private static synchronized native int ithVar0(int var0);

    public BuDDyBDD nithVar(int var) {
        int id = BuDDyFactory.nithVar0(var);
        return BuDDyFactory.makeBDD(id);
    }

    private static synchronized native int nithVar0(int var0);

    public void swapVar(int v1, int v2) {
        BuDDyFactory.swapVar0(v1, v2);
    }

    private static synchronized native void swapVar0(int var0, int var1);

    public void printAll() {
        BuDDyFactory.printAll0();
    }

    private static synchronized native void printAll0();

    public void printTable(BuDDyBDD bdd) {
        BuDDyFactory.printTable0(bdd._id);
    }

    private static synchronized native void printTable0(int var0);

    public BuDDyBDD load(String filename) {
        int id = BuDDyFactory.load0(filename);
        return BuDDyFactory.makeBDD(id);
    }

    private static synchronized native int load0(String var0);

    public BuDDyBDD load(BufferedReader ifile) throws IOException {
        this.tokenizer = null;
        int lh_nodenum = Integer.parseInt(this.readNext(ifile));
        int vnum = Integer.parseInt(this.readNext(ifile));
        if (lh_nodenum == 0 && vnum == 0) {
            int r = Integer.parseInt(this.readNext(ifile));
            return r == 0 ? this.zero() : this.one();
        }
        int n = 0;
        while (n < vnum) {
            Integer.parseInt(this.readNext(ifile));
            ++n;
        }
        if (vnum > this.varNum()) {
            this.setVarNum(vnum);
        }
        LoadHash[] lh_table = new LoadHash[lh_nodenum];
        int n2 = 0;
        while (n2 < lh_nodenum) {
            lh_table[n2] = new LoadHash();
            lh_table[n2].first = -1;
            lh_table[n2].next = n2 + 1;
            ++n2;
        }
        lh_table[lh_nodenum - 1].next = -1;
        int lh_freepos = 0;
        BuDDyBDD root = null;
        PrimitiveIterator.OfInt it = IntStream.range(0, lh_nodenum).iterator();
        while (it.hasNext()) {
            int key = Integer.parseInt(this.readNext(ifile));
            int var = Integer.parseInt(this.readNext(ifile));
            int lowi = Integer.parseInt(this.readNext(ifile));
            int highi = Integer.parseInt(this.readNext(ifile));
            BuDDyBDD low = this.loadhash_get(lh_table, lh_nodenum, lowi);
            BuDDyBDD high = this.loadhash_get(lh_table, lh_nodenum, highi);
            if (low == null || high == null || var < 0) {
                throw new UnsupportedOperationException("BuDDyWrapper, Incorrect file format");
            }
            BuDDyBDD b = this.ithVar(var);
            root = b.ite(high, low);
            b.free();
            int hash = key % lh_nodenum;
            int pos = lh_freepos;
            lh_freepos = lh_table[pos].next;
            lh_table[pos].next = lh_table[hash].first;
            lh_table[hash].first = pos;
            lh_table[pos].key = key;
            lh_table[pos].data = root;
        }
        BuDDyBDD tmproot = root.id();
        int[] nArray = IntStream.range(0, lh_nodenum).toArray();
        int n3 = nArray.length;
        int n4 = 0;
        while (n4 < n3) {
            int n5 = nArray[n4];
            lh_table[n5].data.free();
            ++n4;
        }
        lh_table = null;
        return tmproot;
    }

    protected String readNext(BufferedReader ifile) throws IOException {
        while (this.tokenizer == null || !this.tokenizer.hasMoreTokens()) {
            String s = ifile.readLine();
            if (s == null) {
                throw new UnsupportedOperationException("Incorrect file format");
            }
            this.tokenizer = new StringTokenizer(s);
        }
        return this.tokenizer.nextToken();
    }

    protected BuDDyBDD loadhash_get(LoadHash[] lh_table, int lh_nodenum, int key) {
        if (key < 0) {
            return null;
        }
        if (key == 0) {
            return this.zero();
        }
        if (key == 1) {
            return this.one();
        }
        int hash = lh_table[key % lh_nodenum].first;
        while (hash != -1 && lh_table[hash].key != key) {
            hash = lh_table[hash].next;
        }
        if (hash == -1) {
            return null;
        }
        return lh_table[hash].data;
    }

    public void save(String filename, BuDDyBDD bdd) {
        BuDDyFactory.save0(filename, bdd._id);
    }

    private static synchronized native void save0(String var0, int var1);

    public int level2Var(int level) {
        return BuDDyFactory.level2Var0(level);
    }

    private static synchronized native int level2Var0(int var0);

    public int var2Level(int var) {
        return BuDDyFactory.var2Level0(var);
    }

    private static synchronized native int var2Level0(int var0);

    public void addVarBlock(int first, int last, boolean fixed) {
        BuDDyFactory.addVarBlock1(first, last, fixed);
    }

    private static synchronized native void addVarBlock1(int var0, int var1, boolean var2);

    public void varBlockAll() {
        BuDDyFactory.varBlockAll0();
    }

    private static synchronized native void varBlockAll0();

    public void clearVarBlocks() {
        BuDDyFactory.clearVarBlocks0();
    }

    private static synchronized native void clearVarBlocks0();

    public int nodeCount(Collection<BuDDyBDD> r) {
        int[] a = BuDDyFactory.toBuDDyArray(r);
        return BuDDyFactory.nodeCount0(a);
    }

    private static synchronized native int nodeCount0(int[] var0);

    public int getNodeTableSize() {
        return BuDDyFactory.getAllocNum0();
    }

    private static synchronized native int getAllocNum0();

    public int getCacheSize() {
        return BuDDyFactory.getCacheSize0();
    }

    private static synchronized native int getCacheSize0();

    public int getNodeNum() {
        return BuDDyFactory.getNodeNum0();
    }

    private static synchronized native int getNodeNum0();

    private static void gc_callback(int i) {
    }

    public static class BuDDyBDD {
        protected int _id;
        static final int INVALID_BDD = -1;

        public int level() {
            return this.getBuddyFactory().var2Level(this.var());
        }

        public BuDDyBDD and(BuDDyBDD that) {
            return this.apply(that, and);
        }

        public BuDDyBDD andWith(BuDDyBDD that) {
            return this.applyWith(that, and);
        }

        public BuDDyBDD or(BuDDyBDD that) {
            return this.apply(that, or);
        }

        public BuDDyBDD orWith(BuDDyBDD that) {
            return this.applyWith(that, or);
        }

        public BuDDyBDD xor(BuDDyBDD that) {
            return this.apply(that, xor);
        }

        public BuDDyBDD imp(BuDDyBDD that) {
            return this.apply(that, imp);
        }

        private static int[] varset2levels(BuDDyBDD r) {
            int size = 0;
            BuDDyBDD p = r.id();
            while (!p.isOne() && !p.isZero()) {
                ++size;
                BuDDyBDD p2 = p.high();
                p.free();
                p = p2;
            }
            p.free();
            int[] result = new int[size];
            size = -1;
            p = r.id();
            while (!p.isOne() && !p.isZero()) {
                result[++size] = p.level();
                BuDDyBDD p2 = p.high();
                p.free();
                p = p2;
            }
            p.free();
            return result;
        }

        public BDDIterator iterator(BuDDyBDD var) {
            return new BDDIterator(this, var);
        }

        public boolean equals(Object o) {
            if (!(o instanceof BuDDyBDD)) {
                return false;
            }
            return this.equals((BuDDyBDD)o);
        }

        protected BuDDyBDD() {
        }

        protected BuDDyBDD(int id) {
            this._id = id;
            BuDDyBDD.addRef(this._id);
        }

        public BuDDyFactory getBuddyFactory() {
            return INSTANCE;
        }

        public boolean isZero() {
            return this._id == 0;
        }

        public boolean isOne() {
            return this._id == 1;
        }

        public int var() {
            return BuDDyBDD.var0(this._id);
        }

        private static synchronized native int var0(int var0);

        public BuDDyBDD high() {
            int b = BuDDyBDD.high0(this._id);
            return BuDDyFactory.makeBDD(b);
        }

        private static synchronized native int high0(int var0);

        public BuDDyBDD low() {
            int b = BuDDyBDD.low0(this._id);
            return BuDDyFactory.makeBDD(b);
        }

        private static synchronized native int low0(int var0);

        public BuDDyBDD id() {
            return BuDDyFactory.makeBDD(this._id);
        }

        public BuDDyBDD not() {
            int b = BuDDyBDD.not0(this._id);
            return BuDDyFactory.makeBDD(b);
        }

        private static synchronized native int not0(int var0);

        public BuDDyBDD ite(BuDDyBDD thenBDD, BuDDyBDD elseBDD) {
            int b = BuDDyBDD.ite0(this._id, thenBDD._id, elseBDD._id);
            return BuDDyFactory.makeBDD(b);
        }

        private static synchronized native int ite0(int var0, int var1, int var2);

        public BuDDyBDD relprod(BuDDyBDD that, BuDDyBDD var) {
            int b = BuDDyBDD.relprod0(this._id, that._id, var._id);
            return BuDDyFactory.makeBDD(b);
        }

        private static synchronized native int relprod0(int var0, int var1, int var2);

        public BuDDyBDD compose(BuDDyBDD that, int var) {
            int b = BuDDyBDD.compose0(this._id, that._id, var);
            return BuDDyFactory.makeBDD(b);
        }

        private static synchronized native int compose0(int var0, int var1, int var2);

        public BuDDyBDD constrain(BuDDyBDD var) {
            int b = BuDDyBDD.constrain0(this._id, var._id);
            return BuDDyFactory.makeBDD(b);
        }

        private static synchronized native int constrain0(int var0, int var1);

        public BuDDyBDD exist(BuDDyBDD var) {
            int b = BuDDyBDD.exist0(this._id, var._id);
            return BuDDyFactory.makeBDD(b);
        }

        private static synchronized native int exist0(int var0, int var1);

        public BuDDyBDD forAll(BuDDyBDD var) {
            int b = BuDDyBDD.forAll0(this._id, var._id);
            return BuDDyFactory.makeBDD(b);
        }

        private static synchronized native int forAll0(int var0, int var1);

        public BuDDyBDD unique(BuDDyBDD var) {
            int b = BuDDyBDD.unique0(this._id, var._id);
            return BuDDyFactory.makeBDD(b);
        }

        private static synchronized native int unique0(int var0, int var1);

        public BuDDyBDD restrict(BuDDyBDD var) {
            int b = BuDDyBDD.restrict0(this._id, var._id);
            return BuDDyFactory.makeBDD(b);
        }

        private static synchronized native int restrict0(int var0, int var1);

        public BuDDyBDD restrictWith(BuDDyBDD var) {
            int b = BuDDyBDD.restrict0(this._id, var._id);
            BuDDyBDD.addRef(b);
            BuDDyBDD.delRef(this._id);
            if (this != var) {
                BuDDyBDD.delRef(var._id);
                var._id = -1;
            }
            this._id = b;
            return this;
        }

        public BuDDyBDD simplify(BuDDyBDD that) {
            int b = BuDDyBDD.simplify0(this._id, that._id);
            return BuDDyFactory.makeBDD(b);
        }

        private static synchronized native int simplify0(int var0, int var1);

        public BuDDyBDD support() {
            int b = BuDDyBDD.support0(this._id);
            return BuDDyFactory.makeBDD(b);
        }

        private static synchronized native int support0(int var0);

        public BuDDyBDD apply(BuDDyBDD that, LogicalOperator opr) {
            if (that == null) {
                throw new RuntimeException("Apply null");
            }
            int b = BuDDyBDD.apply0(this._id, that._id, opr.id);
            return BuDDyFactory.makeBDD(b);
        }

        private static synchronized native int apply0(int var0, int var1, int var2);

        public BuDDyBDD applyWith(BuDDyBDD var, LogicalOperator opr) {
            int b = BuDDyBDD.apply0(this._id, var._id, opr.id);
            BuDDyBDD.addRef(b);
            BuDDyBDD.delRef(this._id);
            if (this != var) {
                BuDDyBDD.delRef(var._id);
                var._id = -1;
            }
            this._id = b;
            return this;
        }

        public BuDDyBDD applyAll(BuDDyBDD that, LogicalOperator opr, BuDDyBDD var) {
            int b = BuDDyBDD.applyAll0(this._id, that._id, opr.id, var._id);
            return BuDDyFactory.makeBDD(b);
        }

        private static synchronized native int applyAll0(int var0, int var1, int var2, int var3);

        public BuDDyBDD applyEx(BuDDyBDD that, LogicalOperator opr, BuDDyBDD var) {
            int b = BuDDyBDD.applyEx0(this._id, that._id, opr.id, var._id);
            return BuDDyFactory.makeBDD(b);
        }

        private static synchronized native int applyEx0(int var0, int var1, int var2, int var3);

        public BuDDyBDD applyUni(BuDDyBDD that, LogicalOperator opr, BuDDyBDD var) {
            int b = BuDDyBDD.applyUni0(this._id, that._id, opr.id, var._id);
            return BuDDyFactory.makeBDD(b);
        }

        private static synchronized native int applyUni0(int var0, int var1, int var2, int var3);

        public BuDDyBDD satOne() {
            int b = BuDDyBDD.satOne0(this._id);
            return BuDDyFactory.makeBDD(b);
        }

        private static synchronized native int satOne0(int var0);

        public BuDDyBDD satOne(BuDDyBDD var, boolean pol) {
            BuDDyBDD c = var;
            int b = BuDDyBDD.satOne1(this._id, c._id, pol ? 1 : 0);
            return BuDDyFactory.makeBDD(b);
        }

        private static synchronized native int satOne1(int var0, int var1, int var2);

        public List<byte[]> allsat() {
            return Arrays.asList(BuDDyBDD.allsat0(this._id));
        }

        private static synchronized native byte[][] allsat0(int var0);

        public int nodeCount() {
            return BuDDyBDD.nodeCount0(this._id);
        }

        private static synchronized native int nodeCount0(int var0);

        public double satCount() {
            return BuDDyBDD.satCount0(this._id);
        }

        private static synchronized native double satCount0(int var0);

        public double satCount(BuDDyBDD varset) {
            BuDDyBDD c = varset;
            return BuDDyBDD.satCount1(this._id, c._id);
        }

        private static synchronized native double satCount1(int var0, int var1);

        private static synchronized native void addRef(int var0);

        private static synchronized native void delRef(int var0);

        public void free() {
            if (this._id == 0 || this._id == 1) {
                return;
            }
            if (INSTANCE != null) {
                BuDDyBDD.delRef(this._id);
            }
            this._id = -1;
        }

        public boolean equals(BuDDyBDD that) {
            return this._id == that._id;
        }

        public int hashCode() {
            return this._id;
        }

        public static class BDDIterator
        implements Iterator<Object> {
            protected BuDDyFactory factory;
            protected int[] levels;
            protected boolean[] values;
            protected BuDDyBDD[] nodes = null;
            protected boolean more = false;

            public BDDIterator(BuDDyBDD dis, BuDDyBDD var) {
                this.factory = dis.getBuddyFactory();
                if (!dis.isZero()) {
                    this.levels = BuDDyBDD.varset2levels(var);
                    this.values = new boolean[this.levels.length];
                    this.nodes = new BuDDyBDD[this.levels.length];
                    this.fillInSatisfyingAssignment(dis.id(), 0);
                    this.more = true;
                }
            }

            protected void fillInSatisfyingAssignment(BuDDyBDD node, int i) {
                while (!node.isOne() && !node.isZero()) {
                    int v = node.level();
                    int j = i;
                    j = i;
                    while (j < this.levels.length && this.levels[j] != v) {
                        if (this.nodes[j] != null) {
                            throw new InternalError("nodes[" + j + "] should be null");
                        }
                        ++j;
                    }
                    if (j == this.levels.length) {
                        throw new UnsupportedOperationException("Exception in fillInSatisfyingAssignment: j == levels.length");
                    }
                    i = j;
                    this.nodes[i] = node;
                    BuDDyBDD node2 = node.low();
                    if (node2.isZero()) {
                        node2.free();
                        this.values[i] = true;
                        node2 = node.high();
                    }
                    node = node2;
                    ++i;
                }
            }

            protected boolean findNextSatisfyingAssignment() {
                int i = this.nodes.length - 1;
                while (i >= 0) {
                    if (this.nodes[i] != null) {
                        BuDDyBDD hi;
                        if (!this.values[i] && !(hi = this.nodes[i].high()).isZero()) {
                            this.values[i] = true;
                            this.fillInSatisfyingAssignment(hi, i + 1);
                            return true;
                        }
                        this.nodes[i].free();
                        this.nodes[i] = null;
                        this.values[i] = false;
                    }
                    --i;
                }
                return false;
            }

            protected BuDDyBDD buildAndIncrement() {
                this.more = false;
                BuDDyBDD b = this.factory.one();
                boolean carry = true;
                int i = this.levels.length - 1;
                while (i >= 0) {
                    int level = this.levels[i];
                    int var = this.factory.level2Var(level);
                    boolean val = this.values[i];
                    if (this.nodes[i] == null && carry) {
                        this.values[i] = !val;
                        this.more |= !val;
                        carry = val;
                    }
                    BuDDyBDD v = val ? this.factory.ithVar(var) : this.factory.nithVar(var);
                    b.andWith(v);
                    --i;
                }
                return b;
            }

            protected void free() {
                int i = this.levels.length - 1;
                while (i >= 0) {
                    if (this.nodes[i] != null) {
                        this.nodes[i].free();
                        this.nodes[i] = null;
                    }
                    --i;
                }
                this.nodes = null;
            }

            @Override
            public Object next() {
                if (!this.more) {
                    throw new NoSuchElementException();
                }
                BuDDyBDD b = this.buildAndIncrement();
                if (!this.more) {
                    this.more = this.findNextSatisfyingAssignment();
                    if (!this.more) {
                        this.free();
                    }
                }
                return b;
            }

            @Override
            public boolean hasNext() {
                return this.nodes != null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            protected void fastForward0(int var) {
                if (this.levels == null) {
                    throw new UnsupportedOperationException();
                }
                int level = this.factory.var2Level(var);
                int i = Arrays.binarySearch(this.levels, level);
                if (i < 0) {
                    throw new UnsupportedOperationException();
                }
                if (this.nodes[i] != null) {
                    throw new UnsupportedOperationException();
                }
                this.values[i] = true;
            }

            public void fastForward(int var) {
                this.fastForward0(var);
            }
        }
    }

    protected static class LoadHash {
        BuDDyBDD data;
        int key;
        int first;
        int next;

        protected LoadHash() {
        }
    }
}

