/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.utils.console;

import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class ErrorConsole {
    private static DateFormat dateFormat = new SimpleDateFormat("yyyy_MMdd_HHmmss");
    private static MessageConsole mc = null;
    private static MessageConsoleStream iostd = null;
    private static MessageConsoleStream ioerr = null;
    private static MessageConsoleStream iook = null;
    private static PrintStream consolestd = null;
    private static PrintStream consoleerr = null;
    private static PrintStream consoleok = null;
    private static MessageConsole mcstack = null;
    private static MessageConsoleStream iostack = null;
    private static PrintStream consolestack = null;

    static {
        try {
            consolestd = System.out;
            consoleerr = System.err;
            consoleok = System.out;
            consolestack = System.err;
            if (ConsolePlugin.getDefault() != null && ConsolePlugin.getDefault().getConsoleManager() != null) {
                mc = new MessageConsole("Default Console", null);
                mcstack = new MessageConsole("Stack Error", null);
                iostd = mc.newMessageStream();
                ioerr = mc.newMessageStream();
                iook = mc.newMessageStream();
                iostd.setActivateOnWrite(false);
                ioerr.setActivateOnWrite(false);
                iook.setActivateOnWrite(false);
                consolestd = new PrintStream((OutputStream)iostd);
                consoleerr = new PrintStream((OutputStream)ioerr);
                consoleok = new PrintStream((OutputStream)iook);
                iostack = mcstack.newMessageStream();
                consolestack = new PrintStream((OutputStream)iostack);
                iostack.setActivateOnWrite(false);
                iostd.setActivateOnWrite(false);
                ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{mcstack, mc});
                iostd.setColor(ColorConstants.black);
                ioerr.setColor(ColorConstants.red);
                iook.setColor(ColorConstants.blue);
            }
        }
        catch (Throwable ex) {
            consolestd = System.out;
            consoleerr = System.err;
            consoleok = System.out;
        }
    }

    private ErrorConsole() {
    }

    public static int println(String s) {
        try {
            if (consolestd != null) {
                consolestd.println(s);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 1;
    }

    public static int print(String s) {
        try {
            consolestd.print(s);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 1;
    }

    public static int println(Object o) {
        try {
            consolestd.println(o);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 1;
    }

    public static int printOKln(String s) {
        try {
            consolestd.flush();
            if (ioerr != null) {
                ioerr.flush();
            }
            consoleok.println(s);
            consoleok.flush();
            if (ioerr != null) {
                ioerr.flush();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 1;
    }

    public static int println() {
        try {
            consolestd.println();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 1;
    }

    public static int printWhere() {
        Exception e = new Exception();
        consolestd.println(e.getStackTrace()[1]);
        System.err.println(e.getStackTrace()[1]);
        return 1;
    }

    public static int printWhere(String s) {
        Exception e = new Exception();
        consolestd.println(e.getStackTrace()[1] + " : " + s);
        System.err.println(e.getStackTrace()[1] + " : " + s);
        return 1;
    }

    public static int printWhere(int n, String s) {
        Exception e = new Exception();
        consolestd.println(e.getStackTrace()[1] + " : " + s);
        System.err.println(e.getStackTrace()[1] + " : " + s);
        n = n < e.getStackTrace().length - 2 ? n : e.getStackTrace().length - 2;
        int i = 1;
        while (i < n) {
            consolestd.println("\t" + e.getStackTrace()[1 + i]);
            System.err.println("\t" + e.getStackTrace()[1 + i]);
            ++i;
        }
        return 1;
    }

    public static int flush() {
        consolestd.flush();
        return 1;
    }

    public static int printlnError(String s) {
        try {
            consolestd.flush();
            if (ioerr != null) {
                ioerr.flush();
            }
            consoleerr.println(s);
            consoleerr.flush();
            if (ioerr != null) {
                ioerr.flush();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 1;
    }

    public static int printError(Throwable t, String s) {
        block5: {
            if (consolestack != null) break block5;
            return 0;
        }
        try {
            t.printStackTrace();
            t.printStackTrace(consolestack);
            consolestd.flush();
            if (ioerr != null) {
                ioerr.flush();
            }
            String type = "<...>";
            type = t instanceof Error ? "ERROR" : (t instanceof Exception ? "EXCEPTION " : "THROWABLE ");
            consoleerr.println(String.valueOf(type) + s + " :" + t);
            consoleerr.flush();
            if (ioerr != null) {
                ioerr.flush();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 1;
    }

    public static int printError(Throwable t) {
        return ErrorConsole.printError(t, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDateTime() {
        DateFormat dateFormat = ErrorConsole.dateFormat;
        synchronized (dateFormat) {
            return ErrorConsole.dateFormat.format(new Date());
        }
    }

    public static StreamHandler createErrorHandler(Formatter ft) {
        if (ft == null) {
            ft = new SimpleFormatter();
        }
        return new MyConsoleHandler(consoleerr, ft);
    }

    protected static class MyConsoleHandler
    extends StreamHandler {
        public MyConsoleHandler(OutputStream out, Formatter ft) {
            super(out, ft);
        }

        @Override
        public synchronized void publish(LogRecord record) {
            super.publish(record);
            this.flush();
        }

        @Override
        public synchronized void flush() {
            super.flush();
            ErrorConsole.flush();
        }

        @Override
        public synchronized void close() {
        }
    }
}

