/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.diverse.melange.ui.templates.melange;

import fr.inria.diverse.melange.ui.templates.Activator;
import fr.inria.diverse.melange.ui.templates.MelangeTemplateMessages;
import fr.inria.diverse.melange.ui.templates.MelangeTemplateSection;
import fr.inria.diverse.melange.ui.wizards.pages.NewMelangeProjectWizardFields;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.gemoc.commons.eclipse.pde.manifest.ManifestChanger;
import org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.ui.BaseProjectWizardFields;
import org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.ui.templates.AbstractStringWithButtonOption;
import org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.ui.templates.BaseOptionTemplateSection;
import org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.ui.templates.TemplateOption;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.BundleException;

public class SimpleMTTemplate
extends MelangeTemplateSection {
    public static final String KEY_MELANGE_FILE_NAME = "melangeFileName";
    public static final String MELANGE_FILE_NAME = "Hello";
    public static final String KEY_ASPECTCLASS_POSTFIX = "aspectClassPostfix";
    public static final String KEY_METAMODEL_NAME = "metamodelName";
    public static final String METAMODEL_NAME = "MyLanguage";
    public static final String KEY_ECOREFILE_PATH = "ecoreFilePath";
    protected static final List<String> FILE_EXTENSIONS = Arrays.asList("ecore");
    NewMelangeProjectWizardFields _data;
    public IFile ecoreIFile;
    protected String ecoreProjectPath;

    public SimpleMTTemplate() {
        this.setPageCount(1);
        this.createOptions();
    }

    public String getSectionId() {
        return "SimpleMT";
    }

    public int getNumberOfWorkUnits() {
        return super.getNumberOfWorkUnits() + 1;
    }

    private void createOptions() {
        this.addOption("packageName", MelangeTemplateMessages.SimpleMTTemplate_packageName, MelangeTemplateMessages.SimpleMTTemplate_packageNameToolTip, null, 0);
        this.addOption(KEY_MELANGE_FILE_NAME, MelangeTemplateMessages.SimpleMTTemplate_melangeFileName, MelangeTemplateMessages.SimpleMTTemplate_melangeFileNameTooltip, MELANGE_FILE_NAME, 0);
        this.addOption(KEY_METAMODEL_NAME, MelangeTemplateMessages.SimpleMTTemplate_melangeMetamodelName, MelangeTemplateMessages.SimpleMTTemplate_melangeMetamodelNameToolTip, METAMODEL_NAME, 0);
        AbstractStringWithButtonOption ecoreLocationOption = new AbstractStringWithButtonOption((BaseOptionTemplateSection)this, KEY_ECOREFILE_PATH, MelangeTemplateMessages.SimpleMTTemplate_ecoreFileLocation, MelangeTemplateMessages.SimpleMTTemplate_ecoreFileLocationTooltip){

            public String doSelectButton() {
                IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                Object selection = null;
                if (workbenchWindow.getSelectionService().getSelection() instanceof IStructuredSelection) {
                    selection = ((IStructuredSelection)workbenchWindow.getSelectionService().getSelection()).getFirstElement();
                }
                final IFile selectedEcoreFile = selection != null && selection instanceof IFile && FILE_EXTENSIONS.contains(((IFile)selection).getFileExtension()) ? (IFile)selection : null;
                ViewerFilter viewerFilter = new ViewerFilter(){

                    public boolean select(Viewer viewer, Object parentElement, Object element) {
                        if (element instanceof IFile) {
                            IFile file = (IFile)element;
                            return FILE_EXTENSIONS.contains(file.getFileExtension()) && (selectedEcoreFile == null || !selectedEcoreFile.getFullPath().equals((Object)file.getFullPath()));
                        }
                        return true;
                    }
                };
                IFile[] files = WorkspaceResourceDialog.openFileSelection((Shell)workbenchWindow.getShell(), null, (String)"Select ecore", (boolean)true, null, Collections.singletonList(viewerFilter));
                if (files.length > 0) {
                    SimpleMTTemplate.this.ecoreIFile = files[0];
                    SimpleMTTemplate.this.ecoreProjectPath = files[0].getProject().getFullPath().toString();
                    String ecorePath = files[0].getFullPath().toString();
                    if (ecorePath.charAt(0) == '/') {
                        ecorePath = ecorePath.substring(1);
                    }
                    return ecorePath;
                }
                return null;
            }
        };
        ecoreLocationOption.setRequired(false);
        this.registerOption((TemplateOption)ecoreLocationOption, null, 0);
    }

    public void addPages(Wizard wizard) {
        WizardPage page = this.createPage(0, "org.eclipse.pde.doc.user.template_simple_mt");
        page.setTitle(MelangeTemplateMessages.SimpleMTTemplate_title);
        page.setDescription(MelangeTemplateMessages.SimpleMTTemplate_desc);
        wizard.addPage((IWizardPage)page);
        this.markPagesAdded();
    }

    public boolean isDependentOnParentWizard() {
        return true;
    }

    protected void initializeFields(BaseProjectWizardFields data) {
        String packageName = this.getFormattedPackageName(((NewMelangeProjectWizardFields)data).projectName);
        this.initializeOption("packageName", packageName);
        this._data = (NewMelangeProjectWizardFields)data;
    }

    public String getUsedExtensionPoint() {
        return "org.eclipse.ui.actionSets";
    }

    @Override
    public String[] getNewFiles() {
        return new String[]{"icons/"};
    }

    protected String getFormattedPackageName(String id) {
        String packageName = super.getFormattedPackageName(id);
        if (packageName.length() != 0) {
            return packageName;
        }
        return "actions";
    }

    public String getReplacementString(String fileName, String key) {
        String s = super.getReplacementString(fileName, key);
        return s;
    }

    @Override
    protected void generateFiles(IProgressMonitor monitor) throws CoreException {
        super.generateFiles(monitor);
        try {
            if (this.ecoreIFile != null) {
                ManifestChanger manifestChanger = new ManifestChanger(this.project.getFile("META-INF/MANIFEST.MF"));
                manifestChanger.addPluginDependency(this.ecoreIFile.getProject().getName(), "0.0.0", false, true);
                manifestChanger.commit();
            }
        }
        catch (IOException | BundleException e) {
            Activator.logErrorMessage(e.getMessage(), e);
        }
    }
}

