/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.ide.ui.wizards.module.example;

import java.io.File;
import java.util.List;
import org.eclipse.acceleo.ide.ui.wizards.module.example.IAcceleoInitializationStrategy;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.parser.cst.utils.FileContent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;

public class AcceleoCopyExampleInitializationStrategy
implements IAcceleoInitializationStrategy {
    private String elementKind;
    private boolean templateHasFileBlock;
    private boolean templateIsMain;
    private boolean shouldGenerateDocumentation;

    @Override
    public String getDescription() {
        return AcceleoUIMessages.getString("AcceleoCopyExampleContentStrategy.Description");
    }

    @Override
    public String getInitialFileNameFilter() {
        return "*.java";
    }

    @Override
    public boolean forceMetamodelURI() {
        return false;
    }

    @Override
    public boolean forceMetamodelType() {
        return false;
    }

    @Override
    public boolean forceHasFile() {
        return false;
    }

    @Override
    public boolean forceHasMain() {
        return false;
    }

    @Override
    public boolean forceQuery() {
        return false;
    }

    @Override
    public boolean forceTemplate() {
        return true;
    }

    @Override
    public boolean forceDocumentation() {
        return false;
    }

    @Override
    public void configure(String moduleElementKind, boolean hasFileBlock, boolean isMain, boolean generateDocumentation) {
        this.elementKind = moduleElementKind;
        this.templateHasFileBlock = hasFileBlock;
        this.templateIsMain = isMain;
        this.shouldGenerateDocumentation = generateDocumentation;
    }

    @Override
    public String getContent(IFile exampleFile, String moduleName, List<String> metamodelURI, String metamodelFileType) {
        String defaultEncoding;
        String var = metamodelFileType != null && metamodelFileType.length() > 0 ? String.valueOf('a') + String.valueOf(metamodelFileType) : "arg";
        String fileExtension = exampleFile != null && exampleFile.getFileExtension() != null ? ".concat('." + exampleFile.getFileExtension() + "')" : "";
        try {
            defaultEncoding = exampleFile != null ? exampleFile.getCharset() : "UTF-8";
        }
        catch (CoreException coreException) {
            defaultEncoding = "UTF-8";
        }
        StringBuffer buffer = new StringBuffer("[comment encoding = ");
        buffer.append(defaultEncoding);
        buffer.append(" /]\n");
        if (this.shouldGenerateDocumentation) {
            buffer.append("[**\n * The documentation of the module.\n */]\n");
        }
        buffer.append("[module " + moduleName + "('");
        int cpt = 1;
        for (String uri : metamodelURI) {
            buffer.append(uri);
            if (cpt < metamodelURI.size()) {
                buffer.append("', '");
            }
            ++cpt;
        }
        buffer.append("')/]\n\n");
        if ("template".equals(this.elementKind)) {
            if (this.shouldGenerateDocumentation) {
                buffer.append("[**\n * The documentation of the template.\n * @param " + var + "\n */]\n");
            }
            buffer.append("[template public " + moduleName + "(" + var + " : " + metamodelFileType + ")]\n");
            if (this.templateIsMain) {
                buffer.append("\t\n");
                buffer.append("\t[comment @main /]\n");
            }
            if (this.templateHasFileBlock) {
                buffer.append("\t[file (" + var + ".name" + fileExtension + ", false, '" + defaultEncoding + "')]\n");
            }
            if (exampleFile != null && exampleFile.exists()) {
                StringBuffer text = this.readExampleContent(exampleFile);
                buffer.append(text);
            } else {
                buffer.append("\t[" + var + ".name/]\n");
            }
            if (this.templateHasFileBlock) {
                buffer.append("\t[/file]\n");
            }
            if (this.templateIsMain) {
                buffer.append("\t\n");
            }
            buffer.append("[/template]\n");
        }
        return buffer.toString();
    }

    protected StringBuffer readExampleContent(IFile exampleFile) {
        StringBuffer text = FileContent.getFileContent((File)exampleFile.getLocation().toFile());
        char[] chars = new char[text.length()];
        text.getChars(0, text.length(), chars, 0);
        text = new StringBuffer();
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            if (c == '[') {
                text.append("['['/]");
            } else if (c == ']') {
                text.append("[']'/]");
            } else {
                text.append(c);
            }
            ++i;
        }
        return text;
    }
}

