/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate.wrapping;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.intermediate.wrapping.ARDCutIndexHeuristic;
import org.eclipse.elk.alg.layered.intermediate.wrapping.CuttingUtils;
import org.eclipse.elk.alg.layered.intermediate.wrapping.GraphStats;
import org.eclipse.elk.alg.layered.intermediate.wrapping.ICutIndexCalculator;
import org.eclipse.elk.alg.layered.intermediate.wrapping.MSDCutIndexHeuristic;
import org.eclipse.elk.alg.layered.options.CuttingStrategy;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.options.ValidifyStrategy;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public class SingleEdgeGraphWrapper
implements ILayoutProcessor<LGraph> {
    public void process(LGraph graph, IElkProgressMonitor progressMonitor) {
        ICutIndexCalculator icic;
        progressMonitor.begin("Path-Like Graph Wrapping", 1.0f);
        if (graph.getLayers().isEmpty()) {
            progressMonitor.done();
            return;
        }
        GraphStats gs = new GraphStats(graph);
        double sumWidth = gs.getMaxWidth() * (double)gs.longestPath;
        double currentAR = sumWidth / gs.getMaxWidth();
        if (gs.dar > currentAR) {
            progressMonitor.done();
            return;
        }
        switch ((CuttingStrategy)((Object)graph.getProperty(LayeredOptions.WRAPPING_CUTTING_STRATEGY))) {
            case MANUAL: {
                icic = new ICutIndexCalculator.ManualCutIndexCalculator();
                break;
            }
            case ARD: {
                icic = new ARDCutIndexHeuristic();
                break;
            }
            default: {
                icic = new MSDCutIndexHeuristic();
            }
        }
        List<Integer> cuts = icic.getCutIndexes(graph, gs);
        if (!icic.guaranteeValid()) {
            switch ((ValidifyStrategy)((Object)graph.getProperty(LayeredOptions.WRAPPING_VALIDIFY_STRATEGY))) {
                case LOOK_BACK: {
                    cuts = SingleEdgeGraphWrapper.validifyIndexesLookingBack(gs, cuts);
                    break;
                }
                case GREEDY: {
                    cuts = SingleEdgeGraphWrapper.validifyIndexesGreedily(gs, cuts);
                }
            }
        }
        this.performCuts(graph, gs, cuts);
        progressMonitor.done();
    }

    public static List<Integer> validifyIndexesGreedily(GraphStats gs, List<Integer> cuts) {
        ArrayList validCuts = Lists.newArrayList();
        int offset = 0;
        Iterator<Integer> cutIt = cuts.iterator();
        while (cutIt.hasNext()) {
            Integer cut = cutIt.next() + offset;
            while (cut < gs.longestPath && !gs.isCutAllowed(cut)) {
                cut = cut + 1;
                ++offset;
            }
            if (cut >= gs.longestPath) break;
            validCuts.add(cut);
        }
        return validCuts;
    }

    public static List<Integer> validifyIndexesLookingBack(GraphStats gs, List<Integer> desiredCuts) {
        if (desiredCuts.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList validCuts = Lists.newArrayList();
        validCuts.add(Integer.MIN_VALUE);
        int i = 1;
        while (i < gs.longestPath) {
            if (gs.isCutAllowed(i)) {
                validCuts.add(i);
            }
            ++i;
        }
        if (validCuts.size() == 1) {
            return Collections.emptyList();
        }
        validCuts.add(Integer.MAX_VALUE);
        return SingleEdgeGraphWrapper.validifyIndexesLookingBack(desiredCuts, (List<Integer>)validCuts);
    }

    private static List<Integer> validifyIndexesLookingBack(List<Integer> desiredCuts, List<Integer> validCuts) {
        assert (validCuts.get(0) == Integer.MIN_VALUE);
        assert (validCuts.get(validCuts.size() - 1) == Integer.MAX_VALUE);
        ArrayList finalCuts = Lists.newArrayList();
        int iIdx = 0;
        int cIdx = 0;
        int offset = 0;
        while (iIdx < validCuts.size() - 1 && cIdx < desiredCuts.size()) {
            int distHigher;
            int current = desiredCuts.get(cIdx) + offset;
            while (validCuts.get(iIdx + 1) < current) {
                ++iIdx;
            }
            assert (validCuts.get(iIdx) <= current);
            assert (current <= validCuts.get(iIdx + 1));
            int select = 0;
            int distLower = current - validCuts.get(iIdx);
            if (distLower > (distHigher = validCuts.get(iIdx + 1) - current)) {
                ++select;
            }
            finalCuts.add(validCuts.get(iIdx + select));
            offset += validCuts.get(iIdx + select) - current;
            ++cIdx;
            while (cIdx < desiredCuts.size() && desiredCuts.get(cIdx) + offset <= validCuts.get(iIdx + select)) {
                ++cIdx;
            }
            iIdx += 1 + select;
        }
        return finalCuts;
    }

    private void performCuts(LGraph graph, GraphStats gs, List<Integer> cuts) {
        if (cuts.isEmpty()) {
            return;
        }
        int index = 0;
        int newIndex = 0;
        Iterator<Integer> cutIt = cuts.iterator();
        int nextCut = cutIt.next();
        while (index < gs.longestPath) {
            if (index == nextCut) {
                newIndex = 0;
                nextCut = cutIt.hasNext() ? cutIt.next() : gs.longestPath + 1;
            }
            if (index != newIndex) {
                Layer oldLayer = graph.getLayers().get(index);
                Layer newLayer = graph.getLayers().get(newIndex);
                ArrayList nodesToMove = Lists.newArrayList(oldLayer.getNodes());
                for (LNode n : nodesToMove) {
                    n.setLayer(newLayer.getNodes().size(), newLayer);
                    if (newIndex != 0) continue;
                    ArrayList incEdges = Lists.newArrayList(n.getIncomingEdges());
                    for (LEdge e : incEdges) {
                        e.reverse(graph, true);
                        graph.setProperty(InternalProperties.CYCLIC, true);
                        CuttingUtils.insertDummies(graph, e, 1);
                    }
                }
            }
            ++newIndex;
            ++index;
        }
        ListIterator<Layer> it = graph.getLayers().listIterator();
        while (it.hasNext()) {
            Layer l = it.next();
            if (!l.getNodes().isEmpty()) continue;
            it.remove();
        }
    }
}

