/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.dsl.debug.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.gemoc.dsl.debug.CurrentSession;
import org.eclipse.gemoc.dsl.debug.DebugFactory;
import org.eclipse.gemoc.dsl.debug.DebugPackage;
import org.eclipse.gemoc.dsl.debug.DebugTarget;
import org.eclipse.gemoc.dsl.debug.DebugTargetState;
import org.eclipse.gemoc.dsl.debug.Register;
import org.eclipse.gemoc.dsl.debug.RegisterGroup;
import org.eclipse.gemoc.dsl.debug.StackFrame;
import org.eclipse.gemoc.dsl.debug.State;
import org.eclipse.gemoc.dsl.debug.Thread;
import org.eclipse.gemoc.dsl.debug.Variable;
import org.eclipse.gemoc.dsl.debug.impl.CurrentSessionImpl;
import org.eclipse.gemoc.dsl.debug.impl.DebugTargetImpl;
import org.eclipse.gemoc.dsl.debug.impl.RegisterGroupImpl;
import org.eclipse.gemoc.dsl.debug.impl.RegisterImpl;
import org.eclipse.gemoc.dsl.debug.impl.StackFrameImpl;
import org.eclipse.gemoc.dsl.debug.impl.ThreadImpl;
import org.eclipse.gemoc.dsl.debug.impl.VariableImpl;

public class DebugFactoryImpl
extends EFactoryImpl
implements DebugFactory {
    public static final String copyright = "Copyright (c) 2015 Obeo.\n All rights reserved. This program and the accompanying materials\n are made available under the terms of the Eclipse Public License v1.0\n which accompanies this distribution, and is available at\n http://www.eclipse.org/legal/epl-v10.html\n \n Contributors:\n    Obeo - initial API and implementation";

    public static DebugFactory init() {
        try {
            DebugFactory theDebugFactory = (DebugFactory)EPackage.Registry.INSTANCE.getEFactory("http://eclipse.org/eclipse/gemoc/dsl/debug");
            if (theDebugFactory != null) {
                return theDebugFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new DebugFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 1: {
                return this.createDebugTarget();
            }
            case 2: {
                return this.createThread();
            }
            case 3: {
                return this.createStackFrame();
            }
            case 4: {
                return this.createVariable();
            }
            case 5: {
                return this.createCurrentSession();
            }
            case 6: {
                return this.createRegisterGroup();
            }
            case 7: {
                return this.createRegister();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 8: {
                return this.createDebugTargetStateFromString(eDataType, initialValue);
            }
            case 9: {
                return this.createStateFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 8: {
                return this.convertDebugTargetStateToString(eDataType, instanceValue);
            }
            case 9: {
                return this.convertStateToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public DebugTarget createDebugTarget() {
        DebugTargetImpl debugTarget = new DebugTargetImpl();
        return debugTarget;
    }

    public Thread createThread() {
        ThreadImpl thread = new ThreadImpl();
        return thread;
    }

    public StackFrame createStackFrame() {
        StackFrameImpl stackFrame = new StackFrameImpl();
        return stackFrame;
    }

    public Variable createVariable() {
        VariableImpl variable = new VariableImpl();
        return variable;
    }

    public CurrentSession createCurrentSession() {
        CurrentSessionImpl currentSession = new CurrentSessionImpl();
        return currentSession;
    }

    public RegisterGroup createRegisterGroup() {
        RegisterGroupImpl registerGroup = new RegisterGroupImpl();
        return registerGroup;
    }

    public Register createRegister() {
        RegisterImpl register = new RegisterImpl();
        return register;
    }

    public DebugTargetState createDebugTargetStateFromString(EDataType eDataType, String initialValue) {
        DebugTargetState result = DebugTargetState.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertDebugTargetStateToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public State createStateFromString(EDataType eDataType, String initialValue) {
        State result = State.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertStateToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public DebugPackage getDebugPackage() {
        return (DebugPackage)this.getEPackage();
    }

    @Deprecated
    public static DebugPackage getPackage() {
        return DebugPackage.eINSTANCE;
    }
}

