/**
 * Copyright (c) 2016 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package org.eclipse.gemoc.executionframework.engine.core;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.gemoc.trace.commons.model.trace.Step;
import org.eclipse.xtend2.lib.StringConcatenation;

/**
 * An exception that is caused by anything thrown from the execution of
 * sequential operational semantics.
 */
@SuppressWarnings("all")
public class SequentialExecutionException extends RuntimeException {
  private Step<?> pendingStep;
  
  public SequentialExecutionException(final Step<?> pendingMSE, final Throwable cause) {
    this.pendingStep = this.pendingStep;
    this.initCause(cause);
  }
  
  private String prettyPrintMSEOcc() {
    if ((this.pendingStep != null)) {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("Pending MSEOccurrence: ");
      String _name = this.pendingStep.getMseoccurrence().getMse().getCaller().eClass().getName();
      _builder.append(_name);
      _builder.append(".");
      String _name_1 = this.pendingStep.getMseoccurrence().getMse().getAction().getName();
      _builder.append(_name_1);
      _builder.append(" called on ");
      EObject _caller = this.pendingStep.getMseoccurrence().getMse().getCaller();
      _builder.append(_caller);
      _builder.append(".");
      return _builder.toString();
    } else {
      return "No pending MSE.";
    }
  }
  
  @Override
  public String getMessage() {
    if (((this.getCause() != null) && (this.getCause() instanceof RollbackException))) {
      String _prettyPrintMSEOcc = this.prettyPrintMSEOcc();
      return ("An error occured during the execution of the operational semantics (originally catched as a RollbackException during the transaction commit).\n" + _prettyPrintMSEOcc);
    } else {
      if (((this.getCause() != null) && (this.getCause() instanceof InterruptedException))) {
        String _prettyPrintMSEOcc_1 = this.prettyPrintMSEOcc();
        return ("The engine thread was interrupted while it was waiting for being allowed to start an execution step\'s transaction.\n" + _prettyPrintMSEOcc_1);
      } else {
        return super.getMessage();
      }
    }
  }
}
