/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.executionframework.event.ui.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ListView;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.cell.ComboBoxListCell;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.util.StringConverter;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gemoc.executionframework.event.manager.EventInstance;
import org.eclipse.gemoc.executionframework.event.manager.IEventManager;
import org.eclipse.gemoc.executionframework.event.ui.views.EventTableView;
import org.eclipse.gemoc.trace.commons.model.trace.Step;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionEngine;
import org.eclipse.gemoc.xdsmlframework.api.engine_addon.IEngineAddon;

public class EventManagerRenderer
extends Pane
implements IEngineAddon {
    private IEventManager eventManager;
    private Resource executedModel;
    private final ObservableList<EClass> eventList = FXCollections.observableArrayList();
    private final ObservableList<EventInstance> pushedEvents = FXCollections.observableArrayList();
    private final Map<EClass, EventTableView> eventTypeToEventTableView = new HashMap<EClass, EventTableView>();
    private final Map<EClass, List<EventInstance>> eventTypeToSelectedEvents = new HashMap<EClass, List<EventInstance>>();
    private final ScrollPane scrollPane = new ScrollPane();
    private final ListView<EClass> eventListView = new ListView(this.eventList);
    private final ListView<EventInstance> pushedEventListView = new ListView(this.pushedEvents);
    private final BorderPane borderPane = new BorderPane();
    private final Button pushButton = new Button("Push");
    private final Button sendButton = new Button("Send");
    private final HBox header = new HBox();

    public EventManagerRenderer() {
        this.getChildren().add((Object)this.borderPane);
        this.borderPane.minWidthProperty().bind((ObservableValue)this.widthProperty());
        this.borderPane.maxWidthProperty().bind((ObservableValue)this.widthProperty());
        this.borderPane.minHeightProperty().bind((ObservableValue)this.heightProperty());
        this.borderPane.maxHeightProperty().bind((ObservableValue)this.heightProperty());
        this.pushButton.setOnAction(e -> this.eventTypeToSelectedEvents.get(this.eventListView.getSelectionModel().getSelectedItem()).forEach(event -> this.pushedEvents.add(event)));
        this.sendButton.setOnAction(e -> {
            this.pushedEvents.forEach(arg_0 -> ((IEventManager)this.eventManager).queueEvent(arg_0));
            this.eventTypeToEventTableView.values().forEach(t -> t.getSelectionModel().clearSelection());
            this.pushedEvents.clear();
        });
        this.header.getChildren().addAll((Object[])new Node[]{this.pushButton, this.sendButton});
        this.eventListView.setCellFactory(l -> new ComboBoxListCell((StringConverter)new StringConverter<EClass>(){

            public String toString(EClass object) {
                return object.getName();
            }

            public EClass fromString(String string) {
                return null;
            }
        }, (Object[])new EClass[0]));
        this.eventListView.getSelectionModel().selectedItemProperty().addListener((c, o, n) -> this.scrollPane.setContent((Node)this.eventTypeToEventTableView.get(n)));
        VBox leftPanel = new VBox();
        leftPanel.getChildren().addAll((Object[])new Node[]{this.eventListView, this.pushedEventListView});
        this.borderPane.setTop((Node)this.header);
        this.borderPane.setLeft((Node)leftPanel);
        this.borderPane.setCenter((Node)this.scrollPane);
        this.scrollPane.setFitToWidth(true);
        this.scrollPane.setBorder(Border.EMPTY);
        this.scrollPane.minHeightProperty().bind((ObservableValue)leftPanel.heightProperty());
        this.scrollPane.maxHeightProperty().bind((ObservableValue)leftPanel.heightProperty());
        ListChangeListener eventTypesChangeListener = c -> {
            while (c.next()) {
                c.getRemoved().stream().forEach(e -> {
                    this.eventTypeToEventTableView.remove(e);
                    this.eventTypeToSelectedEvents.remove(e);
                });
                c.getAddedSubList().stream().forEach(e -> {
                    EventTableView tableView = new EventTableView((EClass)e, this.executedModel, this.eventManager);
                    this.eventTypeToEventTableView.put((EClass)e, tableView);
                    ArrayList selectedEvents = new ArrayList();
                    this.eventTypeToSelectedEvents.put((EClass)e, selectedEvents);
                    ListChangeListener selectedEventsChangeListener = c1 -> {
                        while (c1.next()) {
                            selectedEvents.removeAll(c1.getRemoved());
                            selectedEvents.addAll(c1.getAddedSubList());
                        }
                    };
                    tableView.getSelectionModel().getSelectedItems().addListener(selectedEventsChangeListener);
                    tableView.refreshEvents();
                    tableView.minHeightProperty().bind((ObservableValue)this.scrollPane.heightProperty().subtract(2));
                });
            }
        };
        this.eventList.addListener(eventTypesChangeListener);
    }

    public void setEventInterpreter(IEventManager eventManager) {
        Runnable runnable = () -> {
            this.eventManager = eventManager;
            this.eventList.clear();
        };
        if (!Platform.isFxApplicationThread()) {
            Platform.runLater((Runnable)runnable);
        } else {
            runnable.run();
        }
    }

    public void setExecutedModel(Resource executedModel) {
        this.executedModel = executedModel;
    }

    private void refreshEvents() {
        this.eventTypeToEventTableView.entrySet().forEach(e -> {
            EventTableView tableView = (EventTableView)((Object)((Object)e.getValue()));
            tableView.refreshEvents();
        });
        EClass selectedItem = (EClass)this.eventListView.getSelectionModel().getSelectedItem();
        if (selectedItem != null) {
            EventTableView selectedTableView = this.eventTypeToEventTableView.get(selectedItem);
            if (selectedTableView != null) {
                this.scrollPane.setContent((Node)selectedTableView);
            } else {
                this.scrollPane.setContent(null);
            }
        }
    }

    public void engineStarted(IExecutionEngine<?> executionEngine) {
        this.executedModel = executionEngine.getExecutionContext().getResourceModel();
    }

    public void engineInitialized(IExecutionEngine<?> executionEngine) {
        Set eventManagers = executionEngine.getAddonsTypedBy(IEventManager.class);
        if (!eventManagers.isEmpty()) {
            this.setEventInterpreter((IEventManager)eventManagers.iterator().next());
        }
    }

    public void engineStopped(IExecutionEngine<?> engine) {
        this.executedModel = null;
        this.eventTypeToEventTableView.clear();
        Platform.runLater(() -> {
            this.eventList.clear();
            this.scrollPane.setContent(null);
        });
    }

    public void aboutToExecuteStep(IExecutionEngine<?> engine, Step<?> stepToExecute) {
        this.refreshEvents();
    }

    public void stepExecuted(IExecutionEngine<?> engine, Step<?> stepExecuted) {
        this.refreshEvents();
    }
}

