/**
 * Copyright (c) 2016, 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package org.eclipse.gemoc.opsemanticsview.gen.k3;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.Set;
import opsemanticsview.ExecutionToASEntry;
import opsemanticsview.OperationalSemanticsView;
import opsemanticsview.OpsemanticsviewFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gemoc.xdsmlframework.commons.DynamicAnnotationHelper;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.eclipse.xtext.xbase.lib.Pure;

@SuppressWarnings("all")
public class K3DynamicElementsFinder {
  private final EPackage abstractSyntax;
  
  private final EPackage executionMetamodel;
  
  @Accessors({ AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER })
  private OperationalSemanticsView view;
  
  public K3DynamicElementsFinder(final EPackage abstractSyntax, final EPackage executionMetamodel, final OperationalSemanticsView view) {
    this.abstractSyntax = abstractSyntax;
    this.executionMetamodel = executionMetamodel;
    this.view = view;
  }
  
  public void find() {
    this.findDynamicParts();
    boolean _notEquals = (!Objects.equal(this.abstractSyntax, null));
    if (_notEquals) {
      this.findMappingAsToExe();
    }
  }
  
  private void findDynamicParts() {
    Set<EClass> _set = IteratorExtensions.<EClass>toSet(Iterators.<EClass>filter(this.executionMetamodel.eAllContents(), EClass.class));
    for (final EClass c : _set) {
      boolean _isDynamic = DynamicAnnotationHelper.isDynamic(c);
      boolean _not = (!_isDynamic);
      if (_not) {
        final Function1<EStructuralFeature, Boolean> _function = new Function1<EStructuralFeature, Boolean>() {
          @Override
          public Boolean apply(final EStructuralFeature p) {
            return Boolean.valueOf(DynamicAnnotationHelper.isDynamic(p));
          }
        };
        final Iterable<EStructuralFeature> mutableProperties = IterableExtensions.<EStructuralFeature>filter(c.getEStructuralFeatures(), _function);
        if (((!Objects.equal(mutableProperties, null)) && (!IterableExtensions.isEmpty(mutableProperties)))) {
          for (final EStructuralFeature p : mutableProperties) {
            this.view.getDynamicProperties().add(p);
          }
        }
      } else {
        this.view.getDynamicClasses().add(c);
        EList<EStructuralFeature> _eStructuralFeatures = c.getEStructuralFeatures();
        for (final EStructuralFeature p_1 : _eStructuralFeatures) {
          this.view.getDynamicProperties().add(p_1);
        }
      }
    }
  }
  
  private void findMappingAsToExe() {
    this.explorePackageRecursively(this.abstractSyntax, this.executionMetamodel);
  }
  
  private void explorePackageRecursively(final EPackage asPackage, final EPackage exePackage) {
    Iterable<EClass> _filter = Iterables.<EClass>filter(asPackage.getEClassifiers(), EClass.class);
    for (final EClass asClass : _filter) {
      {
        final Function1<EClass, Boolean> _function = new Function1<EClass, Boolean>() {
          @Override
          public Boolean apply(final EClass exeC) {
            return Boolean.valueOf(asClass.getName().equals(exeC.getName()));
          }
        };
        final EClass exeClass = IterableExtensions.<EClass>findFirst(Iterables.<EClass>filter(exePackage.getEClassifiers(), EClass.class), _function);
        ExecutionToASEntry _createExecutionToASEntry = OpsemanticsviewFactory.eINSTANCE.createExecutionToASEntry();
        final Procedure1<ExecutionToASEntry> _function_1 = new Procedure1<ExecutionToASEntry>() {
          @Override
          public void apply(final ExecutionToASEntry it) {
            it.setASclass(asClass);
            it.setExecutionClass(exeClass);
          }
        };
        final ExecutionToASEntry mappingEntry = ObjectExtensions.<ExecutionToASEntry>operator_doubleArrow(_createExecutionToASEntry, _function_1);
        this.view.getExecutionToASmapping().add(mappingEntry);
      }
    }
    EList<EPackage> _eSubpackages = asPackage.getESubpackages();
    for (final EPackage asSubPackage : _eSubpackages) {
      {
        final Function1<EPackage, Boolean> _function = new Function1<EPackage, Boolean>() {
          @Override
          public Boolean apply(final EPackage p) {
            return Boolean.valueOf(p.getName().equals(asSubPackage.getName()));
          }
        };
        final EPackage exeSubPackage = IterableExtensions.<EPackage>findFirst(asPackage.getESubpackages(), _function);
        this.explorePackageRecursively(asSubPackage, exeSubPackage);
      }
    }
  }
  
  @Pure
  public OperationalSemanticsView getView() {
    return this.view;
  }
  
  protected void setView(final OperationalSemanticsView view) {
    this.view = view;
  }
}
