/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.emf.validation.validity.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.emf.validation.validity.AbstractNode;
import org.eclipse.ocl.examples.emf.validation.validity.ConstrainingNode;
import org.eclipse.ocl.examples.emf.validation.validity.LeafConstrainingNode;
import org.eclipse.ocl.examples.emf.validation.validity.Result;
import org.eclipse.ocl.examples.emf.validation.validity.ResultConstrainingNode;
import org.eclipse.ocl.examples.emf.validation.validity.ResultSet;
import org.eclipse.ocl.examples.emf.validation.validity.ResultValidatableNode;
import org.eclipse.ocl.examples.emf.validation.validity.RootConstrainingNode;
import org.eclipse.ocl.examples.emf.validation.validity.RootNode;
import org.eclipse.ocl.examples.emf.validation.validity.RootValidatableNode;
import org.eclipse.ocl.examples.emf.validation.validity.Severity;
import org.eclipse.ocl.examples.emf.validation.validity.ValidatableNode;
import org.eclipse.ocl.examples.emf.validation.validity.ValidityFactory;
import org.eclipse.ocl.examples.emf.validation.validity.locator.ConstraintLocator;
import org.eclipse.ocl.examples.emf.validation.validity.manager.ConstrainingURI;
import org.eclipse.ocl.examples.emf.validation.validity.manager.MonitorStep;
import org.eclipse.ocl.examples.emf.validation.validity.manager.TypeURI;
import org.eclipse.ocl.examples.emf.validation.validity.manager.ValidatableURI;
import org.eclipse.ocl.examples.emf.validation.validity.manager.ValidityManager;
import org.eclipse.ocl.examples.emf.validation.validity.utilities.IVisibilityFilter;
import org.eclipse.ocl.examples.emf.validation.validity.utilities.SeveritiesVisibilityFilter;
import org.eclipse.ocl.pivot.labels.ILabelGenerator;
import org.eclipse.ocl.pivot.utilities.ClassUtil;

public class ValidityModel {
    private static final Logger logger = Logger.getLogger(ValidityManager.class);
    public static final int WORK_FOR_CLEAN_UP = 50;
    public static final int WORK_FOR_CREATE_MODEL = 50;
    private static final int WORK_FOR_ANALYZE_RESOURCES = 300;
    private static final int WORK_FOR_LOCATE_CONSTRAINTS = 300;
    private static final int WORK_FOR_CREATE_RESULTS = 300;
    private static final int WORK_FOR_SORT_CONSTRAINING_NODES = 50;
    private static final int WORK_FOR_SORT_VALIDATABLE_NODES = 50;
    public static final int WORK_FOR_ALL_SET_INPUT = 1100;
    private static @NonNull Comparator<@NonNull AbstractNode> labelComparator = new Comparator<AbstractNode>(){

        @Override
        public int compare(@NonNull AbstractNode o1, @NonNull AbstractNode o2) {
            String l1 = o1.getLabel();
            String l2 = o2.getLabel();
            return l1.compareTo(l2);
        }
    };
    private static @NonNull Comparator<@NonNull AbstractNode> natureComparator = new Comparator<AbstractNode>(){

        @Override
        public int compare(@NonNull AbstractNode o1, @NonNull AbstractNode o2) {
            EClass c2;
            EClass c1 = o1.eClass();
            if (c1 == (c2 = o2.eClass())) {
                return o1.getLabel().compareTo(o2.getLabel());
            }
            String l1 = c1.getName();
            String l2 = c2.getName();
            return l1.compareTo(l2);
        }
    };
    private static @Nullable Set<@NonNull ConstraintLocator> badConstraintLocators = null;
    protected final @NonNull ValidityManager validityManager;
    private final @NonNull RootNode rootNode = ValidityFactory.eINSTANCE.createRootNode();
    private final @NonNull Map<@NonNull ConstrainingURI, @NonNull ConstrainingNode> allConstrainingNodes = new HashMap<ConstrainingURI, ConstrainingNode>();
    private final @NonNull Map<@NonNull ValidatableURI, @NonNull ValidatableNode> allValidatableNodes = new HashMap<ValidatableURI, ValidatableNode>();
    private final @NonNull Set<@NonNull IVisibilityFilter> validatableFilters = new HashSet<IVisibilityFilter>();
    private final @NonNull Set<@NonNull IVisibilityFilter> constrainingFilters = new HashSet<IVisibilityFilter>();
    private final @NonNull SeveritiesVisibilityFilter constrainingNodesFilterByKind = new SeveritiesVisibilityFilter();
    private final @NonNull SeveritiesVisibilityFilter validatableNodesFilterByKind = new SeveritiesVisibilityFilter();
    private final @NonNull Map<@NonNull TypeURI, @NonNull Set<@NonNull TypeURI>> typeClosures = new HashMap<TypeURI, Set<TypeURI>>();
    private final @NonNull Collection<@NonNull Resource> resources;
    private final @NonNull Map<@NonNull TypeURI, List<@NonNull ConstrainingURI>> type2constrainingType = new HashMap<TypeURI, List<ConstrainingURI>>();

    public ValidityModel(@NonNull ValidityManager validityManager, @NonNull Collection<@NonNull Resource> newResources) {
        this.validityManager = validityManager;
        this.resources = newResources;
    }

    public @Nullable Set<@NonNull ConstrainingURI> accumulateConstrainingURIs(@Nullable Set<@NonNull ConstrainingURI> constrainingURIs, @NonNull TypeURI typeURI) {
        List<@NonNull ConstrainingURI> moreConstrainingURIs = this.type2constrainingType.get(typeURI);
        if (moreConstrainingURIs != null) {
            if (constrainingURIs == null) {
                constrainingURIs = new HashSet<ConstrainingURI>();
            }
            constrainingURIs.addAll(moreConstrainingURIs);
        }
        return constrainingURIs;
    }

    public void addConstrainingFilter(@NonNull IVisibilityFilter filter) {
        this.constrainingFilters.add(filter);
    }

    public void addFilteredSeverity(@NonNull Severity severity) {
        this.constrainingNodesFilterByKind.addFilteredSeverity(severity);
        this.addConstrainingFilter(this.constrainingNodesFilterByKind);
        this.validatableNodesFilterByKind.addFilteredSeverity(severity);
        this.addValidatableFilter(this.validatableNodesFilterByKind);
    }

    public void addValidatableFilter(@NonNull IVisibilityFilter filter) {
        this.validatableFilters.add(filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected @NonNull Map<@NonNull EPackage, @NonNull Set<@NonNull Resource>> analyzeResources(@NonNull Collection<@NonNull Resource> resources, @NonNull Monitor monitor, int worked) {
        monitor.setTaskName("Analyzing Resources");
        MonitorStep monitorStep = new MonitorStep(monitor, worked);
        try {
            ArrayList<@NonNull Resource> allResources = new ArrayList<Resource>(resources);
            HashMap<@NonNull EPackage, @NonNull Set<@NonNull Resource>> ePackage2resources = new HashMap<EPackage, Set<Resource>>();
            int allResourcesCount = allResources.size();
            int i = 0;
            while (i < allResourcesCount) {
                Set<EClass> eClasses;
                Resource resource = (Resource)ClassUtil.nonNull((Object)((Resource)allResources.get(i)));
                @NonNull String uri = String.valueOf(resource.getURI());
                monitor.subTask("'" + uri + "'");
                ValidityManager.ANALYZE_RESOURCE.println(uri);
                ResourceSet resourceSet = resource.getResourceSet();
                if (resourceSet != null) {
                    ResourceSet resourceSet2 = resourceSet;
                    synchronized (resourceSet2) {
                        eClasses = this.analyzeResource(resource);
                    }
                } else {
                    eClasses = this.analyzeResource(resource);
                }
                HashSet<@NonNull EPackage> ePackages = new HashSet<EPackage>();
                for (EClass eClass : eClasses) {
                    ePackages.add((EPackage)ClassUtil.nonNull((Object)eClass.getEPackage()));
                    for (EClass eSuperClass : ClassUtil.nullFree((EList)eClass.getEAllSuperTypes())) {
                        ePackages.add((EPackage)ClassUtil.nonNull((Object)eSuperClass.getEPackage()));
                    }
                }
                for (EPackage ePackage : ePackages) {
                    HashSet<@NonNull Resource> ePackageResources = (HashSet<Resource>)ePackage2resources.get(ePackage);
                    if (ePackageResources == null) {
                        ePackageResources = new HashSet<Resource>();
                        ePackage2resources.put(ePackage, ePackageResources);
                    }
                    ePackageResources.add(resource);
                    String nsURI = ePackage.getNsURI();
                    if (nsURI == null) continue;
                    ValidityManager.ANALYZE_RESOURCE.println(" -> " + nsURI);
                    Iterable<@NonNull ConstraintLocator> list = this.getConstraintLocators(nsURI);
                    if (list == null) continue;
                    for (ConstraintLocator constraintLocator : list) {
                        try {
                            Collection<@NonNull Resource> moreResources = constraintLocator.getImports(ePackage, resource);
                            if (moreResources == null) continue;
                            for (Resource anotherResource : moreResources) {
                                if (allResources.contains(anotherResource)) continue;
                                allResources.add(anotherResource);
                            }
                        }
                        catch (Exception e) {
                            Set<ConstraintLocator> set;
                            Set<@NonNull ConstraintLocator> badConstraintLocators2 = badConstraintLocators;
                            if (badConstraintLocators2 == null) {
                                set = this;
                                synchronized (set) {
                                    badConstraintLocators = badConstraintLocators2 = new HashSet<ConstraintLocator>();
                                }
                            }
                            if (badConstraintLocators2.contains(constraintLocator)) continue;
                            set = badConstraintLocators2;
                            synchronized (set) {
                                if (badConstraintLocators2.add(constraintLocator)) {
                                    logger.error((Object)("ConstraintLocator " + constraintLocator + " failed"), (Throwable)e);
                                }
                            }
                        }
                    }
                }
                monitorStep.workedFraction(allResourcesCount);
                ++i;
            }
            HashMap<EPackage, Set<Resource>> hashMap = ePackage2resources;
            return hashMap;
        }
        finally {
            monitorStep.done();
        }
    }

    protected @NonNull Set<@NonNull EClass> analyzeResource(Resource resource) {
        HashSet<@NonNull EClass> eClasses = new HashSet<EClass>();
        TreeIterator tit = resource.getAllContents();
        while (tit.hasNext()) {
            @NonNull EObject eObject = (EObject)tit.next();
            @NonNull EClass eClass = eObject.eClass();
            eClasses.add(eClass);
        }
        return eClasses;
    }

    protected @NonNull Set<@NonNull TypeURI> buildTypeClosure(@NonNull EObject constrainingObject) {
        List<ConstraintLocator> constraintLocators;
        String nsURI;
        TypeURI typeURI = this.validityManager.getTypeURI(constrainingObject);
        Set<@NonNull TypeURI> typeClosure = this.typeClosures.get(typeURI);
        if (typeClosure == null) {
            typeClosure = new HashSet<TypeURI>();
            this.typeClosures.put(typeURI, typeClosure);
        }
        if ((nsURI = constrainingObject.eClass().getEPackage().getNsURI()) != null && (constraintLocators = ValidityManager.getConstraintLocators(nsURI)) != null) {
            for (ConstraintLocator constraintLocator : constraintLocators) {
                StringBuilder s = null;
                if (ValidityManager.BUILD_TYPE.isActive()) {
                    s = new StringBuilder();
                    s.append("PackageURI \"" + nsURI + "\" using \"" + constraintLocator.getName() + "\"");
                    s.append("\n  ConstraintURI \"" + this.validityManager.getConstrainingURI(constrainingObject) + "\" applies to");
                }
                Set<@NonNull TypeURI> allTypes = constraintLocator.getAllTypes(this.validityManager, constrainingObject);
                for (TypeURI aType : allTypes) {
                    if (s != null) {
                        s.append("\n    TypeURI \"" + aType + "\"");
                    }
                    typeClosure.add(aType);
                }
                if (s == null) continue;
                ValidityManager.BUILD_TYPE.println(s.toString());
            }
        }
        return typeClosure;
    }

    protected @NonNull ConstrainingNode createConstrainingNode() {
        return ValidityFactory.eINSTANCE.createConstrainingNode();
    }

    public @NonNull LeafConstrainingNode createLeafConstrainingNode() {
        return ValidityFactory.eINSTANCE.createLeafConstrainingNode();
    }

    protected @Nullable Result createResult(@Nullable IProgressMonitor monitor) {
        return ValidityFactory.eINSTANCE.createResult();
    }

    protected @NonNull ResultConstrainingNode createResultConstrainingNode() {
        return ValidityFactory.eINSTANCE.createResultConstrainingNode();
    }

    protected void createResultNodes(@NonNull Collection<@NonNull Resource> resources, @NonNull Monitor monitor, int worked) {
        monitor.setTaskName("Create Result Nodes");
        MonitorStep monitorStep = new MonitorStep(monitor, worked);
        try {
            int resourcesCount = resources.size();
            for (Resource resource : resources) {
                monitor.subTask("'" + resource.getURI() + "'");
                ConstraintLocator constraintLocator = ValidityManager.getConstraintLocator(resource);
                TreeIterator tit = resource.getAllContents();
                while (tit.hasNext()) {
                    EClass eClass;
                    ArrayList<TypeURI> typeURIkeys;
                    Set<TypeURI> typeURIs;
                    if (monitor.isCanceled()) {
                        return;
                    }
                    @NonNull EObject validatableObject = (EObject)tit.next();
                    Set<ConstrainingURI> allConstrainingURIs = null;
                    Set<TypeURI> allTypeURIs = null;
                    if (constraintLocator != null && (allTypeURIs = constraintLocator.getTypeURIs(this.validityManager, validatableObject)) != null) {
                        for (TypeURI typeURI : allTypeURIs) {
                            typeURIs = this.typeClosures.get(typeURI);
                            if (typeURIs == null) {
                                typeURIkeys = new ArrayList<TypeURI>(this.typeClosures.keySet());
                                Collections.sort(typeURIkeys);
                            }
                            if (typeURIs == null) continue;
                            for (TypeURI typeURI2 : typeURIs) {
                                if (typeURI2 == null) continue;
                                allConstrainingURIs = this.accumulateConstrainingURIs(allConstrainingURIs, typeURI2);
                            }
                        }
                    }
                    if (allTypeURIs == null && (eClass = validatableObject.eClass()) != null) {
                        TypeURI typeURI = this.validityManager.getTypeURI((EObject)eClass);
                        typeURIs = this.typeClosures.get(typeURI);
                        if (typeURIs == null) {
                            this.buildTypeClosure((EObject)eClass);
                            typeURIkeys = new ArrayList<TypeURI>(this.typeClosures.keySet());
                            Collections.sort(typeURIkeys);
                            typeURIs = this.buildTypeClosure((EObject)eClass);
                        }
                        if (typeURIs != null) {
                            for (TypeURI typeURI2 : typeURIs) {
                                allConstrainingURIs = this.accumulateConstrainingURIs(allConstrainingURIs, typeURI2);
                            }
                        }
                    }
                    if (allConstrainingURIs == null) continue;
                    ArrayList<@NonNull E> sortedURIs = new ArrayList(allConstrainingURIs);
                    Collections.sort(sortedURIs);
                    for (ConstrainingURI constrainingURI : sortedURIs) {
                        if (constrainingURI == null) continue;
                        this.createResultNodes(validatableObject, constrainingURI);
                    }
                }
                monitorStep.workedFraction(resourcesCount);
            }
        }
        finally {
            monitorStep.done();
        }
    }

    protected void createResultNodes(@NonNull EObject constrainedObject, @NonNull ConstrainingURI constrainingURI) {
        ValidatableNode validatable = this.getValidatableNode(constrainedObject);
        ConstrainingNode constrainingNode = this.allConstrainingNodes.get(constrainingURI);
        if (constrainingNode != null) {
            this.createResultNodes(validatable, constrainingNode);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void createResultNodes(@NonNull ValidatableNode validatable, @NonNull ConstrainingNode constrainingNode) {
        @NonNull EList children = ClassUtil.nullFree(constrainingNode.getChildren());
        if (children.size() > 0) {
            for (ConstrainingNode childConstrainingNode : children) {
                if (childConstrainingNode instanceof LeafConstrainingNode) {
                    ResultConstrainingNode resultConstrainingNode = this.createResultConstrainingNode();
                    ResultValidatableNode resultValidatableNode = this.createResultValidatableNode();
                    resultConstrainingNode.setResultValidatableNode(resultValidatableNode);
                    resultConstrainingNode.setLabel(this.getResultConstrainingLabel(validatable));
                    resultValidatableNode.setLabel(this.getResultValidatableLabel(childConstrainingNode));
                    childConstrainingNode.getChildren().add((Object)resultConstrainingNode);
                    validatable.getChildren().add((Object)resultValidatableNode);
                    ValidityManager.CREATE_RESULT.println(resultConstrainingNode + " => " + resultValidatableNode);
                    continue;
                }
                this.createResultNodes(validatable, childConstrainingNode);
            }
        }
    }

    protected @NonNull ResultSet createResultSet() {
        return ValidityFactory.eINSTANCE.createResultSet();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @Nullable ResultSet createResultSet(@Nullable IProgressMonitor monitor) {
        ResultSet resultSet = this.createResultSet();
        @NonNull EList results = ClassUtil.nullFree(resultSet.getResults());
        if (!this.createResults((List<Result>)results, (List<? extends ValidatableNode>)ClassUtil.nullFree(this.rootNode.getValidatableNodes()), monitor)) {
            return null;
        }
        this.rootNode.getResultSets().add((Object)resultSet);
        return resultSet;
    }

    protected @NonNull ResultValidatableNode createResultValidatableNode() {
        return ValidityFactory.eINSTANCE.createResultValidatableNode();
    }

    protected boolean createResults(@NonNull List<@NonNull Result> results, @NonNull List<@NonNull ? extends ValidatableNode> validatableNodes, @Nullable IProgressMonitor monitor) {
        int i = 0;
        while (i < validatableNodes.size()) {
            ValidatableNode validatable = (ValidatableNode)ClassUtil.nonNull((Object)validatableNodes.get(i));
            ValidatableNode parent = validatable.getParent();
            if (validatable.isEnabled() && (parent == null || parent.isEnabled()) && validatable instanceof ResultValidatableNode) {
                ResultValidatableNode resultValidatableNode = (ResultValidatableNode)validatable;
                ConstrainingNode constraint = resultValidatableNode.getResultConstrainingNode().getParent();
                Result result = this.createResult(monitor);
                if (result == null) {
                    return false;
                }
                result.setResultValidatableNode(resultValidatableNode);
                ResultConstrainingNode resultConstrainingNode = resultValidatableNode.getResultConstrainingNode();
                if (!constraint.isEnabled() || !resultConstrainingNode.isEnabled()) {
                    result.setSeverity(Severity.UNKNOWN);
                } else {
                    results.add(result);
                }
            }
            if (!this.createResults(results, (List<? extends ValidatableNode>)ClassUtil.nullFree(validatable.getChildren()), monitor)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected @NonNull RootConstrainingNode createRootConstrainingNode() {
        return ValidityFactory.eINSTANCE.createRootConstrainingNode();
    }

    protected @NonNull RootValidatableNode createRootValidatableNode() {
        return ValidityFactory.eINSTANCE.createRootValidatableNode();
    }

    protected void createTypeConstrainingNodes(@NonNull Map<@NonNull EObject, @NonNull List<@NonNull LeafConstrainingNode>> allConstraints, @NonNull Monitor monitor) {
        HashSet<@NonNull ConstrainingNode> allTypeConstrainingNodes = new HashSet<ConstrainingNode>();
        for (EObject constrainingType : allConstraints.keySet()) {
            List<LeafConstrainingNode> leafConstrainingNodes;
            if (monitor.isCanceled()) break;
            this.buildTypeClosure(constrainingType);
            TypeURI typeURI = this.validityManager.getTypeURI(constrainingType);
            List<@NonNull ConstrainingURI> typeURIconstrainingURIs = this.type2constrainingType.get(typeURI);
            if (typeURIconstrainingURIs == null) {
                typeURIconstrainingURIs = new ArrayList<ConstrainingURI>();
                this.type2constrainingType.put(typeURI, typeURIconstrainingURIs);
            }
            if ((leafConstrainingNodes = allConstraints.get(constrainingType)) == null) continue;
            for (LeafConstrainingNode leafConstrainingNode : leafConstrainingNodes) {
                Object constrainingObject = leafConstrainingNode.getConstrainingObject();
                if (constrainingObject == null) continue;
                ConstraintLocator constraintLocator = leafConstrainingNode.getConstraintLocator();
                EObject constrainingContainer = constraintLocator.getConstrainingType(constrainingType, constrainingObject);
                ConstrainingURI constrainingURI = this.validityManager.getConstrainingURI(constrainingContainer);
                if (!typeURIconstrainingURIs.contains(constrainingURI)) {
                    typeURIconstrainingURIs.add(constrainingURI);
                }
                ConstrainingNode typeConstrainingNode = this.getConstrainingNode(constrainingContainer);
                typeConstrainingNode.getChildren().add((Object)leafConstrainingNode);
                allTypeConstrainingNodes.add(typeConstrainingNode);
            }
        }
    }

    protected @NonNull ValidatableNode createValidatableNode() {
        return ValidityFactory.eINSTANCE.createValidatableNode();
    }

    public @NonNull String getConstrainingLabel(@NonNull EObject eObject) {
        return this.validityManager.getConstrainingLabel(eObject);
    }

    public @NonNull ConstrainingNode getConstrainingNode(@NonNull EObject constrainingObject) {
        ConstrainingURI constrainingURI = this.validityManager.getConstrainingURI(constrainingObject);
        ConstrainingNode constrainingNode = this.allConstrainingNodes.get(constrainingURI);
        if (constrainingNode == null) {
            EObject eContainer = constrainingObject.eContainer();
            if (eContainer == null) {
                RootConstrainingNode rootConstrainingNode = this.createRootConstrainingNode();
                this.rootNode.getConstrainingNodes().add((Object)rootConstrainingNode);
                constrainingNode = rootConstrainingNode;
            } else {
                constrainingNode = this.createConstrainingNode();
                ConstrainingNode parentConstrainingNode = this.getConstrainingNode(eContainer);
                parentConstrainingNode.getChildren().add((Object)constrainingNode);
            }
            constrainingNode.setConstrainingObject(constrainingObject);
            String label = this.validityManager.getConstrainingLabel(constrainingObject);
            constrainingNode.setLabel(label);
            constrainingNode.setEnabled(true);
            this.allConstrainingNodes.put(constrainingURI, constrainingNode);
            ValidityManager.CREATE_CONSTRAINING.println(constrainingURI + " => " + constrainingNode);
        }
        return constrainingNode;
    }

    protected @NonNull Iterable<@NonNull ConstraintLocator> getConstraintLocators(@NonNull String nsURI) {
        return this.validityManager.getActiveConstraintLocators(nsURI);
    }

    public @NonNull Collection<Resource> getResources() {
        return this.resources;
    }

    public @NonNull String getResultConstrainingLabel(@NonNull ValidatableNode validatableNode) {
        StringBuilder s = this.getResultPath(new StringBuilder(), validatableNode.getParent());
        s.append(validatableNode.getLabel());
        return s.toString();
    }

    protected @NonNull StringBuilder getResultPath(@NonNull StringBuilder s, @Nullable AbstractNode abstractNode) {
        if (abstractNode != null) {
            this.getResultPath(s, abstractNode.getParent());
            if (abstractNode instanceof ConstrainingNode) {
                s.append(ILabelGenerator.Registry.INSTANCE.labelFor(((ConstrainingNode)abstractNode).getConstrainingObject(), ValidityManager.LABEL_OPTIONS));
            } else if (abstractNode instanceof ValidatableNode) {
                s.append(ILabelGenerator.Registry.INSTANCE.labelFor((Object)((ValidatableNode)abstractNode).getConstrainedObject(), ValidityManager.LABEL_OPTIONS));
            }
            s.append("::");
        }
        return s;
    }

    public @NonNull String getResultValidatableLabel(@NonNull ConstrainingNode constrainingNode) {
        StringBuilder s = this.getResultPath(new StringBuilder(), constrainingNode.getParent());
        s.append(constrainingNode.getLabel());
        return s.toString();
    }

    public @NonNull RootNode getRootNode() {
        return this.rootNode;
    }

    protected @NonNull ValidatableNode getValidatableNode(@NonNull EObject eObject) {
        ValidatableURI validatableURI = this.validityManager.getValidatableURI(eObject);
        ValidatableNode validatable = this.allValidatableNodes.get(validatableURI);
        if (validatable == null) {
            EObject eContainer = eObject.eContainer();
            if (eContainer == null && eObject instanceof DynamicEObjectImpl) {
                EClass eClass = eObject.eClass();
                for (EStructuralFeature eStructuralFeature : eClass.getEAllStructuralFeatures()) {
                    String featureName = eStructuralFeature.getName();
                    if (featureName == null || !featureName.startsWith("base_") || !(eStructuralFeature instanceof EReference) || !eObject.eIsSet(eStructuralFeature)) continue;
                    eContainer = (EObject)eObject.eGet(eStructuralFeature);
                    break;
                }
            }
            if (eContainer != null) {
                validatable = this.createValidatableNode();
                ValidatableNode parentValidatableNode = this.getValidatableNode(eContainer);
                parentValidatableNode.getChildren().add((Object)validatable);
            } else {
                RootValidatableNode rootValidatableNode = this.createRootValidatableNode();
                this.rootNode.getValidatableNodes().add((Object)rootValidatableNode);
                validatable = rootValidatableNode;
            }
            validatable.setEnabled(true);
            validatable.setLabel(this.validityManager.getValidatableLabel(eObject, eContainer == null));
            validatable.setConstrainedObject(eObject);
            this.allValidatableNodes.put(validatableURI, validatable);
            ValidityManager.CREATE_VALIDATABLE.println(validatableURI + " => " + validatable);
        }
        return validatable;
    }

    public void init(@NonNull Monitor monitor) {
        Map<@NonNull EPackage, @NonNull Set<@NonNull Resource>> ePackage2resources = this.analyzeResources(this.resources, monitor, 300);
        Map<@NonNull EObject, @NonNull List<@NonNull LeafConstrainingNode>> allConstraints = this.locateConstraints(ePackage2resources, monitor, 300);
        if (monitor.isCanceled()) {
            return;
        }
        if (allConstraints != null) {
            this.createTypeConstrainingNodes(allConstraints, monitor);
        }
        if (monitor.isCanceled()) {
            return;
        }
        this.createResultNodes(this.resources, monitor, 300);
        if (monitor.isCanceled()) {
            return;
        }
        monitor.setTaskName("Sorting Constraints");
        EList<@NonNull RootConstrainingNode> constrainingNodes = this.rootNode.getConstrainingNodes();
        this.sortNodes(constrainingNodes, labelComparator);
        monitor.worked(50);
        if (monitor.isCanceled()) {
            return;
        }
        monitor.setTaskName("Sorting Model Elements");
        EList<@NonNull RootValidatableNode> validatableNodes = this.rootNode.getValidatableNodes();
        this.sortNodes(validatableNodes, natureComparator);
        monitor.worked(50);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected @Nullable Map<@NonNull EObject, @NonNull List<@NonNull LeafConstrainingNode>> locateConstraints(@NonNull Map<@NonNull EPackage, @NonNull Set<@NonNull Resource>> ePackage2resources, @NonNull Monitor monitor, int worked) {
        monitor.setTaskName("Locating Constraints");
        MonitorStep monitorStep = new MonitorStep(monitor, worked);
        try {
            HashMap<@NonNull EObject, @NonNull List<@NonNull LeafConstrainingNode>> allConstraints = new HashMap<EObject, List<LeafConstrainingNode>>();
            Set<@NonNull EPackage> ePackages = ePackage2resources.keySet();
            int ePackagesCount = ePackages.size();
            for (EPackage ePackage : ePackages) {
                if (monitor.isCanceled()) {
                    return null;
                }
                String nsURI = ePackage.getNsURI();
                if (nsURI != null) {
                    monitor.subTask("'" + nsURI + "'");
                    Iterable<ConstraintLocator> list = this.getConstraintLocators(nsURI);
                    if (list != null) {
                        Set<Resource> ePackageResources = ePackage2resources.get(ePackage);
                        assert (ePackageResources != null);
                        for (ConstraintLocator constraintLocator : list) {
                            if (monitor.isCanceled()) {
                                return null;
                            }
                            String subTaskName = "PackageURI \"" + nsURI + "\" - \"" + constraintLocator.getName() + "\"";
                            monitor.subTask(subTaskName);
                            ValidityManager.LOCATE_RESOURCE.println(subTaskName);
                            try {
                                Map<@NonNull EObject, @NonNull List<@NonNull LeafConstrainingNode>> availableConstraints = constraintLocator.getConstraints(this, ePackage, ePackageResources, monitor);
                                if (availableConstraints == null) continue;
                                assert (!availableConstraints.containsKey(null));
                                for (EObject constrainedType : availableConstraints.keySet()) {
                                    ArrayList typeConstraints = (ArrayList)allConstraints.get(constrainedType);
                                    if (typeConstraints == null) {
                                        typeConstraints = new ArrayList();
                                        allConstraints.put(constrainedType, typeConstraints);
                                    }
                                    int oldSize = typeConstraints.size();
                                    typeConstraints.addAll(availableConstraints.get(constrainedType));
                                    int newSize = typeConstraints.size();
                                    if (newSize <= oldSize) continue;
                                    ValidityManager.LOCATE_RESOURCE.println(String.valueOf(newSize - oldSize) + " constraints for ConstrainingURI \"" + this.validityManager.getConstrainingURI(constrainedType) + "\"");
                                }
                            }
                            catch (Exception e) {
                                Iterator<EObject> iterator;
                                Set<@NonNull ConstraintLocator> badConstraintLocators2 = badConstraintLocators;
                                if (badConstraintLocators2 == null) {
                                    iterator = this;
                                    synchronized (iterator) {
                                        badConstraintLocators = badConstraintLocators2 = new HashSet<ConstraintLocator>();
                                    }
                                }
                                if (badConstraintLocators2.contains(constraintLocator)) continue;
                                iterator = badConstraintLocators2;
                                synchronized (iterator) {
                                    if (badConstraintLocators2.add(constraintLocator)) {
                                        logger.error((Object)("ConstraintLocator " + constraintLocator + " failed"), (Throwable)e);
                                    }
                                }
                            }
                        }
                    }
                }
                monitorStep.workedFraction(ePackagesCount);
            }
            HashMap<EObject, List<LeafConstrainingNode>> hashMap = allConstraints;
            return hashMap;
        }
        finally {
            monitorStep.done();
        }
    }

    public void refreshModel(@Nullable List<@NonNull AbstractNode> grayedValidatableNodes, @Nullable List<@NonNull AbstractNode> grayedConstrainingNodes) {
        RootNode rootNode = this.validityManager.getRootNode();
        if (rootNode != null) {
            List<AbstractNode> grayedConstrainingNodes2;
            @NonNull ArrayList<@NonNull E> validatableNodes = new ArrayList(ClassUtil.nullFree(rootNode.getValidatableNodes()));
            @NonNull ArrayList<@NonNull E> constrainingNodes = new ArrayList(ClassUtil.nullFree(rootNode.getConstrainingNodes()));
            for (AbstractNode aNode : validatableNodes) {
                aNode.refreshVisibleChildren(this.validatableFilters);
            }
            for (AbstractNode aNode : constrainingNodes) {
                aNode.refreshVisibleChildren(this.constrainingFilters);
            }
            for (AbstractNode aNode : validatableNodes) {
                aNode.refreshGrayed();
            }
            for (AbstractNode aNode : constrainingNodes) {
                aNode.refreshGrayed();
            }
            List<AbstractNode> grayedValidatableNodes2 = grayedValidatableNodes;
            if (grayedValidatableNodes2 != null) {
                for (AbstractNode abstractNode : validatableNodes) {
                    abstractNode.getGrayedElements(grayedValidatableNodes2);
                }
            }
            if ((grayedConstrainingNodes2 = grayedConstrainingNodes) != null) {
                for (AbstractNode abstractNode : constrainingNodes) {
                    abstractNode.getGrayedElements(grayedConstrainingNodes2);
                }
            }
        }
    }

    public void removeConstrainingFilter(@NonNull IVisibilityFilter filter) {
        this.constrainingFilters.remove(filter);
    }

    public void removeFilteredSeverity(@NonNull Severity severity) {
        if (!this.constrainingNodesFilterByKind.removeFilteredSeverity(severity)) {
            this.constrainingFilters.remove(this.constrainingNodesFilterByKind);
        }
        if (!this.validatableNodesFilterByKind.removeFilteredSeverity(severity)) {
            this.validatableFilters.remove(this.validatableNodesFilterByKind);
        }
    }

    public void removeValidatableFilter(@NonNull IVisibilityFilter filter) {
        this.validatableFilters.remove(filter);
    }

    protected <T extends AbstractNode> void sortEList(@NonNull EList<T> nodes, @NonNull Comparator<@NonNull AbstractNode> comparator) {
        ArrayList<T> sortedList = new ArrayList<T>(nodes);
        Collections.sort(sortedList, comparator);
        int i = 0;
        while (i < sortedList.size()) {
            nodes.move(i, (Object)((AbstractNode)sortedList.get(i)));
            ++i;
        }
    }

    protected <T extends AbstractNode> void sortNodes(@NonNull EList<T> nodes, @NonNull Comparator<@NonNull AbstractNode> comparator) {
        this.sortEList(nodes, comparator);
        for (AbstractNode node : nodes) {
            this.sortNodes(ClassUtil.nullFree(node.getChildren()), comparator);
        }
    }
}

