/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.figure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.figures.RectangularDropShadowLineBorder;
import org.eclipse.sirius.diagram.AlignmentKind;
import org.eclipse.sirius.diagram.ui.tools.api.figure.AbstractTransparentNode;
import org.eclipse.sirius.diagram.ui.tools.api.figure.GaugeSectionFigure;
import org.eclipse.sirius.diagram.ui.tools.api.figure.StyledFigure;

public class GaugeCompositeFigure
extends AbstractTransparentNode
implements StyledFigure {
    private List<GaugeSectionFigure> gauges;
    private AlignmentKind alignment = AlignmentKind.HORIZONTAL_LITERAL;

    public GaugeCompositeFigure() {
        this.setLayoutManager((LayoutManager)new XYLayout());
        this.gauges = new ArrayList<GaugeSectionFigure>();
        this.setBorder((Border)new RectangularDropShadowLineBorder());
    }

    public void setBounds(Rectangle rect) {
        super.setBounds(rect);
        this.computeChildrenBounds(rect);
    }

    public void setAlignment(AlignmentKind alignment) {
        this.alignment = alignment;
    }

    public List<GaugeSectionFigure> getGauges() {
        return Collections.unmodifiableList(this.gauges);
    }

    public GaugeSectionFigure getGaugeAt(int index) {
        return this.gauges.get(index);
    }

    public void addGauge() {
        GaugeSectionFigure gauge = GaugeSectionFigure.createDefaultSection();
        this.add((IFigure)gauge, 0);
        this.gauges.add(gauge);
        this.computeChildrenBounds(this.getBounds());
    }

    protected boolean useLocalCoordinates() {
        return true;
    }

    private void computeChildrenBounds(Rectangle rect) {
        int borderInsetsH = this.getBorder() == null || this.getBorder().getInsets((IFigure)this) == null ? 0 : this.getBorder().getInsets((IFigure)this).left + this.getBorder().getInsets((IFigure)this).right;
        int borderInsetsV = this.getBorder() == null || this.getBorder().getInsets((IFigure)this) == null ? 0 : this.getBorder().getInsets((IFigure)this).top + this.getBorder().getInsets((IFigure)this).bottom;
        Dimension childDimension = null;
        int sideSize = -1;
        int vSideSize = -1;
        int nbGauges = this.gauges.size();
        if (nbGauges == 0) {
            nbGauges = 1;
        }
        switch (this.alignment) {
            case VERTICAL_LITERAL: {
                childDimension = new Dimension(rect.width - borderInsetsH, (rect.height - borderInsetsV) / nbGauges);
                break;
            }
            case HORIZONTAL_LITERAL: {
                childDimension = new Dimension((rect.width - borderInsetsH) / nbGauges, rect.height - borderInsetsV);
                break;
            }
            default: {
                vSideSize = sideSize = (int)Math.ceil(Math.sqrt(nbGauges));
                if (nbGauges != sideSize * sideSize && nbGauges % sideSize == 0) {
                    --vSideSize;
                }
                sideSize = sideSize <= 0 ? 1 : sideSize;
                vSideSize = vSideSize <= 0 ? 1 : vSideSize;
                childDimension = new Dimension((rect.width - borderInsetsH) / sideSize, (rect.height - borderInsetsV) / vSideSize);
            }
        }
        List<GaugeSectionFigure> sections = this.getGauges();
        if (!(sections instanceof RandomAccess)) {
            sections = new ArrayList<GaugeSectionFigure>(this.getGauges());
        }
        int i = 0;
        while (i < sections.size()) {
            GaugeSectionFigure figure = sections.get(i);
            Point p = null;
            switch (this.alignment) {
                case VERTICAL_LITERAL: {
                    p = new Point(0, childDimension.height * i);
                    break;
                }
                case HORIZONTAL_LITERAL: {
                    p = new Point(childDimension.width * i, 0);
                    break;
                }
                default: {
                    p = new PrecisionPoint((double)(childDimension.width * (i % sideSize)), (double)childDimension.height * (Math.floor((double)i / (double)sideSize) % (double)vSideSize));
                }
            }
            figure.setBounds(new Rectangle(p, childDimension));
            ++i;
        }
    }

    @Override
    public void setTransparent(boolean transparent) {
        super.setTransparent(transparent);
        for (GaugeSectionFigure section : this.gauges) {
            section.setTransparent(transparent);
        }
    }

    @Override
    public void setSiriusAlpha(int alpha) {
        super.setSiriusAlpha(alpha);
        for (GaugeSectionFigure section : this.gauges) {
            section.setSiriusAlpha(alpha);
        }
    }
}

