/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.dialogs.ProjectContentsLocationArea;

public class ProjectLocationSelectionDialog
extends SelectionStatusDialog {
    private Text projectNameField;
    private IProject project;
    private ProjectContentsLocationArea locationArea;
    private static String PROJECT_NAME_LABEL = IDEWorkbenchMessages.ProjectLocationSelectionDialog_nameLabel;
    private static String PROJECT_LOCATION_SELECTION_TITLE = IDEWorkbenchMessages.ProjectLocationSelectionDialog_selectionTitle;
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;

    public ProjectLocationSelectionDialog(Shell parentShell, IProject existingProject) {
        super(parentShell);
        this.setTitle(PROJECT_LOCATION_SELECTION_TITLE);
        this.setStatusLineAboveButtons(true);
        this.project = existingProject;
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        if (id == 0) {
            return super.createButton(parent, id, IDEWorkbenchMessages.ProjectLocationSelectionDialog_copyButtonLabel, defaultButton);
        }
        return super.createButton(parent, id, label, defaultButton);
    }

    private void applyValidationResult(String errorMsg, boolean infoOnly) {
        int code;
        boolean allowFinish = false;
        if (errorMsg == null) {
            code = 0;
            errorMsg = "";
            allowFinish = true;
        } else {
            code = infoOnly ? 0 : 4;
        }
        this.updateStatus((IStatus)new Status(code, "org.eclipse.ui.ide", code, errorMsg, null));
        if (this.getOkButton() != null) {
            this.getOkButton().setEnabled(allowFinish);
        }
    }

    private String checkValid() {
        String valid = this.checkValidName();
        if (valid != null) {
            return valid;
        }
        return this.locationArea.checkValidLocation();
    }

    private String checkValidName() {
        String name = this.projectNameField.getText();
        IWorkspace workspace = this.getProject().getWorkspace();
        IStatus nameStatus = workspace.validateName(name, 4);
        if (!nameStatus.isOK()) {
            return nameStatus.getMessage();
        }
        IProject newProject = workspace.getRoot().getProject(name);
        if (newProject.exists()) {
            return NLS.bind((String)IDEWorkbenchMessages.CopyProjectAction_alreadyExists, (Object)name);
        }
        return null;
    }

    protected void computeResult() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.projectNameField.getText());
        list.add(this.locationArea.getProjectLocation());
        this.setResult(list);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.ide.project_location_selection_dialog_context");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createProjectNameGroup(composite);
        this.locationArea = new ProjectContentsLocationArea(this.getErrorReporter(), composite);
        this.locationArea.updateProjectName(this.projectNameField.getText());
        return composite;
    }

    private void createNameListener() {
        Listener listener = event -> {
            this.setLocationForSelection();
            this.applyValidationResult(this.checkValid(), false);
        };
        this.projectNameField.addListener(24, listener);
    }

    private void createProjectNameGroup(Composite parent) {
        Font font = parent.getFont();
        Composite projectGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        Label projectLabel = new Label(projectGroup, 0);
        projectLabel.setFont(font);
        projectLabel.setText(PROJECT_NAME_LABEL);
        this.projectNameField = new Text(projectGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.projectNameField.setLayoutData((Object)data);
        this.projectNameField.setFont(font);
        this.projectNameField.setText(this.getCopyNameFor(this.getProject().getName()));
        this.projectNameField.selectAll();
        this.createNameListener();
    }

    private String getCopyNameFor(String projectName) {
        IWorkspace workspace = this.getProject().getWorkspace();
        if (!workspace.getRoot().getProject(projectName).exists()) {
            return projectName;
        }
        String newName = ProjectLocationSelectionDialog.computeNewName(projectName);
        while (workspace.getRoot().getProject(newName).exists()) {
            newName = ProjectLocationSelectionDialog.computeNewName(newName);
        }
        return newName;
    }

    private static String computeNewName(String str) {
        String fileNameNoExtension = str;
        Pattern p = Pattern.compile("[0-9]+$");
        Matcher m = p.matcher(fileNameNoExtension);
        if (m.find()) {
            int newNumber = Integer.parseInt(m.group()) + 1;
            return m.replaceFirst(Integer.toString(newNumber));
        }
        return String.valueOf(fileNameNoExtension) + "2";
    }

    private IProject getProject() {
        return this.project;
    }

    private void setLocationForSelection() {
        this.locationArea.updateProjectName(this.projectNameField.getText());
    }

    private ProjectContentsLocationArea.IErrorMessageReporter getErrorReporter() {
        return (errorMessage, infoOnly) -> {
            this.setMessage(errorMessage);
            this.applyValidationResult(errorMessage, infoOnly);
        };
    }
}

