/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.hierarchical;

import java.util.ArrayList;
import java.util.List;
import org.junit.platform.commons.util.BlacklistedExceptions;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.support.hierarchical.EngineExecutionContext;
import org.junit.platform.engine.support.hierarchical.ExecutionTracker;
import org.junit.platform.engine.support.hierarchical.Node;
import org.junit.platform.engine.support.hierarchical.SingleTestExecutor;

class HierarchicalTestExecutor<C extends EngineExecutionContext> {
    private static final SingleTestExecutor singleTestExecutor = new SingleTestExecutor();
    private final TestDescriptor rootTestDescriptor;
    private final EngineExecutionListener listener;
    private final C rootContext;
    private static final Node noOpNode = new Node(){};

    HierarchicalTestExecutor(ExecutionRequest request, C rootContext) {
        this.rootTestDescriptor = request.getRootTestDescriptor();
        this.listener = request.getEngineExecutionListener();
        this.rootContext = rootContext;
    }

    void execute() {
        new NodeExecutor(this.rootTestDescriptor).execute(this.rootContext, new ExecutionTracker());
    }

    private Node<C> asNode(TestDescriptor testDescriptor) {
        return testDescriptor instanceof Node ? (Node)((Object)testDescriptor) : noOpNode;
    }

    class NodeExecutor {
        private final TestDescriptor testDescriptor;
        private final Node<C> node;
        private final List<Throwable> executionErrors = new ArrayList<Throwable>();
        private C context;
        private Node.SkipResult skipResult;
        private TestExecutionResult executionResult;

        NodeExecutor(TestDescriptor testDescriptor) {
            this.testDescriptor = testDescriptor;
            this.node = HierarchicalTestExecutor.this.asNode(testDescriptor);
        }

        void execute(C parentContext, ExecutionTracker tracker) {
            tracker.markExecuted(this.testDescriptor);
            this.prepare(parentContext);
            if (this.executionErrors.isEmpty()) {
                this.checkWhetherSkipped();
            }
            if (this.executionErrors.isEmpty() && !this.skipResult.isSkipped()) {
                this.executeRecursively(tracker);
            }
            if (this.context != null) {
                this.cleanUp();
            }
            this.reportDone();
        }

        private void prepare(C parentContext) {
            try {
                this.context = this.node.prepare(parentContext);
            }
            catch (Throwable t) {
                this.addExecutionError(t);
            }
        }

        private void checkWhetherSkipped() {
            try {
                this.skipResult = this.node.shouldBeSkipped(this.context);
            }
            catch (Throwable t) {
                this.addExecutionError(t);
            }
        }

        private void executeRecursively(ExecutionTracker tracker) {
            HierarchicalTestExecutor.this.listener.executionStarted(this.testDescriptor);
            this.executionResult = singleTestExecutor.executeSafely(() -> {
                try {
                    this.context = this.node.before(this.context);
                    this.context = this.node.execute(this.context, (TestDescriptor dynamicTestDescriptor) -> {
                        HierarchicalTestExecutor.this.listener.dynamicTestRegistered(dynamicTestDescriptor);
                        new NodeExecutor(dynamicTestDescriptor).execute(this.context, tracker);
                    });
                    this.testDescriptor.getChildren().stream().filter(child -> !tracker.wasAlreadyExecuted((TestDescriptor)child)).forEach(child -> new NodeExecutor((TestDescriptor)child).execute(this.context, tracker));
                }
                finally {
                    this.node.after(this.context);
                }
            });
        }

        private void cleanUp() {
            try {
                this.node.cleanUp(this.context);
            }
            catch (Throwable t) {
                this.addExecutionError(t);
            }
        }

        private void reportDone() {
            if (this.executionResult != null) {
                this.addExecutionErrorsToTestExecutionResult();
                HierarchicalTestExecutor.this.listener.executionFinished(this.testDescriptor, this.executionResult);
            } else if (this.executionErrors.isEmpty() && this.skipResult.isSkipped()) {
                HierarchicalTestExecutor.this.listener.executionSkipped(this.testDescriptor, this.skipResult.getReason().orElse("<unknown>"));
            } else {
                HierarchicalTestExecutor.this.listener.executionStarted(this.testDescriptor);
                HierarchicalTestExecutor.this.listener.executionFinished(this.testDescriptor, this.createTestExecutionResultFromExecutionErrors());
            }
        }

        private void addExecutionErrorsToTestExecutionResult() {
            if (this.executionErrors.isEmpty()) {
                return;
            }
            if (this.executionResult.getStatus() == TestExecutionResult.Status.FAILED && this.executionResult.getThrowable().isPresent()) {
                Throwable throwable = this.executionResult.getThrowable().get();
                this.executionErrors.forEach(throwable::addSuppressed);
            } else {
                this.executionResult = this.createTestExecutionResultFromExecutionErrors();
            }
        }

        private TestExecutionResult createTestExecutionResultFromExecutionErrors() {
            Throwable throwable = this.executionErrors.get(0);
            this.executionErrors.stream().skip(1L).forEach(throwable::addSuppressed);
            return TestExecutionResult.failed(throwable);
        }

        private void addExecutionError(Throwable throwable) {
            BlacklistedExceptions.rethrowIfBlacklisted((Throwable)throwable);
            this.executionErrors.add(throwable);
        }
    }
}

