/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.script.acceleo.exception;

import org.eclipse.gendoc.services.exception.ParsingException;

public class AcceleoParsingException
extends ParsingException {
    private static final long serialVersionUID = 4511151515965253914L;
    private static final String INVOCATION_NOT_TERMINATED = "The invocation isn't terminated";
    private static final String MODULE_NOT_FOUND = "Module .* not found.*";
    private static final String OPERATION_NOT_FOUND = "Cannot find operation";
    private static final String INVALID_BLOCK = "!CSTParser.InvalidBlock!";

    public AcceleoParsingException(String message) {
        super(message);
        if (INVOCATION_NOT_TERMINATED.equals(message)) {
            this.setUIMessage("Brackets are not correctly closed inside <gendoc> tags : use [___/] or [___]...[/__])");
        } else if (message.matches(MODULE_NOT_FOUND)) {
            this.setUIMessage(String.valueOf(message) + ". Maybe the external bundle referencing this module is not installed.");
        } else if (message.contains(OPERATION_NOT_FOUND)) {
            this.setUIMessage(String.valueOf(message) + ". Try to add the necessary external bundle inside attribute 'importedBundles' of <context> tag.");
        } else if (INVALID_BLOCK.contains(message)) {
            this.setUIMessage("The Acceleo script contains invalid blocks. Check that all tags are well formed.");
        }
    }
}

