/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.services.xlsx;

import java.io.IOException;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.gendoc.document.parser.documents.XMLParser;
import org.eclipse.gendoc.document.parser.xlsx.XLSXDocument;
import org.eclipse.gendoc.document.parser.xlsx.XLSXParser;
import org.eclipse.gendoc.document.parser.xlsx.helper.XPathXlsxUtils;
import org.eclipse.gendoc.documents.AbstractImageService;
import org.eclipse.gendoc.documents.IAdditionalResourceService;
import org.eclipse.gendoc.documents.IDocumentService;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.exception.AdditionalResourceException;
import org.eclipse.gendoc.tags.ITag;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XLSXImageService
extends AbstractImageService {
    public String manageImage(ITag tag, String imageId, String filePath, boolean keepH, boolean keepW, boolean maxH, boolean maxW) throws AdditionalResourceException {
        IDocumentService documentService = (IDocumentService)GendocServices.getDefault().getService(IDocumentService.class);
        XLSXDocument document = (XLSXDocument)documentService.getDocument();
        XMLParser parser = document.getXMLParser();
        if (!(parser instanceof XLSXParser)) {
            return "";
        }
        IAdditionalResourceService additionalResourceService = documentService.getAdditionalResourceService();
        String imageFileName = additionalResourceService.getImageRelativePath(imageId);
        int index = imageFileName.lastIndexOf("/");
        if (index != -1) {
            imageFileName = imageFileName.substring(index + 1);
        }
        XLSXParser xlsxParser = (XLSXParser)parser;
        try {
            String drawingId = XPathXlsxUtils.evaluateText((Node)xlsxParser.getDocument(), (String)"/:worksheet/:drawing/@r:id");
            XMLParser drawingParser = null;
            drawingParser = drawingId.isEmpty() ? this.createDrawingPart(document, xlsxParser) : xlsxParser.loadExplicitPartDocument("http://schemas.openxmlformats.org/officeDocument/2006/relationships/drawing", drawingId);
            int nextId = XPathXlsxUtils.evaluateMax((Node)drawingParser.getDocument(), (String)"//@id") + 1;
            if (nextId < 0) {
                nextId = 1;
            }
            Element wsDrEl = drawingParser.getDocument().getDocumentElement();
            Element anchor = (Element)XPathXlsxUtils.parserXmlFragment((String)("<xdr:twoCellAnchor xmlns:xdr=\"http://schemas.openxmlformats.org/drawingml/2006/spreadsheetDrawing\" xmlns:a=\"http://schemas.openxmlformats.org/drawingml/2006/main\" editAs=\"oneCell\"><xdr:from><xdr:col>0</xdr:col><xdr:colOff>0</xdr:colOff><xdr:row>0</xdr:row><xdr:rowOff>0</xdr:rowOff></xdr:from><xdr:to> <xdr:col>0</xdr:col><xdr:colOff>0</xdr:colOff><xdr:row>0</xdr:row><xdr:rowOff>0</xdr:rowOff></xdr:to><xdr:pic><xdr:nvPicPr><xdr:cNvPr id=\"" + nextId + "\" name=\"" + imageFileName + "\"/>" + "<xdr:cNvPicPr/>" + "</xdr:nvPicPr>" + "<xdr:blipFill>" + "<a:blip xmlns:r=\"" + "http://schemas.openxmlformats.org/officeDocument/2006/relationships" + "\" " + "r:embed=\"" + imageId + "\"/>" + "<a:stretch>" + "<a:fillRect/>" + "</a:stretch>" + "</xdr:blipFill>" + "<xdr:spPr>" + "<a:prstGeom prst=\"rect\">" + "<a:avLst />" + "</a:prstGeom>" + "</xdr:spPr>" + "</xdr:pic>" + "<xdr:clientData/>" + "</xdr:twoCellAnchor>"));
            anchor = (Element)wsDrEl.appendChild(wsDrEl.getOwnerDocument().importNode(anchor, true));
            String nodeXpath = XPathXlsxUtils.getNodeXPath((Element)anchor);
            String str = String.format("&lt;gendoc:mark id=\"image\" xlpart=\"%s\" path=\"%s\" kind=\"0\" imageId=\"%s\" keepH=\"%b\" keepW=\"%b\" maxH=\"%b\" maxW=\"%b\"/&gt;", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/drawing", nodeXpath, imageId, keepH, keepW, maxH, maxW);
            return str;
        }
        catch (Exception e) {
            throw new AdditionalResourceException(e.getMessage() == null ? "" : e.getMessage(), (Throwable)e);
        }
    }

    private XMLParser createDrawingPart(XLSXDocument doc, XLSXParser worksheetPart) throws IOException {
        String target = doc.getNextDocumentName("/xl/drawings/drawing*.xml");
        XMLParser parser = doc.createSubdocument(target, (CharSequence)"<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><xdr:wsDr xmlns:xdr=\"http://schemas.openxmlformats.org/drawingml/2006/spreadsheetDrawing\" xmlns:a=\"http://schemas.openxmlformats.org/drawingml/2006/main\"></xdr:wsDr>");
        String drawingId = worksheetPart.addRelationship("http://schemas.openxmlformats.org/officeDocument/2006/relationships/drawing", target);
        try {
            Element wsEl = (Element)XPathXlsxUtils.evaluateNode((Node)worksheetPart.getDocument(), (String)"/:worksheet");
            Element refEl = XPathXlsxUtils.evaluateFirstOf((Node)wsEl, (String)".", (String[])new String[]{"legacyDrawing", "legacyDrawingHF", "picture", "oleObjects", "controls", "webPublishItems", "tableParts", "extLst"});
            Element drawingEl = (Element)wsEl.insertBefore(wsEl.getOwnerDocument().createElementNS("http://schemas.openxmlformats.org/spreadsheetml/2006/main", "drawing"), refEl);
            drawingEl.setAttributeNS("http://schemas.openxmlformats.org/officeDocument/2006/relationships", "r:id", drawingId);
            XMLParser ctParser = doc.getSubdocument("[Content_Types].xml");
            Element el = (Element)ctParser.getDocument().getDocumentElement().appendChild(ctParser.getDocument().createElementNS("http://schemas.openxmlformats.org/package/2006/content-types", "ct:Override"));
            el.setAttribute("PartName", target);
            el.setAttribute("ContentType", "application/vnd.openxmlformats-officedocument.drawing+xml");
            return parser;
        }
        catch (XPathExpressionException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

