/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.actions;

import com.google.gson.Gson;
import com.google.inject.Inject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.eclipse.glsp.graph.GGraph;
import org.eclipse.glsp.server.actions.Action;
import org.eclipse.glsp.server.actions.BasicActionHandler;
import org.eclipse.glsp.server.actions.SaveModelAction;
import org.eclipse.glsp.server.actions.SetDirtyStateAction;
import org.eclipse.glsp.server.features.modelsourcewatcher.ModelSourceWatcher;
import org.eclipse.glsp.server.jsonrpc.GraphGsonConfiguratorFactory;
import org.eclipse.glsp.server.model.GModelState;
import org.eclipse.glsp.server.utils.ClientOptions;

public class SaveModelActionHandler
extends BasicActionHandler<SaveModelAction> {
    private static final Logger LOG = Logger.getLogger(SaveModelActionHandler.class);
    @Inject
    protected GraphGsonConfiguratorFactory gsonConfigurationFactory;
    @Inject
    private ModelSourceWatcher modelSourceWatcher;

    @Override
    public List<Action> executeAction(SaveModelAction action, GModelState modelState) {
        this.modelSourceWatcher.pauseWatching(modelState);
        try {
            this.saveModelState(modelState);
        }
        finally {
            this.modelSourceWatcher.continueWatching(modelState);
        }
        return this.listOf(new SetDirtyStateAction(modelState.isDirty()));
    }

    protected void saveModelState(GModelState modelState) {
        this.convertToFile(modelState).ifPresent(file -> {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream((File)file), StandardCharsets.UTF_8);){
                    Gson gson = this.gsonConfigurationFactory.configureGson().setPrettyPrinting().create();
                    gson.toJson(modelState.getRoot(), GGraph.class, (Appendable)writer);
                    modelState.saveIsDone();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                LOG.error((Object)e);
            }
        });
    }

    protected Optional<File> convertToFile(GModelState modelState) {
        Optional<String> sourceUriOpt = ClientOptions.getValue(modelState.getClientOptions(), "sourceUri");
        if (sourceUriOpt.isPresent()) {
            return Optional.of(new File(sourceUriOpt.get()));
        }
        return Optional.empty();
    }
}

