/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.features.modelsourcewatcher;

import com.google.inject.Inject;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.glsp.server.actions.ActionDispatcher;
import org.eclipse.glsp.server.disposable.IDisposable;
import org.eclipse.glsp.server.features.modelsourcewatcher.ModelSourceChangedAction;
import org.eclipse.glsp.server.features.modelsourcewatcher.ModelSourceWatcher;
import org.eclipse.glsp.server.model.GModelState;
import org.eclipse.glsp.server.protocol.ClientSessionListener;
import org.eclipse.glsp.server.protocol.ClientSessionManager;
import org.eclipse.glsp.server.protocol.GLSPClient;
import org.eclipse.glsp.server.utils.ClientOptions;
import org.eclipse.glsp.server.utils.Debouncer;

public class FileWatcher
implements ClientSessionListener,
ModelSourceWatcher {
    protected Debouncer<ClientNotification> clientNotificationDebouncer;
    @Inject
    protected ActionDispatcher actionDispatcher;
    protected final ClientSessionManager sessionManager;
    protected int debounceDelay = 500;
    protected final Map<String, List<FileWatchWorker>> workers = new HashMap<String, List<FileWatchWorker>>();

    @Inject
    public FileWatcher(ClientSessionManager sessionManager) {
        this.sessionManager = sessionManager;
        this.sessionManager.addListener(this);
    }

    public FileWatcher(ClientSessionManager sessionManager, ActionDispatcher actionDispatcher) {
        this(sessionManager);
        this.actionDispatcher = actionDispatcher;
    }

    public int getDebounceDelay() {
        return this.debounceDelay;
    }

    public void setDebounceDelay(int debounceDelay) {
        this.debounceDelay = debounceDelay;
    }

    @Override
    public void clientDisconnected(GLSPClient client) {
        this.sessionManager.removeListener(this);
    }

    @Override
    public void sessionClosed(String clientId, GLSPClient client) {
        this.stop(clientId);
    }

    @Override
    public void startWatching(GModelState modelState) {
        this.start(modelState);
    }

    @Override
    public void stopWatching(GModelState modelState) {
        this.stop(modelState.getClientId());
    }

    @Override
    public void pauseWatching(GModelState modelState) {
        this.getAllWorkers(modelState.getClientId()).forEach(FileWatchWorker::pauseNotifications);
    }

    @Override
    public void continueWatching(GModelState modelState) {
        this.getAllWorkers(modelState.getClientId()).forEach(FileWatchWorker::continueNotifications);
    }

    protected void start(GModelState modelState) {
        IDisposable.disposeIfExists(this.clientNotificationDebouncer);
        this.clientNotificationDebouncer = new Debouncer<ClientNotification>(this::notifyClient, this.getDebounceDelay(), TimeUnit.MILLISECONDS);
        this.createWorkers(modelState).forEach(Thread::start);
    }

    protected void stop(String clientId) {
        this.disposeAllWorkers(clientId);
        IDisposable.disposeIfExists(this.clientNotificationDebouncer);
    }

    protected List<Path> getPaths(GModelState modelState) {
        return ClientOptions.getSourceUriAsFile(modelState.getClientOptions()).stream().map(file -> file.toPath()).collect(Collectors.toList());
    }

    private List<FileWatchWorker> createWorkers(GModelState modelState) {
        this.stopAllWorkers(modelState.getClientId());
        List<FileWatchWorker> fileWorkers = this.createFileWatchWorkers(modelState);
        this.workers.put(modelState.getClientId(), fileWorkers);
        return fileWorkers;
    }

    private void disposeAllWorkers(String clientId) {
        this.stopAllWorkers(clientId);
        this.workers.remove(clientId);
    }

    private void stopAllWorkers(String clientId) {
        this.getAllWorkers(clientId).forEach(FileWatchWorker::stopWorking);
    }

    protected Stream<FileWatchWorker> getAllWorkers(String clientId) {
        return Optional.ofNullable(this.workers.get(clientId)).stream().flatMap(Collection::stream);
    }

    private List<FileWatchWorker> createFileWatchWorkers(GModelState modelState) {
        return this.getPaths(modelState).stream().map(path -> new FileWatchWorker(modelState.getClientId(), (Path)path)).collect(Collectors.toList());
    }

    protected void scheduleClientNotification(String clientId, Path filePath) {
        this.clientNotificationDebouncer.accept(new ClientNotification(clientId, filePath.getFileName().toString()));
    }

    protected void notifyClient(ClientNotification clientNotification) {
        this.actionDispatcher.dispatch(clientNotification.clientId, new ModelSourceChangedAction(clientNotification.modelSourceName));
    }

    protected class ClientNotification {
        private final String clientId;
        private final String modelSourceName;

        ClientNotification(String clientId, String modelSourceName) {
            this.clientId = clientId;
            this.modelSourceName = modelSourceName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getEnclosingInstance().hashCode();
            result = 31 * result + Objects.hash(this.clientId, this.modelSourceName);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ClientNotification)) {
                return false;
            }
            ClientNotification other = (ClientNotification)obj;
            if (!this.getEnclosingInstance().equals(other.getEnclosingInstance())) {
                return false;
            }
            return Objects.equals(this.clientId, other.clientId) && Objects.equals(this.modelSourceName, other.modelSourceName);
        }

        private FileWatcher getEnclosingInstance() {
            return FileWatcher.this;
        }
    }

    class FileWatchWorker
    extends Thread {
        private boolean stopped;
        private boolean paused;
        private final String clientId;
        private final Path filePath;
        private WatchKey key;

        FileWatchWorker(String clientId, Path filePath) {
            this.clientId = clientId;
            this.filePath = filePath;
            this.setName("File watcher: file " + filePath + " [" + clientId + "]");
        }

        @Override
        public void run() {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (WatchService watchService = FileSystems.getDefault().newWatchService();){
                    Path directory = this.filePath.getParent();
                    this.key = directory.register(watchService, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
                    while (!this.stopped) {
                        WatchKey newKey = watchService.take();
                        if (this.key != newKey) continue;
                        this.pollEventsAndNotifyClient(directory);
                        if (this.key.reset()) continue;
                        break;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | InterruptedException | ClosedWatchServiceException e) {
                Thread.currentThread().interrupt();
            }
        }

        private void pollEventsAndNotifyClient(Path directory) throws IOException {
            for (WatchEvent<?> event : this.key.pollEvents()) {
                if (this.paused || this.stopped || !Files.isSameFile(directory.resolve((Path)event.context()), this.filePath)) continue;
                FileWatcher.this.scheduleClientNotification(this.clientId, this.filePath);
            }
        }

        public void stopWorking() {
            this.stopped = true;
            if (this.key != null) {
                this.key.reset();
            }
            this.interrupt();
        }

        public void pauseNotifications() {
            this.paused = true;
        }

        public void continueNotifications() {
            this.paused = false;
        }
    }
}

