/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.launch;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.glsp.server.di.GLSPModule;

public abstract class GLSPServerLauncher {
    private final GLSPModule glspModule;
    private final List<Module> modules;

    public GLSPServerLauncher(GLSPModule glspModule) {
        this.glspModule = glspModule;
        this.modules = new ArrayList<Module>();
        this.modules.add((Module)glspModule);
    }

    public void addAdditionalModules(Module ... modules) {
        Arrays.stream(modules).filter(module -> !this.modules.contains(module)).forEach(this.modules::add);
    }

    public Injector createInjector() {
        return Guice.createInjector(this.modules);
    }

    public abstract void start(String var1, int var2);

    public abstract void shutdown();

    public GLSPModule getGLSPModule() {
        return this.glspModule;
    }
}

