/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.operations.gmodel;

import org.apache.log4j.Logger;
import org.eclipse.glsp.graph.GDimension;
import org.eclipse.glsp.graph.GModelIndex;
import org.eclipse.glsp.graph.GNode;
import org.eclipse.glsp.graph.GPoint;
import org.eclipse.glsp.server.model.GModelState;
import org.eclipse.glsp.server.operations.BasicOperationHandler;
import org.eclipse.glsp.server.operations.ChangeBoundsOperation;
import org.eclipse.glsp.server.protocol.GLSPServerException;
import org.eclipse.glsp.server.types.ElementAndBounds;

public class ChangeBoundsOperationHandler
extends BasicOperationHandler<ChangeBoundsOperation> {
    private static Logger log = Logger.getLogger(ChangeBoundsOperationHandler.class);

    @Override
    public void executeOperation(ChangeBoundsOperation operation, GModelState modelState) {
        for (ElementAndBounds element : operation.getNewBounds()) {
            this.changeElementBounds(element.getElementId(), element.getNewPosition(), element.getNewSize(), modelState);
        }
    }

    private void changeElementBounds(String elementId, GPoint newPosition, GDimension newSize, GModelState modelState) {
        if (elementId == null) {
            log.warn((Object)"Invalid ChangeBounds Action; missing mandatory arguments");
            return;
        }
        GModelIndex index = modelState.getIndex();
        GNode nodeToUpdate = (GNode)GLSPServerException.getOrThrow(index.findElementByClass(elementId, GNode.class), "GNode with id " + elementId + " not found");
        nodeToUpdate.setPosition(newPosition);
        nodeToUpdate.setSize(newSize);
    }
}

