/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.utils;

import java.util.Collection;
import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.glsp.graph.GAlignable;
import org.eclipse.glsp.graph.GBounds;
import org.eclipse.glsp.graph.GBoundsAware;
import org.eclipse.glsp.graph.GDimension;
import org.eclipse.glsp.graph.GEdge;
import org.eclipse.glsp.graph.GGraph;
import org.eclipse.glsp.graph.GModelElement;
import org.eclipse.glsp.graph.GModelIndex;
import org.eclipse.glsp.graph.GModelRoot;
import org.eclipse.glsp.graph.GPoint;
import org.eclipse.glsp.graph.GraphFactory;
import org.eclipse.glsp.graph.util.GraphUtil;
import org.eclipse.glsp.server.features.core.model.ComputedBoundsAction;
import org.eclipse.glsp.server.model.GModelState;
import org.eclipse.glsp.server.types.ElementAndAlignment;
import org.eclipse.glsp.server.types.ElementAndBounds;
import org.eclipse.glsp.server.types.GLSPServerException;
import org.eclipse.glsp.server.utils.GeometryUtil;

public final class LayoutUtil {
    private LayoutUtil() {
    }

    public static void applyBounds(GModelRoot root, ComputedBoundsAction action, GModelState modelState) {
        GModelElement element;
        GModelIndex index = modelState.getIndex();
        for (ElementAndBounds b : action.getBounds()) {
            element = (GModelElement)GLSPServerException.getOrThrow(index.get(b.getElementId()), "Model element not found! ID: " + b.getElementId());
            if (!(element instanceof GBoundsAware)) continue;
            GBoundsAware bae = (GBoundsAware)element;
            if (b.getNewPosition() != null) {
                bae.setPosition(GraphUtil.copy((GPoint)b.getNewPosition()));
            }
            if (b.getNewSize() == null) continue;
            bae.setSize(GraphUtil.copy((GDimension)b.getNewSize()));
        }
        for (ElementAndAlignment a : action.getAlignments()) {
            element = (GModelElement)GLSPServerException.getOrThrow(index.get(a.getElementId()), "Model element not found! ID: " + a.getElementId());
            if (!(element instanceof GAlignable)) continue;
            GAlignable alignable = (GAlignable)element;
            alignable.setAlignment(a.getNewAlignment());
        }
    }

    public static GPoint getRelativeLocation(GPoint absoluteLocation, GModelElement container) {
        boolean allowNegativeCoordinates = container instanceof GGraph;
        GModelElement modelElement = container;
        if (modelElement instanceof GBoundsAware) {
            try {
                GPoint relativePosition = GeometryUtil.absoluteToRelative(absoluteLocation, (GBoundsAware)modelElement);
                GPoint relativeLocation = allowNegativeCoordinates ? relativePosition : GraphUtil.point((double)Math.max(0.0, relativePosition.getX()), (double)Math.max(0.0, relativePosition.getY()));
                return relativeLocation;
            }
            catch (IllegalArgumentException ex) {
                return absoluteLocation;
            }
        }
        return null;
    }

    public static GPoint asPoint(GBounds bounds) {
        GPoint point = GraphFactory.eINSTANCE.createGPoint();
        point.setX(bounds.getX());
        point.setY(bounds.getY());
        return point;
    }

    public static GDimension asDimension(GBounds bounds) {
        GDimension dimension = GraphFactory.eINSTANCE.createGDimension();
        dimension.setHeight(bounds.getHeight());
        dimension.setWidth(bounds.getWidth());
        return dimension;
    }

    public static void copyLayoutData(GModelRoot fromRoot, GModelRoot toRoot) {
        GModelIndex oldIndex = GModelIndex.get((GModelElement)fromRoot);
        LayoutUtil.copyLayoutDataRecursively((GModelElement)toRoot, oldIndex);
    }

    private static void copyLayoutDataRecursively(GModelElement element, GModelIndex oldIndex) {
        Optional oldElement;
        if (element instanceof GBoundsAware) {
            oldElement = oldIndex.get(element.getId());
            if (oldElement.isPresent() && oldElement.get() instanceof GBoundsAware) {
                GBoundsAware newBae = (GBoundsAware)element;
                GBoundsAware oldBae = (GBoundsAware)oldElement.get();
                if (oldBae.getPosition() != null) {
                    newBae.setPosition((GPoint)EcoreUtil.copy((EObject)oldBae.getPosition()));
                }
                if (oldBae.getSize() != null) {
                    newBae.setSize((GDimension)EcoreUtil.copy((EObject)oldBae.getSize()));
                }
            }
        } else if (element instanceof GEdge && (oldElement = oldIndex.get(element.getId())).isPresent() && oldElement.get() instanceof GEdge && ((GEdge)oldElement.get()).getRoutingPoints() != null) {
            GEdge gEdge = (GEdge)element;
            gEdge.getRoutingPoints().clear();
            gEdge.getRoutingPoints().addAll(EcoreUtil.copyAll((Collection)((GEdge)oldElement.get()).getRoutingPoints()));
        }
        if (element.getChildren() != null) {
            for (GModelElement child : element.getChildren()) {
                LayoutUtil.copyLayoutDataRecursively(child, oldIndex);
            }
        }
    }
}

