/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.launch;

import java.util.function.Predicate;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.glsp.server.utils.LaunchUtil;

public abstract class CLIParser {
    protected static final Logger LOGGER = LogManager.getLogger(CLIParser.class);
    protected static final String INVALID_ARGUMENT_MESSAGE = "%s' is not a valid argument for option '--%s'! The default value '%s' is used.";
    protected final CommandLine cmd;
    protected final Options options;
    protected final String processName;

    public CLIParser(String[] args, Options options, String processName) throws ParseException {
        this.cmd = new DefaultParser().parse(options, args);
        this.options = options;
        this.processName = processName;
    }

    public boolean hasOption(String optionName) {
        return this.cmd.hasOption(optionName);
    }

    public String parseOption(String optionName, String defaultValue) {
        return this.parseOption(optionName, defaultValue, null);
    }

    public String parseOption(String optionName, String defaultValue, Predicate<String> validator) {
        String arg = this.cmd.getOptionValue(optionName);
        if (arg != null) {
            if (validator == null || validator.test(arg)) {
                return arg;
            }
            LOGGER.warn(String.format(INVALID_ARGUMENT_MESSAGE, arg, optionName, defaultValue));
        }
        return defaultValue;
    }

    public int parseIntOption(String optionName, int defaultValue) {
        return this.parseIntOption(optionName, defaultValue, null);
    }

    public int parseIntOption(String optionName, int defaultValue, Predicate<Integer> validator) {
        String intArg = this.cmd.getOptionValue(optionName);
        int value = defaultValue;
        if (intArg != null) {
            try {
                value = Integer.parseInt(intArg);
                if (validator != null && !validator.test(value)) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException e) {
                LOGGER.warn(String.format(INVALID_ARGUMENT_MESSAGE, intArg, optionName, defaultValue));
            }
        }
        return value;
    }

    public boolean parseBoolOption(String optionName, boolean defaultValue) {
        String arg = this.cmd.getOptionValue(optionName);
        return arg != null ? Boolean.parseBoolean(arg) : defaultValue;
    }

    public void printHelp() {
        LaunchUtil.printHelp(this.processName, this.options);
    }

    public CommandLine getCmd() {
        return this.cmd;
    }
}

