/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.utils;

import java.util.List;
import org.eclipse.glsp.graph.GBoundsAware;
import org.eclipse.glsp.graph.GModelElement;
import org.eclipse.glsp.graph.GPoint;
import org.eclipse.glsp.graph.util.GraphUtil;
import org.eclipse.glsp.server.utils.GModelUtil;

public final class GeometryUtil {
    private GeometryUtil() {
    }

    public static GPoint absoluteToRelative(GPoint absolutePoint, GBoundsAware modelElement) {
        GPoint relativeToParent;
        if (modelElement == null) {
            return GraphUtil.copy((GPoint)absolutePoint);
        }
        Object parentElement = modelElement instanceof GModelElement ? ((GModelElement)modelElement).getParent() : modelElement.eContainer();
        if (parentElement == null) {
            relativeToParent = GraphUtil.copy((GPoint)absolutePoint);
        } else {
            if (!(parentElement instanceof GBoundsAware)) {
                throw new IllegalArgumentException("The element is not part of a GBoundsAware hierarchy: " + String.valueOf(modelElement));
            }
            relativeToParent = GeometryUtil.absoluteToRelative(absolutePoint, (GBoundsAware)parentElement);
        }
        double x = modelElement.getPosition() == null ? 0.0 : modelElement.getPosition().getX();
        double y = modelElement.getPosition() == null ? 0.0 : modelElement.getPosition().getY();
        return GraphUtil.point((double)(relativeToParent.getX() - x), (double)(relativeToParent.getY() - y));
    }

    public static void shift(List<GModelElement> elements, GPoint offset) {
        GModelUtil.filterByType(elements, GBoundsAware.class).forEach(boundsAware -> {
            boundsAware.getPosition().setX(boundsAware.getPosition().getX() + offset.getX());
            boundsAware.getPosition().setY(boundsAware.getPosition().getY() + offset.getY());
        });
    }
}

