/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.emf;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.glsp.server.actions.ActionDispatcher;
import org.eclipse.glsp.server.actions.GhostElement;
import org.eclipse.glsp.server.actions.TriggerElementCreationAction;
import org.eclipse.glsp.server.actions.TriggerNodeCreationAction;
import org.eclipse.glsp.server.emf.EMFOperationHandler;
import org.eclipse.glsp.server.operations.CreateNodeOperation;
import org.eclipse.glsp.server.operations.CreateOperation;
import org.eclipse.glsp.server.operations.CreateOperationHandler;

public abstract class EMFCreateOperationHandler<T extends CreateOperation>
extends EMFOperationHandler<T>
implements CreateOperationHandler<T> {
    @Inject
    protected ActionDispatcher actionDispatcher;
    protected List<String> handledElementTypeIds;

    public EMFCreateOperationHandler(String ... elementTypeIds) {
        this(new ArrayList<String>(List.of(elementTypeIds)));
    }

    public EMFCreateOperationHandler(List<String> handledElementTypeIds) {
        this.handledElementTypeIds = handledElementTypeIds;
    }

    public List<String> getHandledElementTypeIds() {
        return this.handledElementTypeIds;
    }

    public void setHandledElementTypeIds(List<String> handledElementTypeIds) {
        this.handledElementTypeIds = handledElementTypeIds;
    }

    public List<TriggerElementCreationAction> getTriggerActions() {
        if (CreateNodeOperation.class.isAssignableFrom(this.getHandledOperationType())) {
            return this.getHandledElementTypeIds().stream().map(this::createTriggerNodeCreationAction).collect(Collectors.toList());
        }
        return super.getTriggerActions();
    }

    protected TriggerNodeCreationAction createTriggerNodeCreationAction(String elementTypeId) {
        return new TriggerNodeCreationAction(elementTypeId, this.createTriggerArgs(elementTypeId), this.createTriggerGhostElement(elementTypeId));
    }

    protected GhostElement createTriggerGhostElement(String elementTypeId) {
        return null;
    }

    protected Map<String, String> createTriggerArgs(String elementTypeId) {
        return null;
    }
}

