/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.editor.rules;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.mylyn.docs.intent.client.ui.editor.rules.ISequenceRule;

public class SequenceBlockRule
implements ISequenceRule {
    protected ISequenceRule begin;
    protected ISequenceRule end;
    protected boolean recursive;
    protected boolean isEOL;
    protected boolean isEOF;
    protected ISequenceRule spec;
    protected SequenceBlockRule[] ignoredBlocks;
    protected IToken token;

    public SequenceBlockRule(ISequenceRule begin, ISequenceRule end, ISequenceRule spec, IToken token) {
        this.begin = begin;
        this.end = end;
        this.recursive = false;
        this.isEOL = false;
        this.isEOF = false;
        this.spec = spec;
        this.ignoredBlocks = new SequenceBlockRule[0];
        this.token = token;
    }

    public SequenceBlockRule(ISequenceRule begin, ISequenceRule end, SequenceBlockRule[] ignoredBlocks, IToken token) {
        this.begin = begin;
        this.end = end;
        this.recursive = true;
        this.isEOL = false;
        this.isEOF = false;
        this.spec = null;
        this.ignoredBlocks = ignoredBlocks;
        this.token = token;
    }

    public IToken getSuccessToken() {
        return this.token;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        if (this.read(scanner) > 0) {
            return this.token;
        }
        return Token.UNDEFINED;
    }

    public int read(ICharacterScanner scanner) {
        if (this.read(this.begin, scanner) == 0) {
            return 0;
        }
        int shift = 0;
        int opened = 0;
        Boolean valid = null;
        while (valid == null) {
            int n = this.read(this.spec, scanner);
            if (n == 0) {
                n = this.read(this.end, scanner);
                if (n > 0) {
                    if (!this.recursive || opened == 0) {
                        valid = Boolean.TRUE;
                    } else {
                        --opened;
                    }
                } else {
                    n = this.read(this.begin, scanner);
                    if (n > 0) {
                        ++opened;
                    } else {
                        int i = 0;
                        while (i < this.ignoredBlocks.length && n == 0) {
                            SequenceBlockRule ignoredBlock = this.ignoredBlocks[i];
                            n = ignoredBlock.read(scanner);
                            ++i;
                        }
                    }
                    if (n == 0) {
                        n = 1;
                        int c = scanner.read();
                        valid = this.readEOF(c);
                    }
                }
            }
            shift += n;
        }
        if (!valid.booleanValue()) {
            while (shift > 0) {
                scanner.unread();
                --shift;
            }
        }
        return shift;
    }

    private int read(ISequenceRule sequence, ICharacterScanner scanner) {
        if (sequence != null) {
            return sequence.read(scanner);
        }
        return 0;
    }

    private Boolean readEOF(int c) {
        Boolean valid = null;
        if (c == 10) {
            if (this.isEOL) {
                valid = Boolean.TRUE;
            }
        } else if (c == -1) {
            valid = this.isEOF ? Boolean.TRUE : Boolean.FALSE;
        }
        return valid;
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        return this.evaluate(scanner);
    }
}

