/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.ide.builder;

import com.google.common.collect.Sets;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mylyn.docs.intent.collab.common.IntentRepositoryManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IntentBuilderDeltaVisitor
implements IResourceDeltaVisitor {
    private Set<IProject> openedProjects = Sets.newHashSet();
    private Set<IProject> closedProjects = Sets.newHashSet();

    IntentBuilderDeltaVisitor() {
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        switch (delta.getKind()) {
            case 1: {
                if (!(resource instanceof IProject) || !resource.isAccessible() || !((IProject)resource).hasNature("org.eclipse.mylyn.docs.intent.client.ui.ide.intentNature")) break;
                this.openedProjects.add((IProject)resource);
                break;
            }
            case 4: {
                if ((0x4000 & delta.getFlags()) != 0 && resource instanceof IProject && resource.isAccessible() && ((IProject)resource).hasNature("org.eclipse.mylyn.docs.intent.client.ui.ide.intentNature") && ((IProject)resource).isOpen()) {
                    this.openedProjects.add((IProject)resource);
                }
                if ((0x80000 & delta.getFlags()) == 0 || !(resource instanceof IProject)) break;
                if (resource.isAccessible() && ((IProject)resource).hasNature("org.eclipse.mylyn.docs.intent.client.ui.ide.intentNature")) {
                    this.openedProjects.add((IProject)resource);
                    break;
                }
                if (!IntentRepositoryManager.INSTANCE.isManagedProject(resource.getName())) break;
                this.closedProjects.add((IProject)resource);
                break;
            }
        }
        return true;
    }

    public Set<IProject> getOpenedProjects() {
        return this.openedProjects;
    }

    public Set<IProject> getClosedProjects() {
        return this.closedProjects;
    }
}

