/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.editor.completion;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentPairMatcher;
import org.eclipse.mylyn.docs.intent.client.ui.editor.completion.AbstractIntentCompletionProcessor;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.ReadOnlyException;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.core.compiler.TraceabilityIndex;
import org.eclipse.mylyn.docs.intent.core.compiler.TraceabilityIndexEntry;
import org.eclipse.mylyn.docs.intent.core.modelingunit.InstanciationInstruction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelingUnitCompletionProcessor
extends AbstractIntentCompletionProcessor {
    private RepositoryAdapter repositoryAdapter;

    public ModelingUnitCompletionProcessor(RepositoryAdapter repositoryAdapter) {
        this.repositoryAdapter = repositoryAdapter;
    }

    @Override
    protected ICompletionProposal[] computeCompletionProposals() {
        LinkedHashSet proposals = Sets.newLinkedHashSet();
        try {
            String text = this.document.get(0, this.offset);
            int startOffset = this.getLastIndexOf(text, Pattern.compile("@M"));
            if (startOffset > -1) {
                text = text.substring(startOffset);
            }
            text = this.removeInstructionsInsideClosedBrackets(text);
            String lastRelevantKeyWord = this.getLastRelevantKeyWord(text = this.removeEndedInstructions(text));
            if (lastRelevantKeyWord == null) {
                proposals.addAll(this.getProposalsForEmptyModelingUnit(true, ""));
            } else if ("".equals(lastRelevantKeyWord)) {
                proposals.addAll(this.getProposalsForEmptyModelingUnit(false, text));
            } else if ("new".equals(lastRelevantKeyWord)) {
                proposals.addAll(this.getProposalsForNewInstruction(text));
            } else if ("{".equals(lastRelevantKeyWord)) {
                proposals.addAll(this.getProposalsForStructuralFeatureAffectation(text));
            } else if ("=".equals(lastRelevantKeyWord) || "+=".equals(lastRelevantKeyWord)) {
                proposals.addAll(this.getProposalsForStructuralFeatureValue(text));
            }
        }
        catch (BadLocationException badLocationException) {
        }
        catch (ReadOnlyException readOnlyException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        if (proposals.isEmpty()) {
            proposals.add(this.createTemplateProposal("", "No completion available", "", "icon/outline/default.gif"));
        }
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    private Collection<? extends ICompletionProposal> getProposalsForEmptyModelingUnit(boolean isAtMUBeggining, String text) throws ReadOnlyException {
        LinkedHashSet proposals = Sets.newLinkedHashSet();
        String prefix = "\n\t";
        if (isAtMUBeggining) {
            prefix = "@M" + prefix;
        }
        if (text.trim().length() == 0 || "new".startsWith(text.trim())) {
            proposals.add(this.createTemplateProposal("new", "Declaration of a new entity", String.valueOf(prefix) + "new ${Type} {}", "icon/outline/modelingunit_new_element.png"));
        }
        TraceabilityIndex traceabilityIndex = this.getTraceabilityIndex();
        String contributionBeginning = text.trim();
        for (TraceabilityIndexEntry entry : traceabilityIndex.getEntries()) {
            for (InstanciationInstruction instruction : Iterables.filter((Iterable)entry.getContainedElementToInstructions().values(), InstanciationInstruction.class)) {
                if (instruction.getName() == null || contributionBeginning.length() != 0 && !instruction.getName().startsWith(contributionBeginning)) continue;
                String description = "Contribute to the " + instruction.getName() + " ";
                description = instruction.getMetaType() != null && instruction.getMetaType().getIntentHref() != null ? String.valueOf(description) + instruction.getMetaType().getIntentHref() : String.valueOf(description) + "entity";
                proposals.add(this.createTemplateProposal(String.valueOf(instruction.getName()) + " (contribution)", description, String.valueOf(prefix) + instruction.getName() + " {\n\t\t${}\n\t}", "icon/outline/modelingunit_contribution.png"));
            }
        }
        return proposals;
    }

    private Collection<? extends ICompletionProposal> getProposalsForNewInstruction(String text) throws ReadOnlyException {
        String classNameBeginning = text.substring(text.lastIndexOf("new")).replace("new", "").trim();
        return this.getProposalsForEClassifier(classNameBeginning);
    }

    private Collection<ICompletionProposal> getProposalsForStructuralFeatureAffectation(String text) throws ReadOnlyException {
        LinkedHashSet proposals = Sets.newLinkedHashSet();
        String contributionName = "";
        String featureNameBeginning = "";
        boolean isContribution = true;
        if (text.lastIndexOf("{") != -1) {
            contributionName = text.substring(0, text.lastIndexOf("{")).trim();
            featureNameBeginning = text.substring(text.lastIndexOf("{")).replace("{", "").trim();
            if (contributionName.contains("new")) {
                isContribution = false;
                contributionName = contributionName.substring(contributionName.lastIndexOf("new")).trim();
                if ((contributionName = contributionName.substring(contributionName.indexOf(" ")).trim()).contains(" ")) {
                    contributionName = contributionName.substring(0, contributionName.indexOf(" ")).trim();
                }
            }
        }
        if (isContribution) {
            this.getProposalsForContribution(proposals, contributionName, featureNameBeginning);
        } else {
            EClassifier classifierToConsider = this.getEClassifier(contributionName);
            if (classifierToConsider != null && classifierToConsider instanceof EClass) {
                for (EStructuralFeature feature : ((EClass)classifierToConsider).getEAllStructuralFeatures()) {
                    if (!(featureNameBeginning.length() == 0 | feature.getName().startsWith(featureNameBeginning))) continue;
                    proposals.add(this.createStructuralFeatureAffectationTemplateProposal(contributionName, feature));
                }
            }
        }
        return proposals;
    }

    private void getProposalsForContribution(Collection<ICompletionProposal> proposals, String contributionName, String featureNameBeginning) throws ReadOnlyException {
        TraceabilityIndex traceabilityIndex = this.getTraceabilityIndex();
        for (TraceabilityIndexEntry entry : traceabilityIndex.getEntries()) {
            for (InstanciationInstruction instruction : Iterables.filter((Iterable)entry.getContainedElementToInstructions().values(), InstanciationInstruction.class)) {
                if (!contributionName.equals(instruction.getName()) || instruction.getMetaType() == null || instruction.getMetaType().getResolvedType() == null) continue;
                for (EStructuralFeature feature : instruction.getMetaType().getResolvedType().getEAllStructuralFeatures()) {
                    if (featureNameBeginning.length() != 0 && !feature.getName().startsWith(featureNameBeginning)) continue;
                    proposals.add((ICompletionProposal)this.createStructuralFeatureAffectationTemplateProposal(contributionName, feature));
                }
            }
        }
    }

    private Collection<? extends ICompletionProposal> getProposalsForStructuralFeatureValue(String text) throws ReadOnlyException {
        EStructuralFeature featureToConsider;
        LinkedHashSet proposals = Sets.newLinkedHashSet();
        boolean isContribution = true;
        String classifierName = null;
        String featureName = null;
        String beginning = "";
        if (text.lastIndexOf("{") != -1) {
            classifierName = text.substring(0, text.lastIndexOf("{")).trim();
            featureName = text.substring(text.lastIndexOf("{")).replace("{", "").trim();
            if (featureName.contains("+=")) {
                beginning = featureName.substring(featureName.indexOf("+=") + 2).trim();
                featureName = featureName.substring(0, featureName.indexOf("+=")).trim();
            } else if (featureName.contains("=")) {
                beginning = featureName.substring(featureName.indexOf("=") + 1).trim();
                featureName = featureName.substring(0, featureName.indexOf("=")).trim();
            }
            if (classifierName.contains("new")) {
                isContribution = false;
                classifierName = classifierName.substring(classifierName.lastIndexOf("new")).trim();
                if ((classifierName = classifierName.substring(classifierName.indexOf(" ")).trim()).contains(" ")) {
                    classifierName = classifierName.substring(0, classifierName.indexOf(" ")).trim();
                }
            }
        }
        EClassifier classifierToConsider = null;
        if (isContribution) {
            TraceabilityIndex traceabilityIndex = this.getTraceabilityIndex();
            block0: for (TraceabilityIndexEntry entry : traceabilityIndex.getEntries()) {
                for (InstanciationInstruction instruction : Iterables.filter((Iterable)entry.getContainedElementToInstructions().values(), InstanciationInstruction.class)) {
                    if (!classifierName.equals(instruction.getName()) || instruction.getMetaType() == null || instruction.getMetaType().getResolvedType() == null) continue;
                    classifierToConsider = instruction.getMetaType().getResolvedType();
                    continue block0;
                }
            }
        } else {
            classifierToConsider = this.getEClassifier(classifierName);
        }
        if (classifierToConsider != null && classifierToConsider instanceof EClass && (featureToConsider = ((EClass)classifierToConsider).getEStructuralFeature(featureName)) != null && featureToConsider.getEType() != null && featureToConsider.getEType().getName() != null) {
            if (featureToConsider instanceof EAttribute) {
                String defaultAttributeValue = "";
                if (featureToConsider.getEType().getDefaultValue() != null) {
                    defaultAttributeValue = featureToConsider.getEType().getDefaultValue().toString();
                }
                proposals.add(this.createTemplateProposal("value (of type " + featureToConsider.getEType().getName() + ")", "Set a simple value of type " + featureToConsider.getEType().getName(), String.valueOf('\"') + defaultAttributeValue + "\";", "icon/outline/modelingunit_value.gif"));
            } else {
                proposals.add(this.createTemplateProposal("new Element (of type " + featureToConsider.getEType().getName() + ")", "Set this new Element as value for " + featureToConsider.getName(), "new " + featureToConsider.getEType().getName() + "{\n\t${}\n};", "icon/outline/modelingunit_new_element.png"));
                TraceabilityIndex traceabilityIndex = this.getTraceabilityIndex();
                for (TraceabilityIndexEntry entry : traceabilityIndex.getEntries()) {
                    for (InstanciationInstruction instruction : Iterables.filter((Iterable)entry.getContainedElementToInstructions().values(), InstanciationInstruction.class)) {
                        if (instruction.getName() == null || beginning.length() != 0 && !instruction.getName().startsWith(beginning) || instruction.getMetaType() == null || !featureToConsider.getEType().equals(instruction.getMetaType().getResolvedType()) && (!(featureToConsider.getEType() instanceof EClass) || !((EClass)featureToConsider.getEType()).isSuperTypeOf(instruction.getMetaType().getResolvedType()))) continue;
                        proposals.add(this.createTemplateProposal("Reference to " + instruction.getName(), "Set the " + instruction.getName() + " element as value for " + featureToConsider.getName(), instruction.getName(), "icon/outline/modelingunit_ref.png"));
                    }
                }
                if (featureToConsider.getEType().equals(EcorePackage.eINSTANCE.getEClassifier())) {
                    proposals.addAll(this.getProposalsForEClassifier(beginning));
                }
            }
        }
        return proposals;
    }

    private Collection<? extends ICompletionProposal> getProposalsForEClassifier(String classNameBeginning) throws ReadOnlyException {
        LinkedHashSet proposals = Sets.newLinkedHashSet();
        Iterator availablePackages = Iterables.filter((Iterable)this.getTraceabilityIndex().eResource().getResourceSet().getPackageRegistry().values(), EPackage.class).iterator();
        int i = 0;
        while (availablePackages.hasNext() && i < 100) {
            EPackage availablePackage = (EPackage)availablePackages.next();
            for (EClassifier availableClass : availablePackage.getEClassifiers()) {
                if (availableClass.getName() == null || classNameBeginning.length() != 0 && !availableClass.getName().startsWith(classNameBeginning)) continue;
                proposals.add(this.createTemplateProposal(availableClass.getName(), availableClass.getEPackage().getNsURI(), availableClass.getName(), "icon/outline/modelingunit_new_element.png"));
                ++i;
            }
        }
        return proposals;
    }

    private String getLastRelevantKeyWord(String text) {
        int lastIndexOfSpaceCharacter;
        int lastNew = this.getLastIndexOf(text, Pattern.compile("new"));
        int lastOpeningBracket = text.lastIndexOf("{");
        int lastStructuralFeatureAffectation = text.lastIndexOf("=");
        int lastMultiValuedStructuralFeatureAffectation = text.lastIndexOf("+=");
        int lastKWIndex = Math.max(Math.max(lastStructuralFeatureAffectation, lastStructuralFeatureAffectation), Math.max(lastNew, lastOpeningBracket));
        if (lastKWIndex != -1) {
            if (lastKWIndex == lastNew) {
                return "new";
            }
            if (lastKWIndex == lastOpeningBracket) {
                return "{";
            }
            if (lastKWIndex == lastStructuralFeatureAffectation) {
                return "=";
            }
            if (lastKWIndex == lastMultiValuedStructuralFeatureAffectation) {
                return "+=";
            }
        }
        if ((lastIndexOfSpaceCharacter = this.lastIndexOfSpaceCharacter(text)) > -1) {
            String textWithoutLastPart = text.substring(0, lastIndexOfSpaceCharacter + 1).trim();
            if ((lastIndexOfSpaceCharacter = this.lastIndexOfSpaceCharacter(textWithoutLastPart)) > -1) {
                return textWithoutLastPart.substring(lastIndexOfSpaceCharacter + 1).trim();
            }
            return textWithoutLastPart;
        }
        return null;
    }

    private int lastIndexOfSpaceCharacter(String text) {
        int lastIndexOfSpace = text.lastIndexOf(" ");
        int lastIndexOfTab = text.lastIndexOf("\t");
        int lastIndexOfNewLine = text.lastIndexOf("\n");
        return Math.max(Math.max(lastIndexOfSpace, lastIndexOfTab), lastIndexOfNewLine);
    }

    private String removeInstructionsInsideClosedBrackets(String text) {
        Document tempDoc = new Document(text);
        IntentPairMatcher pairMatcher = new IntentPairMatcher();
        if (tempDoc.get().lastIndexOf("{") != -1) {
            IRegion match = pairMatcher.match((IDocument)tempDoc, tempDoc.get().lastIndexOf("{") + 1);
            try {
                while (tempDoc.get().lastIndexOf("{") != -1 && match != null) {
                    int beginLineToRemove = tempDoc.getLineOfOffset(match.getOffset());
                    int beginOffSettoRemove = tempDoc.getLineOffset(beginLineToRemove);
                    int endLineToRemove = tempDoc.getLineOfOffset(match.getOffset() + match.getLength());
                    int endOffsetToRemove = tempDoc.getLineOffset(endLineToRemove) + tempDoc.getLineLength(endLineToRemove);
                    String newDocContent = String.valueOf(tempDoc.get().substring(0, beginOffSettoRemove)) + tempDoc.get().substring(endOffsetToRemove);
                    tempDoc.set(newDocContent);
                    match = pairMatcher.match((IDocument)tempDoc, tempDoc.get().lastIndexOf("{") + 1);
                }
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
        return tempDoc.get();
    }

    private String removeEndedInstructions(String text) {
        Document tempDoc = new Document(text);
        try {
            while (tempDoc.get().lastIndexOf(";") > -1) {
                int lineToRemove = tempDoc.getLineOfOffset(tempDoc.get().lastIndexOf(";"));
                int lineToRemoveOffset = tempDoc.getLineOffset(lineToRemove);
                int lineToRemoveLength = tempDoc.getLineLength(lineToRemove);
                String newDocContent = String.valueOf(tempDoc.get().substring(0, lineToRemoveOffset)) + tempDoc.get().substring(lineToRemoveOffset + lineToRemoveLength);
                tempDoc.set(newDocContent);
            }
        }
        catch (BadLocationException badLocationException) {}
        return tempDoc.get();
    }

    private TemplateProposal createStructuralFeatureAffectationTemplateProposal(String contributionName, EStructuralFeature feature) {
        String affect = "=";
        if (feature.isMany()) {
            affect = "+" + affect;
        }
        String label = feature.getName();
        if (feature.getEType() != null && feature.getEType().getName() != null) {
            label = String.valueOf(label) + " : " + feature.getEType().getName();
            if (feature.getLowerBound() != 1 || feature.getUpperBound() != 1) {
                label = String.valueOf(label) + " [";
                if (feature.getLowerBound() == 0 && feature.getUpperBound() == 1) {
                    label = String.valueOf(label) + "?";
                } else {
                    label = String.valueOf(label) + feature.getLowerBound() + ",";
                    label = feature.getUpperBound() != -1 ? String.valueOf(label) + feature.getUpperBound() : String.valueOf(label) + "*";
                }
                label = String.valueOf(label) + "]";
            }
        }
        String description = "Set the value " + contributionName + "." + feature.getName();
        return this.createTemplateProposal(label, description, String.valueOf(feature.getName()) + " " + affect + " ${value};", "icon/outline/modelingunit_affect.png");
    }

    private TraceabilityIndex getTraceabilityIndex() throws ReadOnlyException {
        Resource traceabilityIndexResource = this.repositoryAdapter.getOrCreateResource("/COMPILATION/TRACES/TraceabilityIndex");
        if (traceabilityIndexResource.getContents().isEmpty() || !(traceabilityIndexResource.getContents().iterator().next() instanceof TraceabilityIndex)) {
            throw new IllegalArgumentException();
        }
        return (TraceabilityIndex)traceabilityIndexResource.getContents().iterator().next();
    }

    private EClassifier getEClassifier(String contributionName) throws ReadOnlyException {
        EClassifier classifierToConsider = null;
        Iterator availablePackages = Iterables.filter((Iterable)this.getTraceabilityIndex().eResource().getResourceSet().getPackageRegistry().values(), EPackage.class).iterator();
        while (availablePackages.hasNext() && classifierToConsider == null) {
            EPackage availablePackage = (EPackage)availablePackages.next();
            classifierToConsider = availablePackage.getEClassifier(contributionName);
        }
        return classifierToConsider;
    }

    @Override
    public String getContextType() {
        return "__Intent__modelingunit";
    }
}

