/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.compare.match;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.eclipse.emf.compare.FactoryException;
import org.eclipse.emf.compare.match.statistic.MetamodelFilter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.docs.intent.compare.match.AbstractGenericMatchEngineToCheckerBridge;
import org.eclipse.mylyn.docs.intent.compare.match.StatisticBasedSimilarityChecker;
import org.eclipse.mylyn.docs.intent.core.descriptionunit.DescriptionBloc;
import org.eclipse.mylyn.docs.intent.core.document.IntentStructuredElement;
import org.eclipse.mylyn.docs.intent.markup.markup.Block;
import org.eclipse.mylyn.docs.intent.markup.markup.Paragraph;
import org.eclipse.mylyn.docs.intent.markup.markup.StructureElement;
import org.eclipse.mylyn.docs.intent.markup.markup.Text;
import org.eclipse.mylyn.docs.intent.serializer.IntentSerializer;

public class IntentSimilarityChecker
extends StatisticBasedSimilarityChecker {
    private static final double MAX_SIMILARITY = 0.9999;
    private EObject localRoot;
    private EObject repositoryRoot;

    public IntentSimilarityChecker(MetamodelFilter metamodelFilter, AbstractGenericMatchEngineToCheckerBridge bridge, EObject localRoot, EObject repositoryRoot) {
        super(metamodelFilter, bridge);
        this.localRoot = localRoot;
        this.repositoryRoot = repositoryRoot;
    }

    public boolean isSimilar(EObject obj1, EObject obj2) throws FactoryException {
        boolean isSimilar = this.isSimilar(obj1, obj2, false);
        return isSimilar;
    }

    public boolean isSimilar(EObject obj1, EObject obj2, boolean useGenericMatcher) throws FactoryException {
        boolean isSimilar = false;
        boolean haveSpecificMatcher = false;
        if (useGenericMatcher) {
            return super.isSimilar(obj1, obj2);
        }
        if (this.areRoots(obj1, obj2)) {
            isSimilar = true;
            haveSpecificMatcher = true;
        } else if (obj1 instanceof DescriptionBloc && obj2 instanceof DescriptionBloc) {
            isSimilar = this.areSimilarDescriptionBlocs((DescriptionBloc)obj1, (DescriptionBloc)obj2);
            haveSpecificMatcher = true;
        } else if (obj1 instanceof IntentStructuredElement && obj2 instanceof IntentStructuredElement) {
            isSimilar = this.areSimilarStructuredElements((IntentStructuredElement)obj1, (IntentStructuredElement)obj2);
            haveSpecificMatcher = true;
        } else if (obj1 instanceof Paragraph && obj2 instanceof Paragraph) {
            isSimilar = this.areSimilarParagraphs((Paragraph)obj1, (Paragraph)obj2);
            haveSpecificMatcher = true;
        }
        if (!haveSpecificMatcher) {
            isSimilar = super.isSimilar(obj1, obj2);
        }
        return isSimilar;
    }

    public EObject fastLookup(EObject obj1) {
        if (obj1 == this.localRoot) {
            return this.repositoryRoot;
        }
        return super.fastLookup(obj1);
    }

    public double absoluteMetric(EObject obj1, EObject obj2) throws FactoryException {
        if (this.areRoots(obj1, obj2)) {
            return 0.9999;
        }
        if (obj1 instanceof IntentStructuredElement && obj2 instanceof IntentStructuredElement) {
            if (this.areSimilarStructuredElements((IntentStructuredElement)obj1, (IntentStructuredElement)obj2)) {
                return 1.0;
            }
            return 0.0;
        }
        return super.absoluteMetric(obj1, obj2);
    }

    private boolean areRoots(EObject obj1, EObject obj2) {
        return obj1 == this.localRoot && obj2 == this.repositoryRoot;
    }

    protected boolean areSimilarStructuredElements(IntentStructuredElement element1, IntentStructuredElement element2) throws FactoryException {
        Block title1 = element1.getTitle();
        Block title2 = element2.getTitle();
        if (title1 != null && title2 != null) {
            return this.isSimilar((EObject)title1, (EObject)title2);
        }
        if (title1 == null && title2 == null) {
            String element1Ser = new IntentSerializer().serialize((EObject)element1);
            String element2Ser = new IntentSerializer().serialize((EObject)element2);
            boolean isSimilar = this.isSimilar((EObject)element1, (EObject)element2, true);
            element1Ser.equals(element2Ser);
            return isSimilar;
        }
        return false;
    }

    protected double contentSimilarity(EObject obj1, EObject obj2) throws FactoryException {
        if (obj1 instanceof IntentStructuredElement && obj2 instanceof IntentStructuredElement) {
            return 0.97;
        }
        return super.contentSimilarity(obj1, obj2);
    }

    private double getIntentStructuredElementsSimilarity(IntentStructuredElement obj1, IntentStructuredElement obj2) {
        int numberOfCommonElements = 0;
        int numberOfElements = obj1.getContent().size();
        Iterator obj2Children = obj2.getContent().iterator();
        for (StructureElement obj1Child : obj1.getContent()) {
            if (!obj2Children.hasNext()) break;
            EObject obj2Child = (EObject)obj2Children.next();
            if (!new IntentSerializer().serialize((EObject)obj1Child).equals(new IntentSerializer().serialize(obj2Child))) continue;
            ++numberOfCommonElements;
        }
        if (numberOfElements != 0) {
            return numberOfCommonElements / numberOfElements;
        }
        return 0.0;
    }

    private boolean areSimilarDescriptionBlocs(DescriptionBloc obj1, DescriptionBloc obj2) {
        int positionInContainer2;
        int positionInContainer1 = obj1.eContainer().eContents().indexOf((Object)obj1);
        boolean haveSamePositionInContainer = positionInContainer1 == (positionInContainer2 = obj2.eContainer().eContents().indexOf((Object)obj2));
        return haveSamePositionInContainer;
    }

    private boolean areSimilarParagraphs(Paragraph obj1, Paragraph obj2) {
        LinkedHashSet obj1Texts = Sets.newLinkedHashSet((Iterable)Iterables.filter((Iterable)obj1.getContent(), Text.class));
        LinkedHashSet obj2Texts = Sets.newLinkedHashSet((Iterable)Iterables.filter((Iterable)obj2.getContent(), Text.class));
        String obj1AsString = "";
        for (Text t : obj1Texts) {
            obj1AsString = String.valueOf(obj1AsString) + t.getData();
        }
        String obj2AsString = "";
        for (Text t : obj2Texts) {
            obj2AsString = String.valueOf(obj2AsString) + t.getData();
        }
        return obj1AsString.equals(obj2AsString);
    }
}

