/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.ide.wizards;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentDocumentProvider;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentEditor;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentEditorDocument;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentPartitioner;
import org.eclipse.mylyn.docs.intent.client.ui.editor.configuration.IntentEditorConfiguration;
import org.eclipse.mylyn.docs.intent.client.ui.ide.Activator;
import org.eclipse.mylyn.docs.intent.client.ui.logger.IntentUiLogger;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class IntentTemplateWizardPage
extends WizardPage {
    private static final String TEMPLATES_EXTENSION_POINT = "org.eclipse.mylyn.docs.intent.client.ui.ide.template.extension";
    private static Map<String, String[]> templateExtensionsByName;
    private Label descriptionLabel;
    private Combo combo;
    private IDocument document;
    private SourceViewer sourceViewer;
    private IntentEditorConfiguration viewerConfiguration;

    public IntentTemplateWizardPage() {
        super("IntentTemplateWizardPage");
        this.setDescription("Initializes the Intent project using one of the installed templates.");
        IntentTemplateWizardPage.initializeRegistry();
    }

    public void createControl(Composite parent) {
        Composite control = new Composite(parent, 0);
        this.setControl((Control)control);
        control.setLayout((Layout)new GridLayout(2, false));
        Label extSelectionLabel = new Label(control, 0);
        extSelectionLabel.setText("Select an installed template: ");
        this.combo = new Combo(control, 0);
        this.combo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label infoLabel1 = new Label(control, 0);
        infoLabel1.setText("Description: ");
        this.descriptionLabel = new Label(control, 0);
        this.descriptionLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        Label infoLabel2 = new Label(control, 0);
        infoLabel2.setText("Preview: ");
        IntentEditor editor = new IntentEditor();
        this.document = new IntentEditorDocument(editor);
        IntentPartitioner partitioner = new IntentPartitioner(IntentDocumentProvider.LEGAL_CONTENT_TYPES);
        partitioner.connect(this.document);
        this.document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        this.viewerConfiguration = new IntentEditorConfiguration(editor, null);
        int styles = 512;
        styles |= 0x100;
        styles |= 2;
        styles |= 0x800;
        new Label(control, 0);
        this.sourceViewer = new SourceViewer(control, null, null, false, styles |= 0x10000);
        StyledText styledText = this.sourceViewer.getTextWidget();
        styledText.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.sourceViewer.configure((SourceViewerConfiguration)this.viewerConfiguration);
        this.sourceViewer.setEditable(false);
        Cursor arrowCursor = this.sourceViewer.getTextWidget().getDisplay().getSystemCursor(0);
        this.sourceViewer.getTextWidget().setCursor(arrowCursor);
        this.sourceViewer.getTextWidget().setCaret(null);
        this.sourceViewer.getTextWidget().setFont(JFaceResources.getTextFont());
        this.sourceViewer.setDocument(this.document);
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IntentTemplateWizardPage.this.handleSelectionChanged();
            }
        });
        for (String templateName : templateExtensionsByName.keySet()) {
            this.combo.add(templateName);
        }
        this.combo.select(0);
        this.handleSelectionChanged();
    }

    private void handleSelectionChanged() {
        String[] template = templateExtensionsByName.get(this.combo.getText());
        this.descriptionLabel.setText(template[0]);
        try {
            this.document.set(IntentTemplateWizardPage.getContent(template[1]));
        }
        catch (IOException error) {
            IntentUiLogger.logError((Throwable)error);
        }
        this.setPageComplete(this.validate());
    }

    public String getContent() {
        try {
            return IntentTemplateWizardPage.getContent(templateExtensionsByName.get(this.combo.getText())[1]);
        }
        catch (IOException e) {
            IntentUiLogger.logError((Throwable)e);
            return null;
        }
    }

    private static void initializeRegistry() {
        if (templateExtensionsByName == null) {
            IConfigurationElement[] elements;
            templateExtensionsByName = new HashMap<String, String[]>();
            IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(TEMPLATES_EXTENSION_POINT);
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                String name = element.getAttribute("name");
                String description = element.getAttribute("description");
                String template = element.getAttribute("template");
                if (IntentTemplateWizardPage.getURL(template) != null) {
                    templateExtensionsByName.put(name, new String[]{description, template});
                }
                ++n2;
            }
        }
    }

    private static String getContent(String filePath) throws IOException {
        URL url = IntentTemplateWizardPage.getURL(filePath);
        String result = "";
        InputStream fis = url.openStream();
        BufferedInputStream bis = null;
        BufferedReader dis = null;
        StringBuffer sb = new StringBuffer();
        bis = new BufferedInputStream(fis);
        dis = new BufferedReader(new InputStreamReader(bis));
        while (dis.ready()) {
            sb.append(String.valueOf(dis.readLine()) + "\n");
        }
        fis.close();
        bis.close();
        dis.close();
        result = sb.toString();
        return result;
    }

    private static URL getURL(String filePath) {
        return Activator.getDefault().getBundle().getEntry(filePath);
    }

    public boolean isPageComplete() {
        return this.validate();
    }

    private boolean validate() {
        boolean isValid;
        boolean bl = isValid = this.combo.getText() != null && !"".equals(this.combo.getText());
        if (isValid) {
            this.setErrorMessage(null);
        } else {
            this.setErrorMessage("A template must be selected");
        }
        return isValid;
    }
}

