/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.markup.builder.state;

import java.util.Stack;
import org.eclipse.mylyn.docs.intent.markup.builder.BuilderState;
import org.eclipse.mylyn.docs.intent.markup.builder.operation.HasAttributeCopyAttributes;
import org.eclipse.mylyn.docs.intent.markup.builder.state.SLink;
import org.eclipse.mylyn.docs.intent.markup.builder.state.SList;
import org.eclipse.mylyn.docs.intent.markup.builder.state.SText;
import org.eclipse.mylyn.docs.intent.markup.builder.state.utils.CharacterEscapedAnalyser;
import org.eclipse.mylyn.docs.intent.markup.markup.Block;
import org.eclipse.mylyn.docs.intent.markup.markup.Entity;
import org.eclipse.mylyn.docs.intent.markup.markup.Formatting;
import org.eclipse.mylyn.docs.intent.markup.markup.Image;
import org.eclipse.mylyn.docs.intent.markup.markup.Link;
import org.eclipse.mylyn.docs.intent.markup.markup.ListItem;
import org.eclipse.mylyn.docs.intent.markup.markup.ListType;
import org.eclipse.mylyn.docs.intent.markup.markup.MarkupFactory;
import org.eclipse.mylyn.docs.intent.markup.markup.Text;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.LinkAttributes;

public class SBlock
extends BuilderState {
    protected Block block;
    protected Text currentText;
    protected Stack<Formatting> spanStack;

    public SBlock(BuilderState previous, Block block) {
        super(previous);
        this.block = block;
        this.spanStack = new Stack();
    }

    protected void addAllFormatsFromStack(Text text) {
        if (!this.spanStack.isEmpty()) {
            for (Formatting format : this.spanStack) {
                text.getFormat().add((Object)format);
            }
            if (text.getFormat().contains((Object)Formatting.NONE)) {
                text.getFormat().remove((Object)Formatting.NONE);
            }
        }
    }

    public BuilderState endBlock() {
        return this.previousState();
    }

    public BuilderState beginBlock(DocumentBuilder.BlockType type, Attributes attributes) {
        BuilderState returnState = this;
        switch (type) {
            case QUOTE: 
            case CODE: {
                returnState = this.previousState().beginBlock(type, attributes);
                break;
            }
            case NUMERIC_LIST: 
            case BULLETED_LIST: {
                ListItem newItem = MarkupFactory.eINSTANCE.createListItem();
                new HasAttributeCopyAttributes(newItem).setValues(attributes);
                if (type == DocumentBuilder.BlockType.BULLETED_LIST) {
                    newItem.setListType(ListType.BULLETED);
                } else {
                    newItem.setListType(ListType.NUMERIC);
                }
                newItem.setIsList(true);
                if (this.block instanceof ListItem) {
                    ((ListItem)this.block).setIsList(true);
                    newItem.setImbricationLevel(((ListItem)this.block).getImbricationLevel() + 1);
                    ((ListItem)this.block).getItems().add((Object)newItem);
                }
                returnState = new SList((BuilderState)this, newItem);
                break;
            }
        }
        return returnState;
    }

    public BuilderState characters(String text) {
        Text txt = MarkupFactory.eINSTANCE.createText();
        txt.setData(text);
        this.addAllFormatsFromStack(txt);
        this.currentText = txt;
        this.block.getContent().add((Object)txt);
        return new SText(this, txt);
    }

    public BuilderState charactersUnescaped(String literal) {
        SBlock returnState = null;
        if (CharacterEscapedAnalyser.isLinkDeclaration(literal)) {
            Link newLink = MarkupFactory.eINSTANCE.createLink();
            newLink.setHrefOrHashName(CharacterEscapedAnalyser.getLinkHref(literal));
            newLink.setHasBeenDeclaredWithHTMLSyntax(true);
            String linkTitle = CharacterEscapedAnalyser.getLinkTitle(literal);
            if (linkTitle.length() > 0) {
                Attributes linkAttributes = new Attributes();
                linkAttributes.setTitle(linkTitle);
                new HasAttributeCopyAttributes(newLink).setValues(linkAttributes);
            }
            Block linkName = MarkupFactory.eINSTANCE.createBlock();
            newLink.setName(linkName);
            this.block.getContent().add((Object)newLink);
            returnState = new SLink(this, newLink.getName(), newLink);
        }
        if (CharacterEscapedAnalyser.isLineBreak(literal)) {
            Text text = MarkupFactory.eINSTANCE.createText();
            text.setData("");
            text.setLineBreak(true);
            this.block.getContent().add((Object)text);
            returnState = this;
        }
        if (CharacterEscapedAnalyser.isTabulation(literal)) {
            Entity entity = MarkupFactory.eINSTANCE.createEntity();
            entity.setData("<dd/>");
            entity.setLineBreak(false);
            this.block.getContent().add((Object)entity);
            returnState = this;
        }
        if (returnState != null) {
            return returnState;
        }
        return super.charactersUnescaped(literal);
    }

    public BuilderState lineBreak() {
        if (this.block.getContent().size() > 0 && this.block.getContent().get(this.block.getContent().size() - 1) instanceof Text) {
            ((Text)this.block.getContent().get(this.block.getContent().size() - 1)).setLineBreak(true);
        }
        return this;
    }

    public BuilderState entityReference(String entity) {
        Entity newEntity = MarkupFactory.eINSTANCE.createEntity();
        newEntity.setData(entity);
        this.addAllFormatsFromStack(newEntity);
        this.block.getContent().add((Object)newEntity);
        return new SText(this, newEntity);
    }

    public BuilderState beginSpan(DocumentBuilder.SpanType type, Attributes attributes) {
        BuilderState returnState = null;
        if (type == DocumentBuilder.SpanType.LINK) {
            LinkAttributes linkAttributes = (LinkAttributes)attributes;
            Link link = MarkupFactory.eINSTANCE.createLink();
            link.setHrefOrHashName(linkAttributes.getHref());
            link.setHasBeenDeclaredWithHTMLSyntax(false);
            new HasAttributeCopyAttributes(link).setValues(attributes);
            Block linkName = MarkupFactory.eINSTANCE.createBlock();
            link.setName(linkName);
            this.block.getContent().add((Object)link);
            returnState = new SLink(this, linkName, link);
        } else {
            if (!this.spanStack.contains((Object)Formatting.get(type.name().toLowerCase()))) {
                this.spanStack.add(Formatting.get(type.name().toLowerCase()));
            }
            if (this.currentText != null && this.currentText.getData() == null) {
                this.currentText.getFormat().add((Object)Formatting.get(type.name().toLowerCase()));
                if (this.currentText.getFormat().contains((Object)Formatting.NONE)) {
                    this.currentText.getFormat().remove((Object)Formatting.NONE);
                }
                returnState = new SText(this, this.currentText);
            } else {
                Text txt = MarkupFactory.eINSTANCE.createText();
                if (txt.getFormat().contains((Object)Formatting.NONE)) {
                    txt.getFormat().remove((Object)Formatting.NONE);
                }
                txt.getFormat().add((Object)Formatting.get(type.name().toLowerCase()));
                this.addAllFormatsFromStack(txt);
                new HasAttributeCopyAttributes(txt).setValues(attributes);
                this.block.getContent().add((Object)txt);
                this.currentText = txt;
                returnState = new SText(this, txt);
            }
        }
        return returnState;
    }

    public BuilderState endSpan() {
        this.spanStack.pop();
        return this;
    }

    public BuilderState image(Attributes attributes, String url) {
        Image img = MarkupFactory.eINSTANCE.createImage();
        img.setUrl(url);
        new HasAttributeCopyAttributes(img).setValues(attributes);
        this.block.getContent().add((Object)img);
        return this;
    }

    public BuilderState imageLink(Attributes attributes, Attributes imageAttributes, String href, String imageUrl) {
        Image img = MarkupFactory.eINSTANCE.createImage();
        img.setUrl(imageUrl);
        new HasAttributeCopyAttributes(img).setValues(attributes);
        this.block.getContent().add((Object)img);
        return this;
    }

    public BuilderState link(Attributes attributes, String hrefOrHashName, String text) {
        Link lnk = MarkupFactory.eINSTANCE.createLink();
        lnk.setHrefOrHashName(hrefOrHashName);
        Text linkNameContent = MarkupFactory.eINSTANCE.createText();
        linkNameContent.setData(text);
        Block linkName = MarkupFactory.eINSTANCE.createBlock();
        linkName.getContent().add((Object)linkNameContent);
        lnk.setName(linkName);
        lnk.setHasBeenDeclaredWithHTMLSyntax(false);
        new HasAttributeCopyAttributes(lnk).setValues(attributes);
        this.block.getContent().add((Object)lnk);
        return super.link(attributes, hrefOrHashName, text);
    }

    public BuilderState endHeading() {
        return this.previousState();
    }
}

