/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.collab.common.internal.repository.contribution;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import org.eclipse.mylyn.docs.intent.collab.common.internal.repository.contribution.IntentRepositoryManagerContributionDescriptor;
import org.eclipse.mylyn.docs.intent.collab.common.repository.contribution.IntentRepositoryManagerContribution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntentRepositoryManagerContributionRegistry {
    private static final Map<IntentRepositoryManagerContributionDescriptor, IntentRepositoryManagerContribution> declaredRepositoryManagerContributions = Maps.newLinkedHashMap();

    private IntentRepositoryManagerContributionRegistry() {
    }

    public static Collection<IntentRepositoryManagerContribution> getRepositoryManagerContributions() {
        for (Map.Entry<IntentRepositoryManagerContributionDescriptor, IntentRepositoryManagerContribution> descriptorToContribution : declaredRepositoryManagerContributions.entrySet()) {
            if (descriptorToContribution.getValue() != null) continue;
            descriptorToContribution.setValue(descriptorToContribution.getKey().createRepositoryManagerContribution());
        }
        return declaredRepositoryManagerContributions.values();
    }

    public static void addRepositoryManagerContribution(IntentRepositoryManagerContributionDescriptor IntentRepositoryManagerContributionDescriptor2) {
        declaredRepositoryManagerContributions.put(IntentRepositoryManagerContributionDescriptor2, null);
    }

    public static void removeExtension(String extensionClassName) {
        for (IntentRepositoryManagerContributionDescriptor extension : declaredRepositoryManagerContributions.keySet()) {
            if (!extension.getExtensionClassName().equals(extensionClassName)) continue;
            declaredRepositoryManagerContributions.remove(extension);
        }
    }

    public static void clearContributedRepositoryManagerContributions() {
        declaredRepositoryManagerContributions.clear();
    }
}

