/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.compiler.generator.modelgeneration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.mylyn.docs.intent.client.compiler.errors.CompilationErrorType;
import org.eclipse.mylyn.docs.intent.client.compiler.errors.CompilationException;
import org.eclipse.mylyn.docs.intent.client.compiler.errors.InvalidValueException;
import org.eclipse.mylyn.docs.intent.client.compiler.errors.ResolveException;
import org.eclipse.mylyn.docs.intent.client.compiler.generator.modelgeneration.ModelingUnitGenerator;
import org.eclipse.mylyn.docs.intent.client.compiler.generator.modellinking.ModelingUnitLinkResolver;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationMessageType;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationStatus;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationStatusSeverity;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilerFactory;
import org.eclipse.mylyn.docs.intent.core.compiler.UnresolvedReferenceHolder;
import org.eclipse.mylyn.docs.intent.core.document.IntentGenericElement;
import org.eclipse.mylyn.docs.intent.core.document.UnitInstruction;
import org.eclipse.mylyn.docs.intent.core.modelingunit.AbstractValue;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ModelingUnitFactory;
import org.eclipse.mylyn.docs.intent.core.modelingunit.StructuralFeatureAffectation;
import org.eclipse.mylyn.docs.intent.core.modelingunit.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StructuralFeatureGenerator {
    private static final String COMPILATION_EXCEPTION_MESSAGE_FEATURE = "The feature ";

    private StructuralFeatureGenerator() {
    }

    public static void generateFeatureAndAddToClass(StructuralFeatureAffectation affectation, EObject eClass, ModelingUnitLinkResolver linkResolver, ModelingUnitGenerator modelingUnitGenerator) {
        ModelingUnitGenerator.clearCompilationStatus((IntentGenericElement)affectation);
        try {
            EStructuralFeature feature = linkResolver.resolveEStructuralFeature(affectation, eClass.eClass());
            if (feature == null || feature.getEType() == null) {
                modelingUnitGenerator.getInformationHolder().registerCompilationExceptionAsCompilationStatus(new CompilationException((UnitInstruction)affectation, CompilationErrorType.INVALID_REFERENCE_ERROR, COMPILATION_EXCEPTION_MESSAGE_FEATURE + feature.getName() + " is derived and cannot be set."));
                feature.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
            }
            TypeReference resolvedMetaType = ModelingUnitFactory.eINSTANCE.createTypeReference();
            resolvedMetaType.setTypeName(feature.getEType().getName());
            affectation.setMetaType(resolvedMetaType);
            if (!feature.isDerived()) {
                ArrayList<Object> generatedValues = new ArrayList<Object>();
                for (AbstractValue value : affectation.getValues()) {
                    for (Object generatedValue : (List)modelingUnitGenerator.doSwitch((EObject)value)) {
                        if (generatedValue instanceof UnresolvedReferenceHolder) {
                            UnresolvedReferenceHolder referenceHolder = (UnresolvedReferenceHolder)generatedValue;
                            referenceHolder.setConcernedFeature(feature);
                            if (feature instanceof EReference) {
                                referenceHolder.setContainmentReference(((EReference)feature).isContainment());
                            } else {
                                referenceHolder.setContainmentReference(true);
                            }
                            modelingUnitGenerator.getInformationHolder().addUnresolvedReference(eClass, referenceHolder);
                            continue;
                        }
                        generatedValues.add(generatedValue);
                    }
                }
                StructuralFeatureGenerator.setFeatureValueInElement((UnitInstruction)affectation, eClass, feature, generatedValues);
            } else {
                CompilationStatus status = CompilerFactory.eINSTANCE.createCompilationStatus();
                status.setMessage(COMPILATION_EXCEPTION_MESSAGE_FEATURE + affectation.getName() + " is undefined for type " + eClass.eClass());
                status.setTarget((IntentGenericElement)affectation);
                status.setSeverity(CompilationStatusSeverity.ERROR);
                status.setType(CompilationMessageType.VALIDATION_ERROR);
                affectation.getCompilationStatus().add((Object)status);
            }
        }
        catch (InvalidValueException e) {
            modelingUnitGenerator.getInformationHolder().registerCompilationExceptionAsCompilationStatus(new CompilationException(e.getInvalidInstruction(), CompilationErrorType.INVALID_VALUE_ERROR, e.getMessage()));
        }
        catch (ResolveException e) {
            modelingUnitGenerator.getInformationHolder().registerCompilationExceptionAsCompilationStatus(new CompilationException(e.getInvalidInstruction(), CompilationErrorType.INVALID_REFERENCE_ERROR, e.getMessage()));
        }
    }

    public static void setFeatureValueInElement(UnitInstruction unitInstruction, EObject element, EStructuralFeature feature, List<Object> values) throws InvalidValueException {
        Object finalValueToSet = null;
        if (values.size() > 0) {
            if (feature.getUpperBound() > 1 || feature.getUpperBound() == -1) {
                BasicEList newValuesList = new BasicEList();
                if (element.eGet(feature) != null) {
                    newValuesList.addAll((Collection)((EList)element.eGet(feature)));
                }
                newValuesList.addAll(values);
                finalValueToSet = newValuesList;
            } else {
                finalValueToSet = values.get(0);
            }
            if (finalValueToSet != null) {
                StructuralFeatureGenerator.checkValueType(unitInstruction, feature, finalValueToSet);
                try {
                    element.eSet(feature, finalValueToSet);
                }
                catch (NullPointerException nullPointerException) {
                    System.err.println("FOR ELEMENT " + feature.getName() + "-" + "/" + finalValueToSet + "-" + feature.getContainerClass().getName());
                    System.err.println(element.eGet(feature));
                }
            }
        }
    }

    private static void checkValueType(UnitInstruction unitInstruction, EStructuralFeature feature, Object value) throws InvalidValueException {
        EClassifier type = feature.getEType();
        if (!(type instanceof EDataType)) {
            if (value instanceof Collection) {
                for (Object element : (Collection)value) {
                    if (!(element instanceof EObject) || StructuralFeatureGenerator.isInstanceOf((EObject)element, type)) continue;
                    throw new InvalidValueException(unitInstruction, COMPILATION_EXCEPTION_MESSAGE_FEATURE + feature.getName() + " cannot handle type " + element.getClass().getSimpleName() + ". ");
                }
            } else if (value instanceof EObject && !StructuralFeatureGenerator.isInstanceOf((EObject)value, type)) {
                throw new InvalidValueException(unitInstruction, COMPILATION_EXCEPTION_MESSAGE_FEATURE + feature.getName() + " cannot handle type " + value.getClass().getSimpleName() + ". ");
            }
        }
    }

    private static boolean isInstanceOf(EObject object, EClassifier type) {
        EClass actualType = object.eClass();
        return type.equals(actualType) || actualType.getEAllSuperTypes().contains((Object)type);
    }
}

