/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.editor.quickfix;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.ICompareContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.EMFCompareStructureMergeViewer;
import org.eclipse.emf.compare.ide.ui.internal.util.EMFCompareEditingDomain;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentEditorDocument;
import org.eclipse.mylyn.docs.intent.client.ui.editor.quickfix.AbstractIntentFix;
import org.eclipse.mylyn.docs.intent.client.ui.editor.quickfix.IntentCompareConfiguration;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.compare.utils.EMFCompareUtils;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationStatus;
import org.eclipse.mylyn.docs.intent.core.compiler.StructuralFeatureChangeStatus;
import org.eclipse.mylyn.docs.intent.core.compiler.SynchronizerCompilationStatus;
import org.eclipse.swt.widgets.Composite;

public class EMFCompareFix
extends AbstractIntentFix {
    private static final String COMPARE_EDITOR_TITLE = "Comparing Intent Document and Working Copy";
    private ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);

    public EMFCompareFix(Annotation annotation) {
        super(annotation);
    }

    protected void applyFix(RepositoryAdapter repositoryAdapter, IntentEditorDocument document) {
        String workingCopyResourceURI = ((SynchronizerCompilationStatus)this.syncAnnotation.getCompilationStatus()).getWorkingCopyResourceURI().replace("\"", "");
        String generatedResourceURI = ((SynchronizerCompilationStatus)this.syncAnnotation.getCompilationStatus()).getCompiledResourceURI().replace("\"", "");
        Resource generatedResource = repositoryAdapter.getResource(generatedResourceURI);
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource workingCopyResource = rs.getResource(URI.createURI((String)workingCopyResourceURI), true);
        Comparison comparison = EMFCompareUtils.compare((Notifier)generatedResource, (Notifier)workingCopyResource);
        IntentCompareConfiguration compareConfig = new IntentCompareConfiguration(generatedResource, workingCopyResource);
        compareConfig.setProperty("org.eclipse.emf.compare.ide.ui.COMPARE.RESULT", comparison);
        compareConfig.setProperty("org.eclipse.emf.compare.ide.ui.EDITING_DOMAIN", new EMFCompareEditingDomain(comparison, (Notifier)generatedResource, (Notifier)workingCopyResource, null));
        IntentCompareEditorInput input = new IntentCompareEditorInput(compareConfig, comparison);
        compareConfig.setContainer((ICompareContainer)input);
        input.setTitle("Comparing Intent Document and Working Copy (" + workingCopyResourceURI + ")");
        CompareUI.openCompareDialog((CompareEditorInput)input);
    }

    public String getDisplayString() {
        return "See differences in Compare Editor";
    }

    class IntentCompareEditorInput
    extends CompareEditorInput {
        private Object selection;

        public IntentCompareEditorInput(CompareConfiguration configuration, Comparison comparison) {
            EObject element;
            Match match;
            super(configuration);
            this.selection = comparison;
            CompilationStatus status = EMFCompareFix.this.syncAnnotation.getCompilationStatus();
            if (status instanceof StructuralFeatureChangeStatus && (match = comparison.getMatch(element = ((StructuralFeatureChangeStatus)status).getCompiledElement())) != null && !match.getDifferences().isEmpty()) {
                this.selection = match.getDifferences().get(0);
            }
        }

        protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            return (IDiffElement)EMFCompareFix.this.adapterFactory.adapt(this.selection, IDiffElement.class);
        }

        public Viewer createDiffViewer(Composite parent) {
            return new EMFCompareStructureMergeViewer(parent, this.getCompareConfiguration());
        }
    }
}

