/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.exporter.ui.popup.actions;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.mylyn.docs.intent.core.document.IntentDocument;
import org.eclipse.mylyn.docs.intent.core.document.IntentStructuredElement;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ExportOptionsDialog
extends Dialog {
    private String exportedIntentDocumentName = "Intent Documentation";
    private String targetFolderLocation;
    private Text intentDocumentNameText;
    private Text exportLocationText;
    private Button okButton;
    private final IntentStructuredElement intentElement;

    public ExportOptionsDialog(Shell parent, String defaultTargetFolderLocation, IntentStructuredElement intentElement) {
        super(parent);
        this.targetFolderLocation = defaultTargetFolderLocation;
        this.intentElement = intentElement;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout(2, false);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        Group group = new Group(composite, 0);
        group.setText("Export folder location");
        Label label = new Label((Composite)group, 0);
        label.setText("The location in which the HTML files will be stored.");
        new Label((Composite)group, 0);
        this.exportLocationText = new Text((Composite)group, 0);
        this.exportLocationText.setText(this.targetFolderLocation);
        this.exportLocationText.setLayoutData((Object)gridData);
        Button button = new Button((Composite)group, 0);
        button.setText("Browse...");
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IContainer[] openFolderSelection = WorkspaceResourceDialog.openFolderSelection((Shell)ExportOptionsDialog.this.getShell(), (String)"Select Export folder location", (String)"message", (boolean)false, null, null);
                if (openFolderSelection.length == 1) {
                    ExportOptionsDialog.this.exportLocationText.setText(new File(openFolderSelection[0].getLocationURI()).getAbsolutePath().toString());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)gridData);
        if (this.intentElement instanceof IntentDocument) {
            Group group2 = new Group(composite, 0);
            group2.setText("Exported Document Name");
            new Label((Composite)group2, 0);
            label.setText("This name will be used as a title of the exported documentation.");
            new Label((Composite)group, 0);
            GridData anyElementData = new GridData();
            anyElementData.horizontalAlignment = 4;
            anyElementData.grabExcessHorizontalSpace = true;
            this.intentDocumentNameText = new Text((Composite)group2, 2048);
            this.intentDocumentNameText.setTextLimit(255);
            this.intentDocumentNameText.setLayoutData((Object)anyElementData);
            this.intentDocumentNameText.setText(this.exportedIntentDocumentName);
            group2.setLayout((Layout)gridLayout);
            group2.setLayoutData((Object)gridData);
        }
        return composite;
    }

    public String getExportedIntentDocumentName() {
        return this.exportedIntentDocumentName;
    }

    public String getTargetFolderLocation() {
        return this.targetFolderLocation;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, "&" + IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void okPressed() {
        if (this.intentDocumentNameText != null) {
            this.exportedIntentDocumentName = this.intentDocumentNameText.getText() != null ? this.intentDocumentNameText.getText() : "Intent Documentation";
        }
        this.targetFolderLocation = this.exportLocationText.getText() != null ? this.exportLocationText.getText() : this.targetFolderLocation;
        super.okPressed();
    }

    protected void configureShell(Shell newShell) {
        newShell.setMinimumSize(new Point(800, 300));
        super.configureShell(newShell);
        newShell.setText("Export Intent Documentation - as HTML");
    }
}

