/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.internal.logger;

import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mylyn.docs.intent.client.ui.IntentEditorActivator;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IIntentLogger;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IntentLogger;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class EclipseBasedIntentLogger
implements IIntentLogger,
IEclipsePreferences.IPreferenceChangeListener {
    private ILog delegateLogger;
    private boolean shouldDisplayLifecycleInformations;

    public EclipseBasedIntentLogger() {
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode(IntentEditorActivator.getDefault().getBundle().getSymbolicName());
        if (node != null) {
            node.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
            this.shouldDisplayLifecycleInformations = node.getBoolean("org.eclipse.mylyn.docs.intent.client.ui.preferences.advanced_logging", false);
        } else {
            this.getBundleLogger().log((IStatus)new Status(2, "org.eclipse.mylyn.docs.intent.client.ui.IntentEditor", "Intent Logger: an error occured, logger will not react to preference changes"));
        }
    }

    public void log(IIntentLogger.LogType logType, String message) {
        this.log(logType, message, null);
    }

    public void log(IIntentLogger.LogType logType, String message, Throwable exception) {
        boolean shouldLog = true;
        int severity = 0;
        switch (logType) {
            case CRITICAL_ERROR: {
                severity = 4;
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Intent - An error occured", (String)message);
                break;
            }
            case ERROR: {
                severity = 4;
                break;
            }
            case WARNING: {
                severity = 2;
                break;
            }
            case INFO: {
                severity = 1;
                break;
            }
            case LIFECYCLE: {
                shouldLog = this.shouldDisplayLifecycleInformations;
                severity = 1;
                break;
            }
        }
        if (shouldLog) {
            Status status = null;
            status = exception != null ? new Status(severity, "org.eclipse.mylyn.docs.intent.client.ui.IntentEditor", message, exception) : new Status(severity, "org.eclipse.mylyn.docs.intent.client.ui.IntentEditor", message);
            this.getBundleLogger().log((IStatus)status);
        }
    }

    public void logError(Throwable throwable) {
        this.log(IIntentLogger.LogType.ERROR, throwable.getMessage(), throwable);
    }

    public void setDisplayLifecycleInformations(boolean value) {
        this.shouldDisplayLifecycleInformations = value;
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if ("org.eclipse.mylyn.docs.intent.client.ui.preferences.advanced_logging".equals(event.getKey())) {
            boolean newValue = false;
            if ("true".equals(event.getNewValue())) {
                newValue = true;
            }
            IntentLogger.getInstance().setDisplayLifecycleInformations(newValue);
        }
    }

    private ILog getBundleLogger() {
        if (this.delegateLogger == null) {
            this.delegateLogger = IntentEditorActivator.getDefault().getLog();
        }
        return this.delegateLogger;
    }
}

