/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.ide.repository;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Scanner;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.mylyn.docs.intent.collab.common.query.IntentDocumentQuery;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.ReadOnlyException;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.collab.ide.adapters.DefaultWorkspaceRepositoryStructurer;
import org.eclipse.mylyn.docs.intent.collab.ide.adapters.WorkspaceAdapter;
import org.eclipse.mylyn.docs.intent.collab.ide.repository.WorkspaceConfig;
import org.eclipse.mylyn.docs.intent.collab.ide.repository.WorkspaceRepository;
import org.eclipse.mylyn.docs.intent.core.document.IntentChapter;
import org.eclipse.mylyn.docs.intent.core.document.IntentDocument;
import org.eclipse.mylyn.docs.intent.core.document.IntentSection;
import org.eclipse.mylyn.docs.intent.core.document.IntentSubSectionContainer;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ModelingUnit;
import org.eclipse.mylyn.docs.intent.serializer.IntentSerializer;

public class IntentWorkspaceRepositoryStructurer
extends DefaultWorkspaceRepositoryStructurer {
    private static final String INTENT_BACKUP_FILE_NAME = ".intentbackup";
    private static final int INTENT_BACKUP_DELAY = 10000;
    private static final String IDENTIFIER_SEPARATOR = ".";

    public void structure(RepositoryAdapter repositoryAdapter) throws ReadOnlyException {
        super.structure(repositoryAdapter);
        WorkspaceAdapter workspaceAdapter = (WorkspaceAdapter)repositoryAdapter;
        IntentDocument document = new IntentDocumentQuery((RepositoryAdapter)workspaceAdapter).getOrCreateIntentDocument();
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode("org.eclipse.mylyn.docs.intent.client.ui");
        boolean backUpModeIsActive = node.getBoolean("org.eclipse.mylyn.docs.intent.client.ui.preferences.activate_backup", false);
        if (backUpModeIsActive) {
            this.saveTextualSerialization(workspaceAdapter, document);
        }
    }

    private void saveTextualSerialization(WorkspaceAdapter workspaceAdapter, IntentDocument document) {
        block14: {
            WorkspaceConfig workspaceConfig = ((WorkspaceRepository)workspaceAdapter.getRepository()).getWorkspaceConfig();
            String projectName = workspaceConfig.getRepositoryAbsolutePath().replace(workspaceConfig.getRepositoryRelativePath(), "").replaceFirst("/", "");
            IFile backUpFile = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).getFile(INTENT_BACKUP_FILE_NAME);
            try {
                boolean backupFileShouldBeUpdated;
                if (backUpFile.exists() && System.currentTimeMillis() <= backUpFile.getLocalTimeStamp() + 10000L) break block14;
                String newSerialization = new IntentSerializer().serialize((EObject)document);
                boolean bl = backupFileShouldBeUpdated = !backUpFile.exists();
                if (!backupFileShouldBeUpdated) {
                    InputStream previousContent = backUpFile.getContents();
                    try {
                        StringBuilder previousContentAsString = new StringBuilder();
                        Scanner previousContentScanner = new Scanner(previousContent);
                        while (previousContentScanner.hasNext()) {
                            previousContentAsString.append(String.valueOf(previousContentScanner.nextLine()) + "\n");
                        }
                        backupFileShouldBeUpdated = !previousContentAsString.toString().equals(newSerialization);
                    }
                    finally {
                        previousContent.close();
                    }
                }
                if (!backupFileShouldBeUpdated) break block14;
                ByteArrayInputStream intentDocumentAsText = new ByteArrayInputStream(newSerialization.getBytes());
                try {
                    if (!backUpFile.exists()) {
                        backUpFile.create((InputStream)intentDocumentAsText, true, (IProgressMonitor)new NullProgressMonitor());
                    } else if (!backUpFile.getContents().equals(intentDocumentAsText)) {
                        backUpFile.setContents((InputStream)intentDocumentAsText, true, true, (IProgressMonitor)new NullProgressMonitor());
                    }
                }
                finally {
                    intentDocumentAsText.close();
                }
            }
            catch (CoreException coreException) {
            }
            catch (IOException iOException) {}
        }
    }

    protected void splitElementAndSons(WorkspaceAdapter workspaceAdapter, EObject element) throws ReadOnlyException {
        if (this.isElementToSplit(element)) {
            String newResourcePath = "/INTENT/" + element.eClass().getName() + "/" + this.getIdentifierForElement(workspaceAdapter, element);
            boolean isInSameResourceThanContainer = this.isInSameResourceThanContainer(element);
            if (isInSameResourceThanContainer || !this.isStoredAtExpectedLocation(element, workspaceAdapter, newResourcePath)) {
                Resource newResource = workspaceAdapter.getOrCreateResource(newResourcePath);
                newResource.getContents().add((Object)element);
            }
            for (EObject containedElement : element.eContents()) {
                if (containedElement.eIsProxy()) continue;
                this.splitElementAndSons(workspaceAdapter, containedElement);
            }
        }
    }

    private String getIdentifierForElement(WorkspaceAdapter workspaceAdapter, EObject element) {
        String proposal = "";
        if (element instanceof IntentDocument) {
            return "IntentDocument";
        }
        EObject container = element;
        while (!(container instanceof IntentDocument)) {
            proposal = container instanceof ModelingUnit ? String.valueOf(((IntentSection)container.eContainer()).getModelingUnits().indexOf((Object)container) + 1) + IDENTIFIER_SEPARATOR + proposal : (container instanceof IntentSection ? String.valueOf(((IntentSubSectionContainer)container.eContainer()).getSubSections().indexOf((Object)container) + 1) + IDENTIFIER_SEPARATOR + proposal : (container instanceof IntentChapter ? String.valueOf(((IntentDocument)container.eContainer()).getChapters().indexOf((Object)container) + 1) + IDENTIFIER_SEPARATOR + proposal : String.valueOf(container.eContainer().eContents().indexOf((Object)container) + 1) + IDENTIFIER_SEPARATOR + proposal));
            container = container.eContainer();
        }
        proposal = proposal.substring(0, proposal.length() - 1);
        return proposal;
    }

    private boolean isStoredAtExpectedLocation(EObject element, WorkspaceAdapter workspaceAdapter, String expectedResourceLocation) {
        boolean isCorrectlySplit = true;
        try {
            isCorrectlySplit = isCorrectlySplit && element.eResource() == workspaceAdapter.getResource(expectedResourceLocation, false);
        }
        catch (Exception exception) {
            isCorrectlySplit = false;
        }
        return isCorrectlySplit || element instanceof IntentDocument;
    }

    private boolean isInSameResourceThanContainer(EObject element) {
        boolean isInSameResourceThanContainer = element.eResource() == null;
        isInSameResourceThanContainer = isInSameResourceThanContainer || element.eContainer() == null;
        boolean bl = isInSameResourceThanContainer = isInSameResourceThanContainer || element.eContainer().eResource() == element.eResource();
        return isInSameResourceThanContainer && !(element instanceof IntentDocument);
    }

    protected boolean isElementToSplit(EObject element) {
        boolean isElementToSplit;
        boolean bl = isElementToSplit = element instanceof IntentDocument || element instanceof IntentChapter || element instanceof IntentSection;
        return isElementToSplit || element instanceof ModelingUnit;
    }
}

